/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualThreadFactory.class);
    private static final Method ofVirtual;
    private static final Method name1;
    private static final Method name2;
    private static final Method factory;

    public static boolean isAvailable() {
        return factory != null;
    }

    public static ThreadFactory create(String prefix, Long start) {
        if (!VirtualThreadFactory.isAvailable()) {
            throw new IllegalStateException("Reflection thread factory not available!");
        }
        try {
            Object builder = ofVirtual.invoke(null, new Object[0]);
            prefix = "V-" + prefix;
            if (start != null) {
                name2.invoke(builder, prefix, start);
            } else {
                name1.invoke(builder, prefix);
            }
            return (ThreadFactory)factory.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("virtual thread factory failed!");
        }
    }

    static {
        Method virtual = null;
        Method n1 = null;
        Method n2 = null;
        Method f = null;
        try {
            virtual = Thread.class.getMethod("ofVirtual", new Class[0]);
            Class<?> clz = Class.forName(Thread.class.getName() + "$Builder");
            n1 = clz.getMethod("name", String.class);
            n2 = clz.getMethod("name", String.class, Long.TYPE);
            f = clz.getMethod("factory", new Class[0]);
            LOGGER.info("Virtual threads available.");
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Missing class {}, virtual threads are not available.", (Object)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("Missing method {}, virtual threads are not available", (Object)e.getMessage());
        }
        catch (SecurityException e) {
            LOGGER.info("{}, virtual threads are not available", (Object)e.getMessage());
        }
        ofVirtual = virtual;
        name1 = n1;
        name2 = n2;
        factory = f;
    }
}

