/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.util.Objects;
import org.eclipse.californium.elements.auth.AbstractExtensiblePrincipal;
import org.eclipse.californium.elements.auth.AdditionalInfo;

public class ApplicationPrincipal
extends AbstractExtensiblePrincipal<ApplicationPrincipal> {
    public static final ApplicationPrincipal ANONYMOUS = new ApplicationPrincipal("anonymous", true);
    private final String name;
    private final boolean anonymous;

    public ApplicationPrincipal(String name, boolean anonymous) {
        this.name = name;
        this.anonymous = anonymous;
    }

    private ApplicationPrincipal(String name, boolean anonymous, AdditionalInfo additionalInformation) {
        super(additionalInformation);
        this.name = name;
        this.anonymous = anonymous;
    }

    @Override
    public ApplicationPrincipal amend(AdditionalInfo additionalInfo) {
        return new ApplicationPrincipal(this.name, this.anonymous, additionalInfo);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "Application Prinicpal [" + this.name + "]";
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationPrincipal other = (ApplicationPrincipal)obj;
        if (this.anonymous != other.anonymous) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }
}

