/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.option.BlockOption;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;
import org.eclipse.californium.core.network.stack.BlockwiseTransferException;
import org.eclipse.californium.core.network.stack.KeyUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Block1BlockwiseStatus
extends BlockwiseStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(Block1BlockwiseStatus.class);
    private Request current;

    private Block1BlockwiseStatus(KeyUri keyUri, BlockwiseStatus.RemoveHandler removeHandler, Exchange exchange, Request request, int maxSize, int maxTcpBertBulkBlocks) {
        super(keyUri, removeHandler, exchange, request, maxSize, maxTcpBertBulkBlocks);
        this.current = request;
    }

    public static Block1BlockwiseStatus forOutboundRequest(KeyUri keyUri, BlockwiseStatus.RemoveHandler removeHandler, Exchange exchange, Request request, int maxTcpBertBulkBlocks) {
        Block1BlockwiseStatus status = new Block1BlockwiseStatus(keyUri, removeHandler, exchange, request, request.getPayloadSize(), maxTcpBertBulkBlocks);
        try {
            status.addBlock(request.getPayload(), request.getMessageSize());
            status.flipBlocksBuffer();
        }
        catch (BlockwiseTransferException ex) {
            LOGGER.warn("buffer overflow on start", ex);
        }
        return status;
    }

    public static Block1BlockwiseStatus forInboundRequest(KeyUri keyUri, BlockwiseStatus.RemoveHandler removeHandler, Exchange exchange, Request block, int maxBodySize, int maxTcpBertBulkBlocks) {
        int bufferSize = maxBodySize;
        if (block.getOptions().hasSize1()) {
            bufferSize = block.getOptions().getSize1();
        }
        Block1BlockwiseStatus status = new Block1BlockwiseStatus(keyUri, removeHandler, exchange, block, bufferSize, maxTcpBertBulkBlocks);
        return status;
    }

    public synchronized void addBlock(Request requestBlock) throws BlockwiseTransferException {
        int offset;
        if (requestBlock == null) {
            throw new NullPointerException("request block must not be null");
        }
        BlockOption block1 = requestBlock.getOptions().getBlock1();
        if (block1 == null) {
            throw new IllegalArgumentException("request block has no block1 option");
        }
        int from = this.getCurrentPosition();
        if (from != (offset = block1.getOffset())) {
            throw new BlockwiseTransferException("request block1 offset " + offset + " doesn't match the current position " + from + "!", CoAP.ResponseCode.REQUEST_ENTITY_INCOMPLETE);
        }
        this.addBlock(requestBlock.getPayload(), requestBlock.getMessageSize());
        if (block1.isM()) {
            this.setCurrentSzx(block1.getSzx());
            int size = block1.getSize();
            from = this.getCurrentPosition();
            if (from % size != 0) {
                throw new BlockwiseTransferException("Block1 buffer position " + from + " doesn't align with blocksize " + size + "!", CoAP.ResponseCode.REQUEST_ENTITY_INCOMPLETE);
            }
            this.setCurrentNum(from / size);
        }
    }

    public synchronized Request getNextRequestBlock(int blockSzx) throws BlockwiseTransferException {
        byte[] blockPayload;
        this.setCurrentSzx(blockSzx);
        int size = this.getCurrentSize();
        int from = this.getCurrentPosition();
        if (from % size != 0) {
            throw new BlockwiseTransferException("Block1 buffer position " + from + " doesn't align with blocksize " + size + "!");
        }
        boolean m = false;
        int bodySize = this.getBufferSize();
        int num = from / size;
        this.setCurrentNum(num);
        Request block = new Request(((Request)this.firstMessage).getCode());
        this.prepareOutgoingMessage(this.firstMessage, block, num == 0);
        if (num == 0) {
            if (!block.getOptions().hasSize1()) {
                block.getOptions().setSize1(bodySize);
            }
        } else {
            block.getOptions().removeSize1();
            block.getOptions().setIfNoneMatch(false);
        }
        if (0 < bodySize && from < bodySize && (blockPayload = this.getBlock(from, this.getCurrentPayloadSize())) != null) {
            m = from + blockPayload.length < bodySize;
            block.setPayload(blockPayload);
        }
        block.getOptions().setBlock1(blockSzx, m, num);
        this.setComplete(!m);
        this.current = block;
        return block;
    }

    public boolean cancelRequest() {
        if (this.complete()) {
            Request request = (Request)this.firstMessage;
            request.cancel();
            return true;
        }
        return false;
    }

    public synchronized boolean hasMatchingToken(Response response) {
        return response.getToken().equals(this.current.getToken());
    }
}

