/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.elements.util.DatagramWriter;

public final class TcpDataSerializer
extends DataSerializer {
    private static final byte[] EMPTY = new byte[2];

    @Override
    protected byte[] serializeEmpytMessage(Message message) {
        return EMPTY;
    }

    @Override
    protected byte[] serializeMessage(Message message) {
        DatagramWriter optionsAndPayloadWriter = new DatagramWriter();
        TcpDataSerializer.serializeOptionsAndPayload(optionsAndPayloadWriter, message.getOptions(), message.getPayload());
        optionsAndPayloadWriter.writeCurrentByte();
        int bodyLength = optionsAndPayloadWriter.size();
        int length = 0;
        int lengthSize = 0;
        if (bodyLength < 13) {
            length = bodyLength;
        } else if ((bodyLength -= 13) < 256) {
            length = 13;
            lengthSize = 1;
        } else if ((bodyLength -= 256) < 65536) {
            length = 14;
            lengthSize = 2;
        } else {
            length = 15;
            lengthSize = 4;
            bodyLength -= 65536;
        }
        byte[] token = message.getTokenBytes();
        DatagramWriter writer = new DatagramWriter(bodyLength + token.length + lengthSize);
        writer.write(length, 4);
        writer.write(token.length, 4);
        if (lengthSize > 0) {
            writer.write(bodyLength, 8 * lengthSize);
        }
        writer.write(message.getRawCode(), 8);
        writer.writeBytes(token);
        writer.write(optionsAndPayloadWriter);
        return writer.toByteArray();
    }
}

