/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.elements.util.Bytes;

public class Token
extends Bytes {
    public static final Token EMPTY = new Token(Bytes.EMPTY);

    public Token(byte[] token) {
        this(token, true);
    }

    private Token(byte[] token, boolean copy) {
        super(token, 8, copy);
    }

    @Override
    public String toString() {
        return "Token=" + this.getAsString();
    }

    public static Token fromProvider(byte[] token) {
        if (token == null) {
            throw new NullPointerException("token must not be null");
        }
        if (token.length == 0) {
            return EMPTY;
        }
        return new Token(token, false);
    }

    public static Token create(byte[] token) {
        if (token == null) {
            return null;
        }
        if (token.length == 0) {
            return EMPTY;
        }
        return new Token(token);
    }
}

