/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;

public final class SignedMessage {
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private final byte[] signatureEncoded;
    private final SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    private SignedMessage(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] signatureEncoded) {
        if (signatureAndHashAlgorithm == null) {
            throw new NullPointerException("signature and hash algorithm cannot be null");
        }
        if (signatureEncoded == null) {
            throw new NullPointerException("signature cannot be null");
        }
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signatureEncoded = signatureEncoded;
    }

    public static SignedMessage fromReader(DatagramReader reader) {
        int hashAlgorithm = reader.read(8);
        int signatureAlgorithm = reader.read(8);
        SignatureAndHashAlgorithm signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
        byte[] signatureEncoded = reader.readVarBytes(16);
        return new SignedMessage(signAndHash, signatureEncoded);
    }

    public void verifySignature(PublicKey serverPublicKey, byte[] ... data) throws GeneralSecurityException {
        ThreadLocalSignature localSignature = this.signatureAndHashAlgorithm.getThreadLocalSignature();
        Signature signature = (Signature)localSignature.currentWithCause();
        signature.initVerify(serverPublicKey);
        for (byte[] d : data) {
            if (d == null) continue;
            signature.update(d);
        }
        if (signature.verify(this.signatureEncoded)) {
            if (JceProviderUtil.isEcdsaVulnerable() && this.signatureAndHashAlgorithm.getSignature() == SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA) {
                Asn1DerDecoder.checkEcDsaSignature(this.signatureEncoded, serverPublicKey);
            }
            return;
        }
        throw new GeneralSecurityException("Signature verification failed!");
    }
}

