/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlGenerator.class);
    private static final char[] ESCAPE = "\"'<>&".toCharArray();

    public static String createForwardPage(String link, String title) {
        StringBuilder page = new StringBuilder();
        page.append("<!DOCTYPE html>\n");
        page.append("<html>\n");
        page.append("<head>\n");
        page.append("<meta charset=\"utf-8\"/>\n");
        page.append("<meta http-equiv=\"refresh\" content=\"0; url=").append(link).append("\" >");
        page.append("<title>Cloudcoap To S3 proxy</title>\n");
        page.append("<title>").append(title).append("</title>\n");
        page.append("</head>\n");
        page.append("<body>\n");
        page.append("<h2>").append(title).append("</h2>\n");
        page.append("<a href=\"").append(link).append("\">");
        page.append(link);
        page.append("</a>:");
        page.append("</body>\n");
        page.append("</html>\n");
        return page.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String createListPage(String pagePath, String base, String title, Set<WebLink> links, String linkAttribute, String ... attributes) {
        if (title.isEmpty()) {
            title = "List";
        } else if (Character.isLowerCase(title.charAt(0))) {
            title = Character.toUpperCase(title.charAt(0)) + title.substring(1).toLowerCase();
        }
        StringBuilder page = new StringBuilder();
        page.append("<!DOCTYPE html>\n");
        page.append("<html>\n");
        page.append("<head>\n");
        page.append("<meta charset=\"utf-8\"/>\n");
        page.append("<title>");
        page.append(title);
        page.append("</title>\n");
        page.append("</head>\n");
        page.append("<body>\n");
        page.append("<h2>");
        page.append(title + ":");
        page.append("</h2>\n");
        if (!links.isEmpty()) {
            String[] root = null;
            for (WebLink link : links) {
                String uri = link.getURI();
                String[] path = uri.split("/");
                if (root == null) {
                    root = Arrays.copyOf(path, path.length - 1);
                    continue;
                }
                int n = path.length - 1;
                if (n > root.length) {
                    n = root.length;
                }
                for (int index = 0; index < n; ++index) {
                    if (root[index].equals(path[index])) continue;
                    n = index;
                    break;
                }
                if (n >= root.length) continue;
                root = Arrays.copyOf(root, n);
            }
            int offset = 0;
            if (root != null) {
                for (Iterator<WebLink> iterator : root) {
                    offset += 1 + ((String)((Object)iterator)).length();
                }
            }
            for (WebLink link : links) {
                void var12_23;
                String externalLink;
                String uri = link.getURI();
                String string = link.getAttributes().getTitle();
                if (string == null) {
                    String string3 = uri.substring(offset);
                    string3 = HtmlGenerator.decodeURL(string3);
                }
                uri = HtmlGenerator.link(pagePath, uri);
                if (linkAttribute != null && (externalLink = link.getAttributes().getFirstAttributeValue(linkAttribute)) != null) {
                    if (externalLink.startsWith("/")) {
                        uri = uri + "/";
                        externalLink = externalLink.substring(1);
                    }
                    uri = uri + HtmlGenerator.encodeURL(externalLink);
                }
                LOGGER.debug("add '{}'#'{}': '{}'", base, uri, var12_23);
                page.append("<a href=\"").append(base).append(uri).append("\">");
                page.append(HtmlGenerator.encodeHtml((String)var12_23));
                page.append("</a>");
                page.append(": ");
                for (String attribute : attributes) {
                    List<String> values = link.getAttributes().getAttributeValues(attribute);
                    if (values.isEmpty()) continue;
                    for (String value : values) {
                        page.append(HtmlGenerator.encodeHtml(value)).append(", ");
                    }
                }
                page.setLength(page.length() - 2);
                page.append("<br>\n");
            }
        }
        page.append("</body>\n");
        page.append("</html>\n");
        return page.toString();
    }

    public static String link(String pagePath, String link) {
        if (link.startsWith(pagePath)) {
            return link.substring(pagePath.length());
        }
        return link;
    }

    public static String decodeURL(String link) {
        try {
            return URLDecoder.decode(link, CoAP.UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            return link;
        }
    }

    public static String encodeURL(String link) {
        try {
            return URLEncoder.encode(link, CoAP.UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            return link;
        }
    }

    public static String encodeHtml(String text) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u007f' || Arrays.binarySearch(ESCAPE, c) >= 0) {
                out.append("&#").append((int)c).append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    static {
        Arrays.sort(ESCAPE);
    }
}

