/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.security.Principal;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;

public class PrincipalEndpointContextMatcher
implements EndpointContextMatcher {
    private final boolean usePrincipalAsIdentity;

    public PrincipalEndpointContextMatcher() {
        this(false);
    }

    public PrincipalEndpointContextMatcher(boolean usePrincipalAsIdentity) {
        this.usePrincipalAsIdentity = usePrincipalAsIdentity;
    }

    @Override
    public String getName() {
        return "principal correlation";
    }

    @Override
    public Object getEndpointIdentity(EndpointContext context) {
        if (this.usePrincipalAsIdentity) {
            Principal identity = context.getPeerIdentity();
            if (identity == null) {
                throw new IllegalArgumentException("Principal identity missing in provided endpoint context!");
            }
            return identity;
        }
        return context.getPeerAddress();
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        return this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectorContext) {
        if (null == connectorContext) {
            return true;
        }
        return this.internalMatch(messageContext, connectorContext);
    }

    private final boolean internalMatch(EndpointContext requestedContext, EndpointContext availableContext) {
        String cipher;
        Principal identity = requestedContext.getPeerIdentity();
        if (identity != null) {
            Principal availableIdentity = availableContext.getPeerIdentity();
            if (availableIdentity == null) {
                return false;
            }
            if (!this.matchPrincipals(identity, availableIdentity)) {
                return false;
            }
        }
        return (cipher = requestedContext.getString(DtlsEndpointContext.KEY_CIPHER)) == null || cipher.equals(availableContext.getString(DtlsEndpointContext.KEY_CIPHER));
    }

    @Override
    public String toRelevantState(EndpointContext context) {
        if (context == null) {
            return "n.a.";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(context.getPeerIdentity());
        String cipher = context.getString(DtlsEndpointContext.KEY_CIPHER);
        if (cipher != null) {
            builder.append(",").append(cipher);
        }
        builder.append("]");
        return builder.toString();
    }

    protected boolean matchPrincipals(Principal requestedPrincipal, Principal availablePrincipal) {
        return requestedPrincipal.equals(availablePrincipal);
    }
}

