/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.MessageCallback;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.util.DatagramWriter;

public abstract class DataSerializer {
    public final byte[] getByteArray(Message message) {
        if (message == null) {
            throw new NullPointerException("message must not be null!");
        }
        this.assertValidOptions(message);
        message.assertPayloadMatchsBlocksize();
        if (message.getRawCode() == 0) {
            if (message.getType() == CoAP.Type.NON) {
                throw new IllegalArgumentException("NON message must not use code 0 (empty message)!");
            }
            if (!message.getToken().isEmpty()) {
                throw new IllegalArgumentException("Empty messages must not use a token!");
            }
            if (message.getPayloadSize() > 0) {
                throw new IllegalArgumentException("Empty messages must not contain payload!");
            }
            return this.serializeEmpytMessage(message);
        }
        if (message.getType() == CoAP.Type.RST) {
            throw new IllegalArgumentException("RST must use code 0 (empty message)!");
        }
        return this.serializeMessage(message);
    }

    public final void ensureByteArray(Message message) {
        if (message == null) {
            throw new NullPointerException("message must not be null!");
        }
        if (message.getBytes() == null) {
            message.setBytes(this.getByteArray(message));
        }
    }

    public final RawData serializeRequest(Request request) {
        return this.serializeRequest(request, null);
    }

    public final RawData serializeRequest(Request request, MessageCallback outboundCallback) {
        if (request == null) {
            throw new NullPointerException("request must not be null!");
        }
        this.ensureByteArray(request);
        return RawData.outbound(request.getBytes(), request.getEffectiveDestinationContext(), outboundCallback, request.isMulticast());
    }

    public final RawData serializeResponse(Response response) {
        return this.serializeResponse(response, null);
    }

    public final RawData serializeResponse(Response response, MessageCallback outboundCallback) {
        if (response == null) {
            throw new NullPointerException("response must not be null!");
        }
        this.ensureByteArray(response);
        return RawData.outbound(response.getBytes(), response.getEffectiveDestinationContext(), outboundCallback, false);
    }

    public final RawData serializeEmptyMessage(EmptyMessage emptyMessage) {
        return this.serializeEmptyMessage(emptyMessage, null);
    }

    public final RawData serializeEmptyMessage(EmptyMessage emptyMessage, MessageCallback outboundCallback) {
        if (emptyMessage == null) {
            throw new NullPointerException("empty-message must not be null!");
        }
        this.ensureByteArray(emptyMessage);
        return RawData.outbound(emptyMessage.getBytes(), emptyMessage.getEffectiveDestinationContext(), outboundCallback, false);
    }

    protected abstract byte[] serializeEmpytMessage(Message var1);

    protected abstract byte[] serializeMessage(Message var1);

    protected void assertValidOptions(Message message) {
        int count;
        if (CoAP.isResponse(message.getRawCode()) && (count = message.getOptions().getETagCount()) > 1) {
            throw new IllegalArgumentException("Multiple ETAGs (" + count + ") in response!");
        }
    }

    public static void serializeOptionsAndPayload(DatagramWriter writer, OptionSet optionSet, byte[] payload) {
        if (writer == null) {
            throw new NullPointerException("writer must not be null!");
        }
        if (optionSet == null) {
            throw new NullPointerException("option-set must not be null!");
        }
        int lastOptionNumber = 0;
        for (Option option : optionSet.asSortedList()) {
            int optionNumber = option.getNumber();
            int optionDelta = optionNumber - lastOptionNumber;
            int optionDeltaNibble = DataSerializer.getOptionNibble(optionDelta);
            writer.write(optionDeltaNibble, 4);
            int optionLength = option.getLength();
            int optionLengthNibble = DataSerializer.getOptionNibble(optionLength);
            writer.write(optionLengthNibble, 4);
            if (optionDeltaNibble == 13) {
                writer.write(optionDelta - 13, 8);
            } else if (optionDeltaNibble == 14) {
                writer.write(optionDelta - 269, 16);
            }
            if (optionLengthNibble == 13) {
                writer.write(optionLength - 13, 8);
            } else if (optionLengthNibble == 14) {
                writer.write(optionLength - 269, 16);
            }
            option.writeTo(writer);
            lastOptionNumber = optionNumber;
        }
        if (payload != null && payload.length > 0) {
            writer.writeByte((byte)-1);
            writer.writeBytes(payload);
        }
    }

    private static int getOptionNibble(int optionValue) {
        if (optionValue <= 12) {
            return optionValue;
        }
        if (optionValue <= 268) {
            return 13;
        }
        if (optionValue <= 65804) {
            return 14;
        }
        throw new IllegalArgumentException("Unsupported option delta " + optionValue);
    }
}

