/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.resources;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.californium.cloud.BaseServer;
import org.eclipse.californium.cloud.option.TimeOption;
import org.eclipse.californium.cloud.resources.ProtectedCoapResource;
import org.eclipse.californium.cloud.util.PrincipalInfo;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.UriQueryParameter;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Devices
extends ProtectedCoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(Devices.class);
    private static final Logger LOGGER_TRACKER = LoggerFactory.getLogger("org.eclipse.californium.gnss.tracker");
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final int SERIES_MAX_SIZE = 32768;
    public static final String RESOURCE_NAME = "devices";
    public static final String SUB_RESOURCE_NAME = "series";
    public static final String DEFAULT_READ_SUB_RESOURCE_NAME = "config";
    public static final String ATTRIBUTE_TIME = "time";
    public static final String ATTRIBUTE_POSITION = "pos";
    public static final String URI_QUERY_OPTION_READ = "read";
    public static final String URI_QUERY_OPTION_SERIES = "series";
    private static final List<String> SUPPORTED = Arrays.asList("read", "series");
    private final LeastRecentlyUpdatedCache<String, Resource> keptPosts;
    private final int[] CONTENT_TYPES = new int[]{0, 42, 50, 60, 41, 10002, 40};

    public Devices(Configuration config) {
        super(RESOURCE_NAME, PrincipalInfo.Type.DEVICE, PrincipalInfo.Type.WEB);
        Arrays.sort(this.CONTENT_TYPES);
        this.getAttributes().setTitle("Resource, which keeps track of POSTing devices.");
        this.getAttributes().addContentTypes(this.CONTENT_TYPES);
        long minutes = config.get(BaseServer.CACHE_STALE_DEVICE_THRESHOLD, TimeUnit.MINUTES);
        int maxDevices = config.get(BaseServer.CACHE_MAX_DEVICES);
        int minDevices = maxDevices / 10;
        if (minDevices < 100) {
            minDevices = maxDevices;
        }
        this.keptPosts = new LeastRecentlyUpdatedCache(minDevices, maxDevices, minutes, TimeUnit.MINUTES);
    }

    @Override
    public void add(Resource child) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean delete(Resource child) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Resource getChild(String name) {
        return this.keptPosts.get(name);
    }

    @Override
    public Collection<Resource> getChildren() {
        return this.keptPosts.values();
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        int accept = exchange.getRequestOptions().getAccept();
        if (accept != -1 && accept != 40) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
        } else {
            List<String> query = exchange.getRequestOptions().getUriQueryStrings();
            if (query.size() > 1) {
                exchange.respond(CoAP.ResponseCode.BAD_OPTION, "only one search query is supported!", 0);
                return;
            }
            Set<WebLink> subTree = LinkFormat.getSubTree(this, query);
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(LinkFormat.serialize(subTree));
            response.getOptions().setContentFormat(40);
            exchange.respond(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePOST(CoapExchange exchange) {
        Response response;
        int format = exchange.getRequestOptions().getContentFormat();
        if (format != -1 && Arrays.binarySearch(this.CONTENT_TYPES, format) < 0) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        boolean updateSeries = false;
        String read = null;
        try {
            UriQueryParameter helper = exchange.getRequestOptions().getUriQueryParameter(SUPPORTED);
            LOGGER.info("URI-Query: {}", (Object)exchange.getRequestOptions().getUriQuery());
            List<Option> others = exchange.getRequestOptions().getOthers();
            if (!others.isEmpty()) {
                LOGGER.info("Other options: {}", (Object)others);
            }
            updateSeries = helper.hasParameter("series");
            if (helper.hasParameter(URI_QUERY_OPTION_READ) && (read = helper.getArgument(URI_QUERY_OPTION_READ, DEFAULT_READ_SUB_RESOURCE_NAME)).startsWith("/")) {
                throw new IllegalArgumentException("Absolute URI not supported for 'read'!");
            }
        }
        catch (IllegalArgumentException ex) {
            Response response2 = new Response(CoAP.ResponseCode.BAD_OPTION);
            response2.setPayload(ex.getMessage());
            exchange.respond(response2);
            return;
        }
        PrincipalInfo info = this.getPrincipalInfo(exchange);
        String name = info.name;
        if (name != null) {
            Request request = exchange.advanced().getRequest();
            TimeOption timeOption = TimeOption.getMessageTime(request);
            long time = timeOption.getLongValue();
            String log = null;
            String position = null;
            String timestamp = Devices.format(time);
            response = new Response(CoAP.ResponseCode.CHANGED);
            if (format == 0) {
                String[] lines;
                for (String line : lines = request.getPayloadString().split("[\\n\\r]+")) {
                    if (line.startsWith("!")) {
                        line = line.substring(1);
                        log = log == null ? timestamp + ": " + line : log + "," + line;
                    }
                    if (line.startsWith("GNSS.") && line.length() > 7) {
                        String tag = line.substring(0, 6);
                        String value = line.substring(7);
                        LOGGER_TRACKER.info("{}: {} {}", tag, name, value);
                        position = value;
                        continue;
                    }
                    if (!line.startsWith("*GNSS.") || line.length() <= 8) continue;
                    String value = line.substring(8);
                    position = "*" + value;
                }
                if (log != null) {
                    LOGGER_TRACKER.info("!LOG: {} {}", (Object)name, (Object)log);
                    if (!updateSeries) {
                        log = null;
                    }
                }
            }
            request.setProtectFromOffload();
            ReentrantReadWriteLock.WriteLock lock = this.keptPosts.writeLock();
            lock.lock();
            try {
                Resource child = this.keptPosts.update(name);
                Device device = child instanceof Device ? (Device)child : new Device(name);
                device.setPost(request, position, time);
                if (log != null) {
                    device.appendSeries(log, timestamp);
                }
                if (device.getParent() == null) {
                    device.setParent(this);
                    this.keptPosts.put(name, device);
                }
            }
            finally {
                lock.unlock();
            }
            TimeOption responseTimeOption = timeOption.adjust();
            if (responseTimeOption != null) {
                response.getOptions().addOtherOption(responseTimeOption);
            }
        } else {
            response = new Response(CoAP.ResponseCode.FORBIDDEN);
        }
        exchange.respond(response);
    }

    private static String format(long millis) {
        return ISO_DATE_FORMAT.format(new Date(millis));
    }

    public static class Device
    extends ProtectedCoapResource {
        private Series series = null;
        private volatile Request post;
        private volatile long time;

        private Device(String name) {
            super(name, PrincipalInfo.Type.DEVICE, PrincipalInfo.Type.WEB);
            this.setObservable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPost(Request post, String position, long time) {
            Device device = this;
            synchronized (device) {
                long interval;
                long previousTime = this.time;
                this.post = post;
                this.time = time;
                ResourceAttributes attributes = new ResourceAttributes(this.getAttributes());
                attributes.clearContentType();
                if (post.getOptions().hasContentFormat()) {
                    attributes.addContentType(post.getOptions().getContentFormat());
                }
                String timestamp = Devices.format(time);
                if (previousTime > 0L && time > 0L && (interval = TimeUnit.MILLISECONDS.toSeconds(time - previousTime)) > 0L) {
                    long minutes = TimeUnit.SECONDS.toMinutes(interval + 5L);
                    timestamp = minutes > 0L ? timestamp + " (" + minutes + "min.)" : timestamp + " (" + interval + "sec.)";
                }
                attributes.setAttribute(Devices.ATTRIBUTE_TIME, timestamp);
                if (position != null && !position.isEmpty()) {
                    attributes.setAttribute(Devices.ATTRIBUTE_POSITION, position);
                } else {
                    attributes.clearAttribute(Devices.ATTRIBUTE_POSITION);
                }
                this.setAttributes(attributes);
            }
            this.changed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Series appendSeries(String line, String timestamp) {
            Series series = null;
            if (line != null && !line.isEmpty()) {
                Device device = this;
                synchronized (device) {
                    if (this.series != null && !this.series.append(line, timestamp)) {
                        this.delete(this.series);
                        this.series = null;
                    }
                    if (this.series == null) {
                        this.series = new Series(timestamp);
                        this.series.append(line, timestamp);
                        this.add((CoapResource)this.series);
                    }
                    series = this.series;
                }
            }
            return series;
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            Request devicePost = this.post;
            int format = devicePost.getOptions().getContentFormat();
            int accept = exchange.getRequestOptions().getAccept();
            if (accept == -1) {
                accept = format == -1 ? 42 : format;
            } else if (format == -1) {
                if (accept != 0 && accept != 42) {
                    exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                    return;
                }
            } else if (accept != format) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(devicePost.getPayload());
            response.getOptions().setContentFormat(accept);
            exchange.respond(response);
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class Series
    extends ProtectedCoapResource {
        private final String startDate;
        private final StringBuilder content = new StringBuilder();

        private Series(String timestamp) {
            super("series", PrincipalInfo.Type.WEB);
            this.startDate = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setParent(Resource parent) {
            super.setParent(parent);
            Series series = this;
            synchronized (series) {
                ResourceAttributes attributes = new ResourceAttributes(this.getAttributes());
                if (parent != null) {
                    attributes.setTitle(parent.getName() + " => " + "series");
                } else {
                    attributes.clearTitle();
                }
                this.setAttributes(attributes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean append(String line, String timestamp) {
            Series series = this;
            synchronized (series) {
                boolean swap;
                int len = this.content.length();
                boolean bl = swap = len + line.length() > 32768;
                if (swap || !this.startDate.regionMatches(0, timestamp, 0, 11)) {
                    return false;
                }
                if (len > 0 && this.content.charAt(len - 1) != '\n') {
                    this.content.append('\n');
                }
                this.content.append(line);
                return true;
            }
        }

        public String getContent() {
            return this.content.toString();
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            int accept = exchange.getRequestOptions().getAccept();
            if (accept != -1 && accept != 0) {
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
                return;
            }
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(this.content.toString());
            response.getOptions().setContentFormat(0);
            exchange.respond(response);
        }
    }
}

