/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;

@NoPublicAPI
public abstract class HelloHandshakeMessage
extends HandshakeMessage {
    protected static final int VERSION_BITS = 8;
    protected static final int RANDOM_BYTES = 32;
    protected static final int SESSION_ID_LENGTH_BITS = 8;
    protected final ProtocolVersion protocolVersion;
    protected final Random random;
    protected final SessionId sessionId;
    protected final HelloExtensions extensions = new HelloExtensions();

    protected HelloHandshakeMessage(ProtocolVersion version, SessionId sessionId) {
        if (version == null) {
            throw new NullPointerException("Negotiated protocol version must not be null");
        }
        if (sessionId == null) {
            throw new NullPointerException("ServerHello must be associated with a session ID");
        }
        this.protocolVersion = version;
        this.sessionId = sessionId;
        this.random = new Random();
    }

    protected HelloHandshakeMessage(DatagramReader reader) {
        int major = reader.read(8);
        int minor = reader.read(8);
        this.protocolVersion = ProtocolVersion.valueOf(major, minor);
        this.random = new Random(reader.readBytes(32));
        this.sessionId = new SessionId(reader.readVarBytes(8));
    }

    protected void writeHeader(DatagramWriter writer) {
        writer.write(this.protocolVersion.getMajor(), 8);
        writer.write(this.protocolVersion.getMinor(), 8);
        writer.writeBytes(this.random.getBytes());
        writer.writeVarBytes(this.sessionId, 8);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Version: ").append(this.protocolVersion.getMajor()).append(", ").append(this.protocolVersion.getMinor()).append(StringUtil.lineSeparator());
        sb.append(indentation).append("Random:").append(StringUtil.lineSeparator());
        sb.append(this.random.toString(indent + 2));
        sb.append(indentation).append("Session ID Length: ").append(this.sessionId.length()).append(" bytes").append(StringUtil.lineSeparator());
        if (this.sessionId.length() > 0) {
            sb.append(indentation).append("Session ID: ").append(this.sessionId).append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public boolean hasSessionId() {
        return !this.sessionId.isEmpty();
    }

    void addExtension(HelloExtension extension) {
        this.extensions.addExtension(extension);
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    public SupportedPointFormatsExtension getSupportedPointFormatsExtension() {
        return (SupportedPointFormatsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.EC_POINT_FORMATS);
    }

    public ClientCertificateTypeExtension getClientCertificateTypeExtension() {
        return (ClientCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CLIENT_CERT_TYPE);
    }

    public ServerCertificateTypeExtension getServerCertificateTypeExtension() {
        return (ServerCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_CERT_TYPE);
    }

    public SignatureAlgorithmsExtension getSupportedSignatureAlgorithmsExtension() {
        return (SignatureAlgorithmsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SIGNATURE_ALGORITHMS);
    }

    public MaxFragmentLengthExtension getMaxFragmentLengthExtension() {
        return (MaxFragmentLengthExtension)this.extensions.getExtension(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
    }

    public RecordSizeLimitExtension getRecordSizeLimitExtension() {
        return (RecordSizeLimitExtension)this.extensions.getExtension(HelloExtension.ExtensionType.RECORD_SIZE_LIMIT);
    }

    public ServerNameExtension getServerNameExtension() {
        return (ServerNameExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_NAME);
    }

    public ConnectionIdExtension getConnectionIdExtension() {
        return (ConnectionIdExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CONNECTION_ID);
    }

    public boolean hasExtendedMasterSecretExtension() {
        return this.extensions.getExtension(HelloExtension.ExtensionType.EXTENDED_MASTER_SECRET) != null;
    }

    public boolean hasRenegotiationInfoExtension() {
        return this.extensions.getExtension(HelloExtension.ExtensionType.RENEGOTIATION_INFO) != null;
    }
}

