/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.util.StringUtil;

public final class KeyUri {
    private final CoAP.Code code;
    private final String uri;
    private final Object peersIdentity;
    private final int hash;

    public KeyUri(String requestUri, Object peersIdentity, CoAP.Code code) {
        if (requestUri == null) {
            throw new NullPointerException("URI must not be null");
        }
        if (peersIdentity == null) {
            throw new NullPointerException("peer's identity must not be null");
        }
        this.code = code;
        this.uri = requestUri;
        this.peersIdentity = peersIdentity;
        int hash = requestUri.hashCode() * 31 + peersIdentity.hashCode();
        if (code != null) {
            hash = hash * 31 + code.hashCode();
        }
        this.hash = hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyUri other = (KeyUri)obj;
        if (!this.peersIdentity.equals(other.peersIdentity)) {
            return false;
        }
        if (!this.uri.equals(other.uri)) {
            return false;
        }
        return this.code == other.code || this.code.equals((Object)other.code);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("KeyUri[");
        b.append((Object)this.code).append(", ").append(this.uri);
        Object peer = this.peersIdentity;
        if (peer instanceof InetSocketAddress) {
            peer = StringUtil.toDisplayString((InetSocketAddress)peer);
        }
        b.append(", ").append(peer).append("]");
        return b.toString();
    }

    private static String getUri(Request request) {
        if (request == null) {
            throw new NullPointerException("request must not be null");
        }
        return request.getScheme() + ":" + request.getOptions().getUriString();
    }

    public static KeyUri getKey(Exchange exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        Request request = exchange.getRequest();
        String uri = KeyUri.getUri(request);
        CoAP.Code code = request.getCode();
        return new KeyUri(uri, exchange.getPeersIdentity(), code);
    }
}

