/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.resources;

import java.security.Principal;
import java.util.Arrays;
import org.eclipse.californium.cloud.util.PrincipalInfo;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtectedCoapResource
extends CoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectedCoapResource.class);
    private final PrincipalInfo.Type[] allowed;
    private final String allowedAsText;

    private static String getAllowedAsText(PrincipalInfo.Type[] allowed) {
        return LOGGER.isDebugEnabled() ? Arrays.asList(allowed).toString() : null;
    }

    public ProtectedCoapResource(String name) {
        super(name);
        this.allowed = new PrincipalInfo.Type[]{PrincipalInfo.Type.DEVICE};
        this.allowedAsText = ProtectedCoapResource.getAllowedAsText(this.allowed);
    }

    public ProtectedCoapResource(String name, boolean visible) {
        super(name, visible);
        this.allowed = new PrincipalInfo.Type[]{PrincipalInfo.Type.DEVICE};
        this.allowedAsText = ProtectedCoapResource.getAllowedAsText(this.allowed);
    }

    public ProtectedCoapResource(String name, PrincipalInfo.Type ... allowed) {
        super(name);
        this.allowed = allowed;
        this.allowedAsText = ProtectedCoapResource.getAllowedAsText(allowed);
    }

    public ProtectedCoapResource(String name, boolean visible, PrincipalInfo.Type ... allowed) {
        super(name, visible);
        this.allowed = allowed;
        this.allowedAsText = ProtectedCoapResource.getAllowedAsText(allowed);
    }

    @Override
    public void handleRequest(Exchange exchange) {
        CoAP.ResponseCode code = this.checkPermission(exchange);
        if (code != null) {
            exchange.sendResponse(new Response(code));
        } else {
            super.handleRequest(exchange);
        }
    }

    protected boolean allowed(PrincipalInfo.Type type) {
        for (PrincipalInfo.Type permission : this.allowed) {
            if (type != permission) continue;
            return true;
        }
        if (this.allowedAsText != null) {
            LOGGER.debug("{} is not in {}", (Object)type, (Object)this.allowedAsText);
        }
        return false;
    }

    protected CoAP.ResponseCode checkPermission(Exchange exchange) {
        PrincipalInfo info = this.getPrincipalInfo(exchange);
        if (info == null) {
            return CoAP.ResponseCode.UNAUTHORIZED;
        }
        if (!this.allowed(info.type)) {
            return CoAP.ResponseCode.FORBIDDEN;
        }
        return this.checkOperationPermission(info, exchange, exchange.getRequest().getCode().write);
    }

    protected CoAP.ResponseCode checkOperationPermission(PrincipalInfo info, Exchange exchange, boolean write) {
        return null;
    }

    protected PrincipalInfo getPrincipalInfo(Exchange exchange) {
        Principal principal = exchange.getRequest().getSourceContext().getPeerIdentity();
        return PrincipalInfo.getPrincipalInfo(principal);
    }

    protected PrincipalInfo getPrincipalInfo(CoapExchange exchange) {
        return this.getPrincipalInfo(exchange.advanced());
    }

    protected Principal getPrincipal(Exchange exchange) {
        return exchange.getRequest().getSourceContext().getPeerIdentity();
    }

    protected Principal getPrincipal(CoapExchange exchange) {
        return this.getPrincipal(exchange.advanced());
    }
}

