/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.cloud.util.ResourceParser;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxConfigParser
implements ResourceParser<LinuxConfigParser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxConfigParser.class);
    public static final String DEFAULT_SECTION = "default";
    private static final Pattern SECTION = Pattern.compile("^\\s*\\[([^\\]]+)\\]\\s*$");
    private final ConcurrentMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>();
    private final boolean caseSensitiveSections;
    private final boolean caseSensitiveNames;
    private volatile boolean destroyed;

    public LinuxConfigParser(boolean caseSensitiveSections, boolean caseSensitiveNames) {
        this.caseSensitiveSections = caseSensitiveSections;
        this.caseSensitiveNames = caseSensitiveNames;
    }

    private String getSectionKey(String section) {
        String key = section;
        if (!this.caseSensitiveSections) {
            key = key.toLowerCase();
        }
        return key;
    }

    private String getNameKey(String name) {
        String key = name;
        if (!this.caseSensitiveNames) {
            key = key.toLowerCase();
        }
        return key;
    }

    public Map<String, Map<String, String>> getSubSections(String section) {
        String key = this.getSectionKey(section);
        if (!key.endsWith(".")) {
            key = key + ".";
        }
        HashMap<String, Map<String, String>> subsections = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((String)entry.getKey()).startsWith(key)) continue;
            String k = ((String)entry.getKey()).substring(key.length());
            subsections.put(k, (Map<String, String>)entry.getValue());
        }
        return subsections;
    }

    @Override
    public void save(Writer writer) throws IOException {
        ArrayList sections = new ArrayList(this.map.keySet());
        Collections.sort(sections);
        for (String section : sections) {
            writer.write(91);
            writer.write(section);
            writer.write(93);
            writer.write(StringUtil.lineSeparator());
            Map sectionMap = (Map)this.map.get(section);
            if (sectionMap == null) continue;
            ArrayList names = new ArrayList(sectionMap.keySet());
            Collections.sort(names);
            for (String name : names) {
                writer.write(name);
                String value = (String)sectionMap.get(name);
                if (value != null) {
                    writer.write(" = ");
                    writer.write(value);
                }
                writer.write(StringUtil.lineSeparator());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Reader reader) throws IOException {
        int values;
        block24: {
            values = 0;
            BufferedReader lineReader = new BufferedReader(reader);
            try {
                String line;
                int lineNumber = 0;
                int errors = 0;
                int comments = 0;
                Map sectionMap = null;
                String section = null;
                while ((line = lineReader.readLine()) != null) {
                    ++lineNumber;
                    try {
                        if (!line.isEmpty() && !line.startsWith("#")) {
                            Matcher matcher = SECTION.matcher(line);
                            if (matcher.matches()) {
                                section = this.getSectionKey(matcher.group(1));
                                sectionMap = this.map.putIfAbsent(section, new ConcurrentHashMap());
                                if (sectionMap != null) continue;
                                sectionMap = (Map)this.map.get(section);
                                continue;
                            }
                            if (sectionMap != null) {
                                String[] entry = line.split("=", 2);
                                String name = this.getNameKey(entry[0].trim());
                                String value = "";
                                if (entry.length == 2) {
                                    value = entry[1].trim();
                                }
                                sectionMap.put(name, value);
                                ++values;
                                continue;
                            }
                            ++errors;
                            LOGGER.warn("{}: '{}' missing scope!", (Object)lineNumber, (Object)line);
                            continue;
                        }
                        ++comments;
                    }
                    catch (IllegalArgumentException ex) {
                        ++errors;
                        LOGGER.warn("{}: '{}' invalid line!", lineNumber, line, ex);
                    }
                }
                if (this.size() == 0 && errors > 0 && lineNumber == comments + errors) {
                    LOGGER.warn("read store, only errors, wrong password?");
                    SecretUtil.destroy(this);
                    values = 0;
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn("read store, unexpected error occurred!", e);
            }
            catch (IOException e) {
                if (e.getCause() instanceof GeneralSecurityException) {
                    LOGGER.warn("read store, wrong password?", e);
                    SecretUtil.destroy(this);
                    values = 0;
                    break block24;
                }
                throw e;
            }
            finally {
                try {
                    lineReader.close();
                }
                catch (IOException e) {}
            }
        }
        LOGGER.info("read {} scopes, {} values.", (Object)this.size(), (Object)values);
    }

    @Override
    public LinuxConfigParser create() {
        return new LinuxConfigParser(this.caseSensitiveSections, this.caseSensitiveNames);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.map.clear();
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public int size() {
        return this.map.size();
    }

    public boolean hasSection(String section) {
        return this.map.containsKey(this.getSectionKey(section));
    }

    public Set<String> getSections() {
        return this.map.keySet();
    }

    public Map<String, String> getValues(String section) {
        return (Map)this.map.get(this.getSectionKey(section));
    }

    public String get(String name) {
        return this.getWithDefault(DEFAULT_SECTION, name, null);
    }

    public String get(String section, String name) {
        return this.getWithDefault(section, name, null);
    }

    public String getWithDefault(String name, String def) {
        return this.getWithDefault(DEFAULT_SECTION, name, def);
    }

    public String getWithDefault(String section, String name, String def) {
        String value = null;
        Map<String, String> sectionMap = this.getValues(section);
        if (sectionMap != null) {
            value = sectionMap.get(this.getNameKey(name));
        }
        if (value == null) {
            value = def;
        }
        return value;
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(DEFAULT_SECTION, name, null);
    }

    public Boolean getBoolean(String name, Boolean def) {
        return this.getBoolean(DEFAULT_SECTION, name, def);
    }

    public Boolean getBoolean(String section, String name) {
        return this.getBoolean(section, name, null);
    }

    public Boolean getBoolean(String section, String name, Boolean def) {
        String value = this.get(section, name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return def;
    }

    public Long getLong(String name) {
        return this.getLong(DEFAULT_SECTION, name, null);
    }

    public Long getLong(String name, Long def) {
        return this.getLong(DEFAULT_SECTION, name, def);
    }

    public Long getLong(String section, String name) {
        return this.getLong(section, name, null);
    }

    public Long getLong(String section, String name, Long def) {
        String value = this.get(section, name);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                if (def != null) {
                    LOGGER.warn("{} is no long! Replaced by {}.", (Object)value, (Object)def);
                }
                LOGGER.warn("{} is no long!", (Object)value);
            }
        }
        return def;
    }

    public Integer getInteger(String name) {
        return this.getInteger(DEFAULT_SECTION, name, null);
    }

    public Integer getInteger(String name, Integer def) {
        return this.getInteger(DEFAULT_SECTION, name, def);
    }

    public Integer getInteger(String section, String name) {
        return this.getInteger(section, name, null);
    }

    public Integer getInteger(String section, String name, Integer def) {
        String value = this.get(section, name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                if (def != null) {
                    LOGGER.warn("{} is no long! Replaced by {}.", (Object)value, (Object)def);
                }
                LOGGER.warn("{} is no long!", (Object)value);
            }
        }
        return def;
    }
}

