/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.cloud.EndpointNetSocketObserver;
import org.eclipse.californium.cloud.ManagementStatistic;
import org.eclipse.californium.cloud.http.HttpService;
import org.eclipse.californium.cloud.resources.Devices;
import org.eclipse.californium.cloud.resources.Diagnose;
import org.eclipse.californium.cloud.resources.MyContext;
import org.eclipse.californium.cloud.util.DeviceGredentialsProvider;
import org.eclipse.californium.cloud.util.DeviceManager;
import org.eclipse.californium.cloud.util.DeviceParser;
import org.eclipse.californium.cloud.util.ResourceStore;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.interceptors.HealthStatisticLogger;
import org.eclipse.californium.core.observe.ObserveStatisticLogger;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.EncryptedPersistentComponentUtil;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsHealthLogger;
import org.eclipse.californium.scandium.MdcConnectionListener;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.unixhealth.NetSocketHealthLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class BaseServer
extends CoapServer {
    private static final Logger LOGGER;
    private static final Logger STATISTIC_LOGGER;
    private static final int DEFAULT_MAX_CONNECTIONS = 200000;
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 8192;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 1280;
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    public static final String DTLS_PRIVATE_KEY = "privkey.pem";
    public static final String DTLS_PUBLIC_KEY = "pubkey.pem";
    public static final int ERR_INIT_FAILED = 1;
    public static final List<CipherSuite> PRESELECTED_CIPHER_SUITES;
    public static final TimeDefinition UDP_DROPS_READ_INTERVAL;
    public static final IntegerDefinition CACHE_MAX_DEVICES;
    public static final TimeDefinition CACHE_STALE_DEVICE_THRESHOLD;
    public static final TimeDefinition HTTPS_CREDENTIALS_RELOAD_INTERVAL;
    public static final TimeDefinition DEVICE_CREDENTIALS_RELOAD_INTERVAL;
    public static Configuration.DefinitionsProvider DEFAULTS;
    public static final String CALIFORNIUM_BUILD_VERSION;
    protected SystemResourceMonitors monitors;
    protected DeviceGredentialsProvider deviceCredentials;

    private static String toLog(PublicKey key) {
        byte[] data = key.getEncoded();
        return StringUtil.byteArray2Hex(Arrays.copyOfRange(data, data.length - 6, data.length));
    }

    public static void start(String[] args, String name, ServerConfig cliArguments, BaseServer server) {
        long interval;
        CommandLine cmd = new CommandLine(cliArguments);
        try {
            CommandLine.ParseResult result = cmd.parseArgs(args);
            if (result.isVersionHelpRequested()) {
                System.out.println("\nCalifornium (Cf) " + cmd.getCommandName() + " " + CALIFORNIUM_BUILD_VERSION);
                cmd.printVersionHelp(System.out);
                System.out.println();
            }
            if (result.isUsageHelpRequested()) {
                cmd.usage(System.out);
                return;
            }
        }
        catch (CommandLine.ParameterException ex) {
            System.err.println(ex.getMessage());
            System.err.println();
            cmd.usage(System.err);
            System.exit(-1);
        }
        cliArguments.defaults();
        long max = Runtime.getRuntime().maxMemory();
        StringBuilder builder = new StringBuilder(name);
        if (!CALIFORNIUM_BUILD_VERSION.isEmpty()) {
            builder.append(", version ").append(CALIFORNIUM_BUILD_VERSION);
        }
        builder.append(", ").append(max / 0x100000L).append("MB heap, started ...");
        LOGGER.info("{}", (Object)builder);
        STATISTIC_LOGGER.error("start!");
        ManagementStatistic management = new ManagementStatistic(STATISTIC_LOGGER);
        boolean http = false;
        if (cliArguments.https != null) {
            if (cliArguments.https.port > 0) {
                LOGGER.info("Create HTTPS service at port {}, credentials {}", (Object)cliArguments.https.port, (Object)cliArguments.https.credentials);
                http = HttpService.createHttpService(cliArguments.https.port, cliArguments.https.credentials, cliArguments.https.password64, false);
            } else {
                LOGGER.info("HTTPS service at port {} is not supported! Must be [1-65535]", (Object)cliArguments.https.port);
            }
        }
        try {
            server.initialize(cliArguments);
            if (!cliArguments.noCoap && server.getEndpoints().isEmpty()) {
                System.err.println("no endpoint available!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.printf("Failed to create " + BaseServer.class.getSimpleName() + ": %s\n", e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("Exiting");
            System.exit(1);
        }
        if (cliArguments.store != null) {
            server.setupPersistence(cliArguments.store);
        }
        server.start();
        LOGGER.info("{} started ...", (Object)name);
        if (http && HttpService.startHttpService()) {
            LOGGER.info("HTTPS service at port {} started", (Object)cliArguments.https.port);
            long interval2 = server.getConfig().get(HTTPS_CREDENTIALS_RELOAD_INTERVAL, TimeUnit.MINUTES);
            SystemResourceMonitors.SystemResourceMonitor httpsCredentialsMonitor = HttpService.getHttpService().getFileMonitor();
            server.monitors.addOptionalMonitor("https credentials", interval2, TimeUnit.MINUTES, httpsCredentialsMonitor);
        }
        long inputTimeout = (interval = server.getConfig().get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS).longValue()) < 15000L ? interval : 15000L;
        long lastGcCount = 0L;
        long lastDumpNanos = ClockUtil.nanoRealtime();
        while (true) {
            long now;
            try {
                Thread.sleep(inputTimeout);
            }
            catch (InterruptedException e) {
                break;
            }
            long gcCount = management.getCollectionCount();
            if (lastGcCount < gcCount) {
                management.printManagementStatistic();
                lastGcCount = gcCount;
                long clones = DatagramWriter.COPIES.get();
                long takes = DatagramWriter.TAKES.get();
                if (clones + takes > 0L) {
                    STATISTIC_LOGGER.info("DatagramWriter {} clones, {} takes, {}%", clones, takes, takes * 100L / (takes + clones));
                }
            }
            if ((now = ClockUtil.nanoRealtime()) - lastDumpNanos - TimeUnit.MILLISECONDS.toNanos(interval) <= 0L) continue;
            lastDumpNanos = now;
            server.dump();
        }
        LOGGER.info("Executor shutdown ...");
        if (http) {
            HttpService.stopHttpService();
            LOGGER.info("HTTPS service at port {} stopped", (Object)cliArguments.https.port);
        }
        server.stop();
        server.destroy();
        BaseServer.exit();
        LOGGER.info("Exit ...");
    }

    public static void exit() {
        int count = Thread.activeCount();
        while (count > 0) {
            int size = Thread.activeCount();
            Thread[] all = new Thread[size];
            int available = Thread.enumerate(all);
            if (available < size) {
                size = available;
            }
            count = 0;
            for (int index = 0; index < size; ++index) {
                Thread thread = all[index];
                if (thread.isDaemon() || !thread.isAlive()) continue;
                ++count;
                LOGGER.info("Thread [{}] {}", (Object)thread.getId(), (Object)thread.getName());
            }
            if (count == 1) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public BaseServer(Configuration config) {
        super(config, new int[0]);
        this.setVersion(CALIFORNIUM_BUILD_VERSION);
        this.setTag("CLOUD-DEMO");
    }

    @Override
    public void start() {
        if (!this.getEndpoints().isEmpty()) {
            super.start();
        }
        this.monitors.start();
    }

    @Override
    public void stop() {
        if (!this.getEndpoints().isEmpty()) {
            super.stop();
        }
        this.monitors.stop();
    }

    public void initialize(ServerConfig cliArguments) throws SocketException {
        Configuration config = this.getConfig();
        ScheduledThreadPoolExecutor secondaryExecutor = ExecutorsUtil.newDefaultSecondaryScheduler("CoapServer(secondary)#");
        this.monitors = new SystemResourceMonitors(secondaryExecutor);
        this.setupDeviceCredentials(cliArguments);
        if (!cliArguments.noCoap) {
            this.addEndpoints(cliArguments);
            ScheduledExecutorService executor = ExecutorsUtil.newScheduledThreadPool(config.get(CoapConfig.PROTOCOL_STAGE_THREAD_COUNT), new NamedThreadFactory("CoapServer(main)#"));
            this.addResource(cliArguments, executor);
            this.setExecutors(executor, secondaryExecutor, false);
            this.setupUdpHealthLogger(secondaryExecutor);
            this.setupObserveHealthLogger();
        }
        this.setupHttpService(cliArguments);
        LOGGER.info("{} initialized.", (Object)this.getTag());
    }

    public void setupDeviceCredentials(ServerConfig cliArguments) {
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        if (cliArguments.coaps != null) {
            try {
                String path = cliArguments.coaps.credentials;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                String privateKeyPath = path + DTLS_PRIVATE_KEY;
                SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(privateKeyPath, null, null, null);
                privateKey = credentials.getPrivateKey();
                publicKey = credentials.getPublicKey();
                if (privateKey == null) {
                    LOGGER.info("PEM credentials {}, missing private key!", (Object)privateKeyPath);
                } else if (publicKey != null) {
                    LOGGER.info("PEM credentials {}, public key: ...{}", (Object)privateKeyPath, (Object)BaseServer.toLog(publicKey));
                } else {
                    String publicKeyPath = path + DTLS_PUBLIC_KEY;
                    credentials = SslContextUtil.loadCredentials(publicKeyPath, null, null, null);
                    publicKey = credentials.getPublicKey();
                    if (publicKey != null) {
                        LOGGER.info("PEM credentials {}, public key: ...{}", (Object)publicKeyPath, (Object)BaseServer.toLog(publicKey));
                    } else {
                        LOGGER.info("PEM credentials {}, missing public key!", (Object)publicKeyPath);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.info("Loading PEM credentials failed", e);
            }
            catch (GeneralSecurityException e) {
                LOGGER.info("Loading PEM credentials failed", e);
            }
        }
        this.setupDeviceCredentials(cliArguments, privateKey, publicKey);
    }

    public void setupDeviceCredentials(ServerConfig cliArguments, PrivateKey privateKey, PublicKey publicKey) {
        if (cliArguments.deviceStore != null) {
            long interval = this.getConfig().get(DEVICE_CREDENTIALS_RELOAD_INTERVAL, TimeUnit.SECONDS);
            DeviceParser factory = new DeviceParser(true);
            ResourceStore<DeviceParser> configResource = new ResourceStore<DeviceParser>(factory).setTag("Devices ");
            configResource.loadAndCreateMonitor(cliArguments.deviceStore.file, cliArguments.deviceStore.password64, interval > 0L);
            this.monitors.addMonitor("Devices", interval, TimeUnit.SECONDS, configResource.getMonitor());
            this.deviceCredentials = new DeviceManager(configResource, privateKey, publicKey);
        } else {
            this.deviceCredentials = new DeviceManager(null, privateKey, publicKey);
        }
    }

    public void addEndpoints(ServerConfig cliArguments) {
        boolean healthLogger;
        Configuration config = this.getConfig();
        int coapsPort = config.get(CoapConfig.COAP_SECURE_PORT);
        boolean bl = healthLogger = config.get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS) > 0L;
        if (this.deviceCredentials.getCertificateVerifier() == null && this.deviceCredentials.getPskStore() == null) {
            LOGGER.warn("Missing device credentials!");
            return;
        }
        PrincipalEndpointContextMatcher customContextMatcher = null;
        if (CoapConfig.MatcherMode.PRINCIPAL == config.get(CoapConfig.RESPONSE_MATCHING)) {
            customContextMatcher = new PrincipalEndpointContextMatcher(true);
        }
        Collection<InetAddress> localAddresses = cliArguments.network.wildcard ? Collections.singleton(new InetSocketAddress(0).getAddress()) : NetworkInterfacesUtil.getNetworkInterfaces(cliArguments.network.selectInterfaces.getFilter(this.getTag()));
        for (InetAddress addr : localAddresses) {
            ApplicationLevelInfoSupplier infoSupplier;
            NewAdvancedCertificateVerifier certificateVerifier;
            CertificateProvider certificateProvider;
            InetSocketAddress bindToAddress = new InetSocketAddress(addr, coapsPort);
            DtlsConnectorConfig.Builder dtlsConfigBuilder = DtlsConnectorConfig.builder(config);
            dtlsConfigBuilder.setAddress(bindToAddress);
            String tag = "dtls:" + StringUtil.toString(bindToAddress);
            dtlsConfigBuilder.setLoggingTag(tag);
            AdvancedPskStore pskStore = this.deviceCredentials.getPskStore();
            if (pskStore != null) {
                dtlsConfigBuilder.setAdvancedPskStore(pskStore);
            }
            if ((certificateProvider = this.deviceCredentials.getCertificateProvider()) != null) {
                dtlsConfigBuilder.setCertificateIdentityProvider(certificateProvider);
            }
            if ((certificateVerifier = this.deviceCredentials.getCertificateVerifier()) != null) {
                dtlsConfigBuilder.setAdvancedCertificateVerifier(certificateVerifier);
            }
            if ((infoSupplier = this.deviceCredentials.getInfoSupplier()) != null) {
                dtlsConfigBuilder.setApplicationLevelInfoSupplier(infoSupplier);
            }
            dtlsConfigBuilder.setConnectionListener(new MdcConnectionListener());
            if (healthLogger) {
                DtlsHealthLogger health = new DtlsHealthLogger(tag);
                dtlsConfigBuilder.setHealthHandler(health);
                this.add(health);
            }
            DTLSConnector connector = new DTLSConnector(dtlsConfigBuilder.build());
            tag = "coaps:" + StringUtil.toString(bindToAddress);
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setLoggingTag(tag);
            builder.setConnector(connector);
            builder.setConfiguration(config);
            if (customContextMatcher != null) {
                builder.setEndpointContextMatcher(customContextMatcher);
            }
            CoapEndpoint endpoint = builder.build();
            if (healthLogger) {
                HealthStatisticLogger health = new HealthStatisticLogger(tag, true);
                endpoint.addPostProcessInterceptor(health);
                this.add(health);
            }
            this.addEndpoint(endpoint);
            LOGGER.info("{}listen on {} ({})", this.getTag(), endpoint.getUri(), addr.isLoopbackAddress() ? "LOCAL" : "EXTERNAL");
        }
    }

    public void addResource(ServerConfig cliArguments, ScheduledExecutorService executor) {
        if (cliArguments.diagnose) {
            this.add(new Diagnose(this));
        }
        this.add(new Devices(this.getConfig()));
        this.add(new MyContext("mycontext", CALIFORNIUM_BUILD_VERSION, false));
    }

    public void setupHttpService(ServerConfig cliArguments) {
        HttpService httpService = HttpService.getHttpService();
        if (httpService != null) {
            HttpService.ForwardHandler forward = new HttpService.ForwardHandler("devices", "Devices:");
            httpService.createContext("/", forward);
            HttpService.CoapProxyHandler proxy = new HttpService.CoapProxyHandler(this.getMessageDeliverer(), httpService.getExecutor(), new String[0]);
            httpService.createContext("devices", proxy);
            if (cliArguments.diagnose) {
                httpService.createContext("diagnose", proxy);
            }
        }
    }

    public void setupUdpHealthLogger(ScheduledExecutorService secondaryExecutor) {
        Configuration config = this.getConfig();
        final NetSocketHealthLogger socketLogger = new NetSocketHealthLogger("udp");
        long interval = config.get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS);
        if (interval > 0L && socketLogger.isEnabled()) {
            long readInterval = config.get(UDP_DROPS_READ_INTERVAL, TimeUnit.MILLISECONDS);
            if (interval > readInterval) {
                secondaryExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        socketLogger.read();
                    }
                }, readInterval, readInterval, TimeUnit.MILLISECONDS);
            }
            this.addDefaultEndpointObserver(new EndpointNetSocketObserver(socketLogger));
        }
    }

    public void setupObserveHealthLogger() {
        ObserveStatisticLogger obsStatLogger = new ObserveStatisticLogger(this.getTag());
        if (obsStatLogger.isEnabled()) {
            this.add(obsStatLogger);
            this.setObserveHealth(obsStatLogger);
            ArrayList<CounterStatisticManager> statistics = new ArrayList<CounterStatisticManager>();
            statistics.add(obsStatLogger);
            Resource child = this.getRoot().getChild("diagnose");
            if (child instanceof Diagnose) {
                ((Diagnose)child).update(statistics);
            }
        }
    }

    public void setupPersistence(ServerConfig.Store store) {
        Runnable hook = new Runnable(){

            @Override
            public void run() {
                BaseServer.this.stop();
            }
        };
        char[] password64 = store.password64 == null ? null : store.password64.toCharArray();
        EncryptedPersistentComponentUtil serialization = new EncryptedPersistentComponentUtil();
        serialization.addProvider(this);
        serialization.loadAndRegisterShutdown(store.file, password64, TimeUnit.HOURS.toSeconds(store.maxAge.intValue()), hook);
    }

    static {
        CoapConfig.register();
        DtlsConfig.register();
        LOGGER = LoggerFactory.getLogger(CoapServer.class);
        STATISTIC_LOGGER = LoggerFactory.getLogger("org.eclipse.californium.statistics");
        PRESELECTED_CIPHER_SUITES = Arrays.asList(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8, CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_PSK_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
        UDP_DROPS_READ_INTERVAL = new TimeDefinition("UDP_DROPS_READ_INTERVAL", "Interval to read UDP drops from OS (currently only Linux).", 2000L, TimeUnit.MILLISECONDS);
        CACHE_MAX_DEVICES = new IntegerDefinition("CACHE_MAX_DEVICES", "Cache maximum devices.", 5000, 100);
        CACHE_STALE_DEVICE_THRESHOLD = new TimeDefinition("CACHE_STALE_DEVICE_THRESHOLD", "Threshold for stale devices. Devices will only get removed for new ones, if at least for that threshold no messages are exchanged with that device.", 24L, TimeUnit.HOURS);
        HTTPS_CREDENTIALS_RELOAD_INTERVAL = new TimeDefinition("HTTPS_CREDENTIALS_RELOAD_INTERVAL", "Reload HTTPS credentials interval. 0 to load credentials only on startup.", 30L, TimeUnit.MINUTES);
        DEVICE_CREDENTIALS_RELOAD_INTERVAL = new TimeDefinition("DEVICE_CREDENTIALS_RELOAD_INTERVAL", "Reload device credentials interval. 0 to load credentials only on startup.", 60L, TimeUnit.SECONDS);
        DEFAULTS = new Configuration.DefinitionsProvider(){

            @Override
            public void applyDefinitions(Configuration config) {
                int processors = Runtime.getRuntime().availableProcessors();
                config.set(SystemConfig.HEALTH_STATUS_INTERVAL, 300, TimeUnit.SECONDS);
                config.set(CoapConfig.MAX_RESOURCE_BODY_SIZE, 8192);
                config.set(CoapConfig.MAX_MESSAGE_SIZE, 1280);
                config.set(CoapConfig.PREFERRED_BLOCK_SIZE, 1024);
                config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_COUNT, 4);
                config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_TIME, 30, TimeUnit.SECONDS);
                config.set(CoapConfig.MAX_ACTIVE_PEERS, 200000);
                config.set(CoapConfig.PEERS_MARK_AND_SWEEP_MESSAGES, 16);
                config.set(CoapConfig.DEDUPLICATOR, "PEERS_MARK_AND_SWEEP");
                config.set(CoapConfig.RESPONSE_MATCHING, CoapConfig.MatcherMode.PRINCIPAL_IDENTITY);
                config.set(CoapConfig.ACK_TIMEOUT, 2500, TimeUnit.MILLISECONDS);
                config.set(DtlsConfig.DTLS_ROLE, DtlsConfig.DtlsRole.SERVER_ONLY);
                config.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, 2500, TimeUnit.MILLISECONDS);
                config.set(DtlsConfig.DTLS_ADDITIONAL_ECC_TIMEOUT, 8, TimeUnit.SECONDS);
                config.set(DtlsConfig.DTLS_AUTO_HANDSHAKE_TIMEOUT, null, TimeUnit.SECONDS);
                config.set(DtlsConfig.DTLS_CONNECTION_ID_LENGTH, 6);
                config.set(DtlsConfig.DTLS_PRESELECTED_CIPHER_SUITES, PRESELECTED_CIPHER_SUITES);
                config.set(DtlsConfig.DTLS_MAX_CONNECTIONS, 200000);
                config.set(DtlsConfig.DTLS_REMOVE_STALE_DOUBLE_PRINCIPALS, true);
                config.set(DtlsConfig.DTLS_SERVER_USE_SESSION_ID, false);
                config.set(DtlsConfig.DTLS_RECEIVE_BUFFER_SIZE, 1000000);
                config.set(DtlsConfig.DTLS_RECEIVER_THREAD_COUNT, processors > 3 ? 2 : 1);
                config.set(DtlsConfig.DTLS_MAC_ERROR_FILTER_QUIET_TIME, 4, TimeUnit.SECONDS);
                config.set(DtlsConfig.DTLS_MAC_ERROR_FILTER_THRESHOLD, 8);
                config.set(UDP_DROPS_READ_INTERVAL, 2000, TimeUnit.MILLISECONDS);
                config.set(CACHE_MAX_DEVICES, 5000);
                config.set(CACHE_STALE_DEVICE_THRESHOLD, 24, TimeUnit.HOURS);
                config.set(HTTPS_CREDENTIALS_RELOAD_INTERVAL, 30, TimeUnit.MINUTES);
                config.set(DEVICE_CREDENTIALS_RELOAD_INTERVAL, 30, TimeUnit.SECONDS);
            }
        };
        String version = StringUtil.CALIFORNIUM_VERSION;
        if (version != null) {
            String build = StringUtil.readFile(new File("build"), null);
            if (build != null && !build.isEmpty()) {
                version = version + "_" + build;
            }
        } else {
            version = "";
        }
        CALIFORNIUM_BUILD_VERSION = version;
    }

    public static class ServerConfig {
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display a help message"})
        public boolean helpRequested;
        @CommandLine.ArgGroup(exclusive=true)
        public NetworkConfig network;
        @CommandLine.ArgGroup(exclusive=false)
        public HttpsConfig https;
        @CommandLine.ArgGroup(exclusive=false)
        public CoapsConfig coaps;
        @CommandLine.ArgGroup(exclusive=false)
        public DeviceStore deviceStore;
        @CommandLine.ArgGroup(exclusive=false)
        public Store store;
        @CommandLine.Option(names={"--diagnose"}, description={"enable 'diagnose'-resource."})
        public boolean diagnose;
        public boolean noCoap;

        public void defaults() {
            if (this.network == null) {
                this.network = new NetworkConfig();
                this.network.wildcard = true;
            }
        }

        public static class NetworkConfig {
            @CommandLine.Option(names={"--wildcard-interface"}, description={"Use local wildcard-address for coap endpoints."})
            public boolean wildcard;
            @CommandLine.ArgGroup(exclusive=false)
            public NetworkSelectConfig selectInterfaces;
        }

        public static class Store {
            @CommandLine.Option(names={"--store-file"}, required=true, description={"file-store for dtls state."})
            public String file;
            @CommandLine.Option(names={"--store-max-age"}, required=true, description={"maximum age of connections in hours to store dtls state."})
            public Integer maxAge;
            @CommandLine.Option(names={"--store-password64"}, required=false, description={"password to store dtls state. Base 64 encoded."})
            public String password64;
        }

        public static class DeviceStore {
            @CommandLine.Option(names={"--device-file"}, required=true, description={"Filename of device store for coap."})
            public String file;
            @CommandLine.Option(names={"--device-file-password64"}, required=false, description={"Password for device store. Base 64 encoded."})
            public String password64;
        }

        public static class CoapsConfig {
            @CommandLine.Option(names={"--coaps-credentials"}, required=true, description={"Folder containing coaps credentials in 'privkey.pem' and 'pubkey.pem'"})
            public String credentials;
            @CommandLine.Option(names={"--coaps-password64"}, required=false, description={"Password for device store. Base 64 encoded."})
            public String password64;
        }

        public static class HttpsConfig {
            @CommandLine.Option(names={"--https-port"}, required=true, description={"Port of https service."})
            public int port;
            @CommandLine.Option(names={"--https-credentials"}, required=true, description={"Folder containing https credentials in 'privkey.pem' and 'fullchain.pem'."})
            public String credentials;
            @CommandLine.Option(names={"--https-password64"}, description={"Folder containing https credentials in 'privkey.pem' and 'fullchain.pem'."})
            public String password64;
        }

        public static class NetworkSelectConfig {
            @CommandLine.Option(names={"--no-loopback"}, negatable=true, description={"enable coap endpoints on loopback network."})
            public boolean loopback = true;
            @CommandLine.Option(names={"--no-external"}, negatable=true, description={"enable coap endpoints on external network."})
            public boolean external = true;
            @CommandLine.Option(names={"--no-ipv4"}, negatable=true, description={"enable coap endpoints for ipv4."})
            public boolean ipv4 = true;
            @CommandLine.Option(names={"--no-ipv6"}, negatable=true, description={"enable coap endpoints for ipv6."})
            public boolean ipv6 = true;
            @CommandLine.Option(names={"--interfaces-pattern"}, split=",", description={"interface regex patterns for coap endpoints."})
            public List<String> interfacePatterns;

            public NetworkInterfacesUtil.InetAddressFilter getFilter(String tag) {
                if (this.interfacePatterns == null || this.interfacePatterns.isEmpty()) {
                    return new NetworkInterfacesUtil.SimpleInetAddressFilter(tag, this.external, this.loopback, this.ipv4, this.ipv6, new String[0]);
                }
                String[] patterns = new String[this.interfacePatterns.size()];
                patterns = this.interfacePatterns.toArray(patterns);
                return new NetworkInterfacesUtil.SimpleInetAddressFilter(tag, this.external, this.loopback, this.ipv4, this.ipv6, patterns);
            }
        }
    }

    public static enum InterfaceType {
        LOCAL,
        EXTERNAL,
        IPV4,
        IPV6;

    }
}

