/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Random;
import javax.crypto.SecretKey;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.cli.ConnectorConfig;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.util.StringUtil;
import picocli.CommandLine;

public class ClientConfig
extends ClientBaseConfig {
    @CommandLine.ArgGroup(exclusive=true)
    public ContentType contentType;
    @CommandLine.ArgGroup(exclusive=true)
    public Payload payload;
    @CommandLine.Option(names={"--payload-format"}, description={"apply format to payload."})
    public boolean payloadFormat;
    @CommandLine.ArgGroup(exclusive=true)
    public MessageType messageType;
    @CommandLine.Option(names={"-m", "--method"}, description={"use method. GET|PUT|POST|DELETE|FETCH|PATCH|IPATCH."})
    public CoAP.Code method;
    public static CommandLine.INegatableOptionTransformer messageTypeTransformer = new CommandLine.INegatableOptionTransformer(){
        private CommandLine.INegatableOptionTransformer delegate = CommandLine.RegexTransformer.createDefault();

        public String makeNegative(String optionName, CommandLine.Model.CommandSpec cmd) {
            if ("--con".equals(optionName)) {
                return "--non";
            }
            return this.delegate.makeNegative(optionName, cmd);
        }

        public String makeSynopsis(String optionName, CommandLine.Model.CommandSpec cmd) {
            if ("--con".equals(optionName)) {
                return "(--con|--non)";
            }
            return this.delegate.makeSynopsis(optionName, cmd);
        }
    };

    @Override
    public void register(CommandLine cmd) {
        super.register(cmd);
        cmd.setNegatableOptionTransformer(messageTypeTransformer);
    }

    @Override
    public void defaults() {
        super.defaults();
        if (this.contentType != null) {
            this.contentType.defaults();
        }
        if (this.payload != null) {
            int max = (Integer)this.configuration.get((BasicDefinition)CoapConfig.MAX_RESOURCE_BODY_SIZE);
            this.payload.defaults(max);
        }
    }

    @Override
    public ClientConfig create() {
        return (ClientConfig)super.create();
    }

    @Override
    public ClientConfig create(String id, SecretKey secret) {
        return (ClientConfig)super.create(id, secret);
    }

    @Override
    public ClientConfig create(PrivateKey privateKey, PublicKey publicKey) {
        return (ClientConfig)super.create(privateKey, publicKey);
    }

    public static class ContentType {
        @CommandLine.Option(names={"--json"}, description={"use json payload."})
        public boolean json;
        @CommandLine.Option(names={"--cbor"}, description={"use cbor payload."})
        public boolean cbor;
        @CommandLine.Option(names={"--xml"}, description={"use xml payload."})
        public boolean xml;
        @CommandLine.Option(names={"--text"}, description={"use plain-text payload."})
        public boolean text;
        @CommandLine.Option(names={"--octets"}, description={"use octet stream payload."})
        public boolean octets;
        @CommandLine.Option(names={"--ctype"}, paramLabel="TYPE", description={"use content type for payload."})
        public String type;
        public int contentType;

        public void defaults() {
            if (this.type != null) {
                this.contentType = MediaTypeRegistry.parse((String)this.type);
            } else if (this.text) {
                this.contentType = 0;
            } else if (this.json) {
                this.contentType = 50;
            } else if (this.cbor) {
                this.contentType = 60;
            } else if (this.xml) {
                this.contentType = 41;
            } else if (this.octets) {
                this.contentType = 42;
            }
        }
    }

    public static class Payload {
        @CommandLine.Option(names={"--payload"}, description={"payload, utf8"})
        public String text;
        @CommandLine.Option(names={"--payloadhex"}, description={"payload, hexadecimal"})
        public String hex;
        @CommandLine.Option(names={"--payload64"}, description={"payload, base64"})
        public String base64;
        @CommandLine.Option(names={"--payload-random"}, description={"random payload size"})
        public Integer size;
        @CommandLine.Option(names={"--payload-file"}, description={"payload from file"})
        public String filename;
        public byte[] payloadBytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void defaults(int max) {
            if (this.payloadBytes != null) return;
            if (this.text != null) {
                this.payloadBytes = this.text.getBytes();
                return;
            }
            if (this.hex != null) {
                this.payloadBytes = StringUtil.hex2ByteArray((String)this.hex);
                return;
            }
            if (this.base64 != null) {
                this.payloadBytes = StringUtil.base64ToByteArray((String)this.base64);
                return;
            }
            if (this.size != null) {
                if (this.size <= max) {
                    Random rand = new Random();
                    this.payloadBytes = new byte[this.size.intValue()];
                    for (int index = 0; index < this.size; ++index) {
                        this.payloadBytes[index] = (byte)(32 + rand.nextInt(95));
                    }
                    return;
                } else {
                    ConnectorConfig.LOGGER.error("Random payload with {} bytes is too large! (Maximum {} bytes.)", (Object)this.size, (Object)max);
                }
                return;
            }
            if (this.filename == null) return;
            File file = new File(this.filename);
            if (file.canRead()) {
                long length = file.length();
                if (length <= (long)max) {
                    this.payloadBytes = new byte[(int)length];
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(file);
                        int len = ((InputStream)in).read(this.payloadBytes);
                        if ((long)len == length) return;
                        ConnectorConfig.LOGGER.error("file {} with {} bytes, read {} bytes!", new Object[]{file, length, len});
                        return;
                    }
                    catch (FileNotFoundException e) {
                        ConnectorConfig.LOGGER.error("Missing file {}", (Object)file, (Object)e);
                        return;
                    }
                    catch (IOException e) {
                        ConnectorConfig.LOGGER.error("Error reading file {}", (Object)file, (Object)e);
                        return;
                    }
                    finally {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e) {
                                ConnectorConfig.LOGGER.error("Error closing file {}", (Object)file, (Object)e);
                            }
                        }
                    }
                }
                ConnectorConfig.LOGGER.error("file {} with {} bytes is too large! (Maximum {} bytes.)", new Object[]{file, length, max});
                return;
            }
            ConnectorConfig.LOGGER.error("Can not read file {} ({})", (Object)file, (Object)file.getAbsolutePath());
        }
    }

    public static class MessageType {
        @CommandLine.Option(names={"--con"}, description={"send request confirmed."})
        public boolean con;
        @CommandLine.Option(names={"--non"}, description={"send request non-confirmed."})
        public boolean non;
    }
}

