/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.cli.ConnectorConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.tcp.netty.TcpClientConnector;
import org.eclipse.californium.elements.tcp.netty.TlsClientConnector;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.SingleNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.pskstore.StringPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ClientInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientInitializer.class);
    public static final String KEY_DTLS_RETRANSMISSION_TIMEOUT = "DTLS_RETRANSMISSION_TIMEOUT";
    public static final String PSK_IDENTITY_PREFIX = "cali.";
    private static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final char[] TRUST_STORE_PASSWORD = "rootPass".toCharArray();
    private static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";
    private static final String CLIENT_NAME = "client";
    private static final SecretKey PSK_SECRET = SecretUtil.create((byte[])".fornium".getBytes(), (String)"PSK");
    private static SslContextUtil.Credentials clientCredentials = null;
    private static Certificate[] trustedCertificates = null;
    private static String defaultIdentity;
    private static String defaultSecret;

    public static void setDefaultPskCredentials(String identity, String secret) {
        defaultIdentity = identity;
        defaultSecret = secret;
    }

    public static void init(String[] args, ClientBaseConfig config, boolean ephemeralPort) throws IOException {
        CommandLine cmd = new CommandLine((Object)config);
        config.register(cmd);
        try {
            CommandLine.ParseResult result = cmd.parseArgs(args);
            if (result.isVersionHelpRequested()) {
                String version = StringUtil.CALIFORNIUM_VERSION == null ? "" : StringUtil.CALIFORNIUM_VERSION;
                System.out.println("\nCalifornium (Cf) " + cmd.getCommandName() + " " + version);
                cmd.printVersionHelp(System.out);
                System.out.println();
            }
            config.defaults();
            if (config.helpRequested) {
                cmd.usage(System.out);
                if (config.authHelpRequested) {
                    System.out.println();
                    System.out.println("   --auth: values");
                    ClientInitializer.print("      ", 60, Arrays.asList(ConnectorConfig.AuthenticationMode.values()), System.out);
                }
                if (config.cipherHelpRequested) {
                    ArrayList<CipherSuite> list = new ArrayList<CipherSuite>();
                    for (CipherSuite cipherSuite : CipherSuite.values()) {
                        if (!cipherSuite.isSupported() || CipherSuite.TLS_NULL_WITH_NULL_NULL.equals((Object)cipherSuite)) continue;
                        list.add(cipherSuite);
                    }
                    System.out.println();
                    System.out.println("   --cipher: values");
                    ClientInitializer.print("      ", 60, list, System.out);
                }
                return;
            }
        }
        catch (CommandLine.ParameterException ex) {
            System.err.println(ex.getMessage());
            System.err.println();
            cmd.usage(System.err);
            System.exit(-1);
        }
        if (config.secure && config.identity == null && config.secret == null) {
            config.identity = defaultIdentity;
            config.secret = new ConnectorConfig.Secret();
            config.secret.text = defaultSecret;
            if (config.authenticationModes.isEmpty()) {
                config.authenticationModes.add(ConnectorConfig.AuthenticationMode.PSK);
            }
        }
        CoapEndpoint coapEndpoint = ClientInitializer.createEndpoint(config, null, ephemeralPort);
        coapEndpoint.start();
        LOGGER.info("endpoint started at {}", (Object)coapEndpoint.getAddress());
        EndpointManager.getEndpointManager().setDefaultEndpoint((Endpoint)coapEndpoint);
    }

    public static CoapEndpoint createEndpoint(ClientBaseConfig clientConfig, ExecutorService executor, boolean ephemeralPort) {
        NetworkConfig config = clientConfig.networkConfig;
        int tcpThreads = config.getInt("TCP_WORKER_THREADS");
        int tcpConnectTimeout = config.getInt("TCP_CONNECT_TIMEOUT");
        int tlsHandshakeTimeout = config.getInt("TLS_HANDSHAKE_TIMEOUT");
        int tcpIdleTimeout = config.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
        int maxPeers = config.getInt("MAX_ACTIVE_PEERS");
        int sessionTimeout = config.getInt("SECURE_SESSION_TIMEOUT");
        int staleTimeout = config.getInt("MAX_PEER_INACTIVITY_PERIOD");
        int senderThreads = config.getInt("NETWORK_STAGE_SENDER_THREAD_COUNT");
        int receiverThreads = config.getInt("NETWORK_STAGE_RECEIVER_THREAD_COUNT");
        int retransmissionTimeout = config.getInt("ACK_TIMEOUT");
        Integer healthStatusInterval = config.getInt("HEALTH_STATUS_INTERVAL");
        Integer cidLength = config.getOptInteger("DTLS_CONNECTION_ID_LENGTH");
        Integer recvBufferSize = config.getOptInteger("UDP_CONNECTOR_RECEIVE_BUFFER");
        Integer sendBufferSize = config.getOptInteger("UDP_CONNECTOR_SEND_BUFFER");
        Integer dtlsRetransmissionTimeout = config.getOptInteger(KEY_DTLS_RETRANSMISSION_TIMEOUT);
        if (dtlsRetransmissionTimeout != null) {
            retransmissionTimeout = dtlsRetransmissionTimeout;
        }
        CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
        if (clientConfig.uri.startsWith("coaps")) {
            if (clientCredentials == null || trustedCertificates == null) {
                try {
                    clientCredentials = SslContextUtil.loadCredentials((String)"classpath://certs/keyStore.jks", (String)CLIENT_NAME, (char[])KEY_STORE_PASSWORD, (char[])KEY_STORE_PASSWORD);
                    trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", null, (char[])TRUST_STORE_PASSWORD);
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SSLContext clientSslContext = null;
            if (clientCredentials != null && trustedCertificates != null) {
                try {
                    clientSslContext = SslContextUtil.createSSLContext((String)CLIENT_NAME, (PrivateKey)clientCredentials.getPrivateKey(), (X509Certificate[])clientCredentials.getCertificateChain(), (Certificate[])trustedCertificates);
                    SSLSessionContext clientSessionContext = clientSslContext.getClientSessionContext();
                    if (clientSessionContext != null) {
                        clientSessionContext.setSessionTimeout(sessionTimeout);
                        clientSessionContext.setSessionCacheSize(maxPeers);
                    }
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
            if (clientConfig.uri.startsWith("coaps://")) {
                int coapsPort = ephemeralPort ? 0 : config.getInt("COAP_SECURE_PORT");
                DtlsConnectorConfig.Builder dtlsConfig = new DtlsConnectorConfig.Builder();
                boolean psk = false;
                ArrayList<CipherSuite.KeyExchangeAlgorithm> keyExchangeAlgorithms = new ArrayList<CipherSuite.KeyExchangeAlgorithm>();
                ArrayList<CertificateType> certificateTypes = new ArrayList<CertificateType>();
                for (ConnectorConfig.AuthenticationMode auth : clientConfig.authenticationModes) {
                    switch (auth) {
                        case NONE: {
                            break;
                        }
                        case PSK: {
                            psk = true;
                            keyExchangeAlgorithms.add(CipherSuite.KeyExchangeAlgorithm.PSK);
                            break;
                        }
                        case RPK: {
                            certificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
                            keyExchangeAlgorithms.add(CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN);
                            dtlsConfig.setRpkTrustAll();
                            break;
                        }
                        case X509: {
                            certificateTypes.add(CertificateType.X_509);
                            dtlsConfig.setTrustStore(trustedCertificates);
                            keyExchangeAlgorithms.add(CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN);
                            break;
                        }
                        case ECDHE_PSK: {
                            psk = true;
                            keyExchangeAlgorithms.add(CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK);
                        }
                    }
                }
                if (!certificateTypes.isEmpty()) {
                    dtlsConfig.setIdentity(clientCredentials.getPrivateKey(), (Certificate[])clientCredentials.getCertificateChain(), certificateTypes);
                }
                if (psk) {
                    if (clientConfig.identity != null) {
                        dtlsConfig.setPskStore((PskStore)new PlugPskStore(clientConfig.identity, clientConfig.secretKey));
                    } else {
                        byte[] rid = new byte[8];
                        SecureRandom random = new SecureRandom();
                        random.nextBytes(rid);
                        dtlsConfig.setPskStore((PskStore)new PlugPskStore(StringUtil.byteArray2Hex((byte[])rid)));
                    }
                }
                if (!keyExchangeAlgorithms.isEmpty() && (clientConfig.cipherSuites == null || clientConfig.cipherSuites.isEmpty())) {
                    clientConfig.cipherSuites = CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)false, (boolean)true, keyExchangeAlgorithms);
                }
                if (clientConfig.cipherSuites != null && !clientConfig.cipherSuites.isEmpty()) {
                    dtlsConfig.setRecommendedCipherSuitesOnly(false);
                    dtlsConfig.setSupportedCipherSuites(clientConfig.cipherSuites);
                    if (clientConfig.verbose) {
                        System.out.println("cipher suites:");
                        ClientInitializer.print("   ", 50, clientConfig.cipherSuites, System.out);
                    }
                }
                if (cidLength != null) {
                    dtlsConfig.setConnectionIdGenerator((ConnectionIdGenerator)new SingleNodeConnectionIdGenerator(cidLength.intValue()));
                }
                dtlsConfig.setSocketReceiveBufferSize(recvBufferSize);
                dtlsConfig.setSocketSendBufferSize(sendBufferSize);
                dtlsConfig.setClientOnly();
                dtlsConfig.setRetransmissionTimeout(retransmissionTimeout);
                dtlsConfig.setMaxConnections(maxPeers);
                dtlsConfig.setConnectionThreadCount(senderThreads);
                dtlsConfig.setReceiverThreadCount(receiverThreads);
                dtlsConfig.setStaleConnectionThreshold((long)staleTimeout);
                dtlsConfig.setAddress(new InetSocketAddress(coapsPort));
                dtlsConfig.setHealthStatusInterval(healthStatusInterval);
                DTLSConnector dtlsConnector = new DTLSConnector(dtlsConfig.build());
                if (executor != null) {
                    dtlsConnector.setExecutor(executor);
                }
                builder.setConnector((Connector)dtlsConnector);
            } else if (clientConfig.uri.startsWith("coaps+tcp://")) {
                builder.setConnector((Connector)new TlsClientConnector(clientSslContext, tcpThreads, tcpConnectTimeout, tlsHandshakeTimeout, tcpIdleTimeout));
            }
        } else if (clientConfig.uri.startsWith("coap+tcp://")) {
            builder.setConnector((Connector)new TcpClientConnector(tcpThreads, tcpConnectTimeout, tcpIdleTimeout));
        } else if (clientConfig.uri.startsWith("coap://")) {
            int coapPort = ephemeralPort ? 0 : config.getInt("COAP_PORT");
            builder.setConnectorWithAutoConfiguration(new UDPConnector(new InetSocketAddress(coapPort)));
        }
        builder.setNetworkConfig(config);
        CoapEndpoint endpoint = builder.build();
        if (clientConfig.verbose) {
            endpoint.addInterceptor((MessageInterceptor)new MessageTracer());
        }
        return endpoint;
    }

    public static void print(String tab, int width, List<?> values, PrintStream out) {
        StringBuilder line = new StringBuilder();
        line.append(tab);
        for (Object value : values) {
            String name = value.toString();
            if (line.length() + name.length() > width) {
                out.println(line);
                line.setLength(tab.length());
            }
            line.append(name).append(" ");
        }
        out.println(line);
    }

    public static class PlugPskStore
    extends StringPskStore {
        private final String identity;
        private final SecretKey secret;

        public PlugPskStore(String id, byte[] secret) {
            this.identity = id;
            this.secret = secret == null ? PSK_SECRET : SecretUtil.create((byte[])secret, (String)"PSK");
            LOGGER.trace("DTLS-PSK-Identity: {}", (Object)this.identity);
        }

        public PlugPskStore(String id) {
            this.identity = ClientInitializer.PSK_IDENTITY_PREFIX + id;
            this.secret = null;
            LOGGER.trace("DTLS-PSK-Identity: {} ({} random bytes)", (Object)this.identity, (Object)(id.length() / 2));
        }

        public SecretKey getKey(String identity) {
            if (this.secret != null) {
                return SecretUtil.create((SecretKey)this.secret);
            }
            if (identity.startsWith(ClientInitializer.PSK_IDENTITY_PREFIX)) {
                return SecretUtil.create((SecretKey)PSK_SECRET);
            }
            return null;
        }

        public SecretKey getKey(ServerNames serverNames, String identity) {
            return this.getKey(identity);
        }

        public String getIdentityAsString(InetSocketAddress inetAddress) {
            return this.identity;
        }

        public String getIdentityAsString(InetSocketAddress peerAddress, ServerNames virtualHost) {
            return this.getIdentityAsString(peerAddress);
        }
    }
}

