/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import picocli.CommandLine;

public class ClientConfig
extends ClientBaseConfig {
    @CommandLine.ArgGroup(exclusive=true)
    public ContentType contentType;
    @CommandLine.ArgGroup(exclusive=true)
    public Payload payload;
    public byte[] payloadBytes;
    @CommandLine.Option(names={"--con"}, description={"send request confirmed or non-confirmed. Default confirmed."})
    public Boolean con;
    @CommandLine.Option(names={"-m", "--method"}, description={"use method. GET|PUT|POST|DELETE|FETCH|PATHC|IPATCH."})
    public CoAP.Code code;
    protected static CommandLine.INegatableOptionTransformer messageTypeTransformer = new CommandLine.INegatableOptionTransformer(){
        private CommandLine.INegatableOptionTransformer delegate = CommandLine.RegexTransformer.createDefault();

        public String makeNegative(String optionName, CommandLine.Model.CommandSpec cmd) {
            if ("--con".equals(optionName)) {
                return "--non";
            }
            return this.delegate.makeNegative(optionName, cmd);
        }

        public String makeSynopsis(String optionName, CommandLine.Model.CommandSpec cmd) {
            if ("--con".equals(optionName)) {
                return "(--con|--non)";
            }
            return this.delegate.makeSynopsis(optionName, cmd);
        }
    };

    @Override
    public void register(CommandLine cmd) {
        super.register(cmd);
        cmd.setNegatableOptionTransformer(messageTypeTransformer);
    }

    @Override
    public void defaults() {
        super.defaults();
        if (this.contentType != null) {
            this.contentType.defaults();
        }
        if (this.payload != null && this.payloadBytes == null) {
            if (this.payload.text != null) {
                this.payloadBytes = this.payload.text.getBytes();
            } else if (this.payload.hex != null) {
                this.payloadBytes = StringUtil.hex2ByteArray((String)this.payload.hex);
            } else if (this.payload.base64 != null) {
                this.payloadBytes = StringUtil.base64ToByteArray((String)this.payload.base64);
            }
        }
    }

    @Override
    public ClientConfig create(String id, byte[] secret) {
        ClientConfig clone = null;
        try {
            clone = (ClientConfig)this.clone();
            clone.identity = id;
            clone.secretKey = secret;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    @Override
    public ClientConfig create(PrivateKey privateKey, PublicKey publicKey) {
        ClientConfig clone = null;
        try {
            clone = (ClientConfig)this.clone();
            clone.credentials = new SslContextUtil.Credentials(privateKey, publicKey, null);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public static class Payload {
        @CommandLine.Option(names={"--payload"}, description={"payload, utf8"})
        public String text;
        @CommandLine.Option(names={"--payloadhex"}, description={"payload, hexadecimal"})
        public String hex;
        @CommandLine.Option(names={"--payload64"}, description={"payload, base64"})
        public String base64;
    }

    public static class ContentType {
        @CommandLine.Option(names={"--json"}, description={"use json payload."})
        public boolean json;
        @CommandLine.Option(names={"--cbor"}, description={"use cbor payload."})
        public boolean cbor;
        @CommandLine.Option(names={"--xml"}, description={"use xml payload."})
        public boolean xml;
        @CommandLine.Option(names={"--text"}, description={"use plain-text payload."})
        public boolean text;
        @CommandLine.Option(names={"--octets"}, description={"use octet stream payload."})
        public boolean octets;
        @CommandLine.Option(names={"--ctype"}, paramLabel="TYPE", description={"use content type for payload."})
        public String type;
        public int contentType;

        void defaults() {
            if (this.type != null) {
                this.contentType = MediaTypeRegistry.parse((String)this.type);
            } else if (this.text) {
                this.contentType = 0;
            } else if (this.json) {
                this.contentType = 50;
            } else if (this.cbor) {
                this.contentType = 60;
            } else if (this.xml) {
                this.contentType = 41;
            } else if (this.octets) {
                this.contentType = 42;
            }
        }
    }
}

