/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.eclipse.californium.cli.ConnectorConfig;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import picocli.CommandLine;

public class ClientBaseConfig
extends ConnectorConfig {
    @CommandLine.Option(names={"--proxy"}, description={"use proxy. <address>:<port>[:<scheme>]. Default env-value of COAP_PROXY."})
    public ProxyConfiguration proxy;
    @CommandLine.Parameters(index="0", paramLabel="URI", arity="0..1", defaultValue="californium.eclipse.org", description={"destination URI. Default ."})
    public String uri;
    public boolean secure;
    public boolean tcp;
    private static CommandLine.ITypeConverter<ProxyConfiguration> proxyReader = new CommandLine.ITypeConverter<ProxyConfiguration>(){

        public ProxyConfiguration convert(String value) throws Exception {
            String host;
            int index;
            String config = value;
            if (config.startsWith("[")) {
                index = config.indexOf("]:");
                if (index < 0) {
                    throw new IllegalArgumentException(value + " invalid proxy configuration!");
                }
                host = config.substring(0, index + 1);
                config = config.substring(index + 2);
            } else {
                index = config.indexOf(":");
                if (index < 0) {
                    throw new IllegalArgumentException(value + " invalid proxy configuration!");
                }
                host = config.substring(0, index);
                config = config.substring(index + 1);
            }
            String scheme = null;
            index = config.indexOf(":");
            if (index > 0) {
                scheme = config.substring(index + 1);
                config = config.substring(0, index);
            }
            try {
                InetSocketAddress destination = new InetSocketAddress(host, Integer.parseInt(config));
                return new ProxyConfiguration(scheme, destination);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException(value + " invalid proxy configuration!", ex);
            }
        }
    };

    @Override
    public void register(CommandLine cmd) {
        super.register(cmd);
        cmd.registerConverter(ProxyConfiguration.class, proxyReader);
    }

    @Override
    public void defaults() {
        String proxySpec;
        super.defaults();
        if (this.proxy == null && (proxySpec = StringUtil.getConfiguration((String)"COAP_PROXY")) != null && !proxySpec.isEmpty()) {
            try {
                this.proxy = (ProxyConfiguration)proxyReader.convert(proxySpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.uri.indexOf("://") == -1) {
            if (this.authenticationModes != null && !this.authenticationModes.isEmpty()) {
                this.uri = "coaps://" + this.uri;
                this.secure = true;
            } else {
                this.uri = "coap://" + this.uri;
            }
        } else {
            this.secure = this.uri.startsWith("coaps://") || this.uri.startsWith("coaps+tcp://");
            boolean bl = this.tcp = this.uri.startsWith("coap+tcp://") || this.uri.startsWith("coaps+tcp://");
        }
        if (this.uri.endsWith("/")) {
            this.uri = this.uri.substring(this.uri.length() - 1);
        }
    }

    public ClientBaseConfig create(String id, byte[] secret) {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            clone.identity = id;
            clone.secretKey = secret;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public ClientBaseConfig create(PrivateKey privateKey, PublicKey publicKey) {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            clone.credentials = new SslContextUtil.Credentials(privateKey, publicKey, null);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public static class ProxyConfiguration {
        public final String scheme;
        public final InetSocketAddress destination;

        public ProxyConfiguration(String scheme, InetSocketAddress destination) {
            if (destination == null) {
                throw new NullPointerException("proxy destination must not be null!");
            }
            this.scheme = scheme;
            this.destination = destination;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(StringUtil.toString((InetSocketAddress)this.destination));
            if (this.scheme != null) {
                builder.append(" using ").append(this.scheme);
            }
            return builder.toString();
        }
    }
}

