/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.tcp.netty.TcpServerConnector;
import org.eclipse.californium.elements.tcp.netty.TlsContextUtil;
import org.eclipse.californium.elements.util.StringUtil;

public class TlsServerConnector
extends TcpServerConnector {
    private final CertificateAuthenticationMode clientAuthMode;
    private final SSLContext sslContext;
    private final String[] weakCipherSuites;
    private final long handshakeTimeoutMillis;

    public TlsServerConnector(SSLContext sslContext, InetSocketAddress socketAddress, Configuration configuration) {
        super(socketAddress, configuration, new TlsContextUtil((CertificateAuthenticationMode)configuration.get((BasicDefinition)TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE)));
        this.sslContext = sslContext;
        this.clientAuthMode = (CertificateAuthenticationMode)configuration.get((BasicDefinition)TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE);
        this.handshakeTimeoutMillis = configuration.get(TcpConfig.TLS_HANDSHAKE_TIMEOUT, TimeUnit.MILLISECONDS);
        this.weakCipherSuites = TlsContextUtil.getWeakCipherSuites(sslContext);
    }

    @Override
    protected void onNewChannelCreated(Channel ch) {
        SSLEngine sslEngine = this.createSllEngineForChannel(ch);
        switch (this.clientAuthMode) {
            case NONE: {
                break;
            }
            case WANTED: {
                sslEngine.setWantClientAuth(true);
                break;
            }
            case NEEDED: {
                sslEngine.setNeedClientAuth(true);
            }
        }
        sslEngine.setUseClientMode(false);
        if (this.weakCipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.weakCipherSuites);
        }
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        ch.pipeline().addFirst(sslHandler);
    }

    @Override
    public String getProtocol() {
        return "TLS";
    }

    private SSLEngine createSllEngineForChannel(Channel ch) {
        SocketAddress remoteAddress = ch.remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            this.LOGGER.info("Connection from inet {}", StringUtil.toLog((SocketAddress)remoteAddress));
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            return this.sslContext.createSSLEngine(remote.getAddress().getHostAddress(), remote.getPort());
        }
        this.LOGGER.info("Connection from {}", StringUtil.toLog((SocketAddress)remoteAddress));
        return this.sslContext.createSSLEngine();
    }
}

