/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.NotSslRecordException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLException;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloseOnErrorHandler
extends ChannelHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseOnErrorHandler.class);
    private static final Logger LOGGER_BAN = LoggerFactory.getLogger((String)"org.eclipse.californium.ban");

    CloseOnErrorHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            SocketAddress remoteAddress;
            boolean ban;
            Throwable rootCause = cause;
            while (null != rootCause.getCause()) {
                rootCause = rootCause.getCause();
            }
            String error = rootCause.toString();
            String remote = StringUtil.toString((SocketAddress)ctx.channel().remoteAddress());
            if (rootCause instanceof SSLException || rootCause instanceof GeneralSecurityException || rootCause instanceof RejectedExecutionException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn("{} in channel handler chain for endpoint {}. Closing connection.", new Object[]{error, remote, rootCause});
                } else {
                    LOGGER.warn("{} in channel handler chain for endpoint {}. Closing connection.", (Object)error, (Object)remote);
                }
            } else if (rootCause instanceof IOException) {
                LOGGER.warn("{} in channel handler chain for endpoint {}. Closing connection.", (Object)error, (Object)remote);
            } else {
                LOGGER.error("{} in channel handler chain for endpoint {}. Closing connection.", (Object)error, (Object)cause);
            }
            if (LOGGER_BAN.isInfoEnabled() && (ban = rootCause instanceof NotSslRecordException) && (remoteAddress = ctx.channel().remoteAddress()) instanceof InetSocketAddress) {
                remote = ((InetSocketAddress)remoteAddress).getAddress().getHostAddress();
                LOGGER_BAN.info("TLS Ban: {}", (Object)remote);
            }
        }
        finally {
            ctx.close();
        }
    }
}

