/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.proxy2.ClientEndpoints;
import org.eclipse.californium.proxy2.Coap2CoapTranslator;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.resources.CacheKey;
import org.eclipse.californium.proxy2.resources.CacheResource;
import org.eclipse.californium.proxy2.resources.ProxyCoapResource;
import org.eclipse.californium.proxy2.resources.StatsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyCoapClientResource
extends ProxyCoapResource {
    static final Logger LOGGER = LoggerFactory.getLogger(ProxyCoapClientResource.class);
    private Map<String, ClientEndpoints> mapSchemeToEndpoints = new HashMap<String, ClientEndpoints>();
    private Coap2CoapTranslator translator;

    public ProxyCoapClientResource(String name, boolean visible, boolean accept, Coap2CoapTranslator translator, ClientEndpoints ... endpointsList) {
        super(name, visible, accept);
        this.getAttributes().setTitle("Forward the requests to a CoAP server.");
        this.translator = translator != null ? translator : new Coap2CoapTranslator();
        for (ClientEndpoints endpoints : endpointsList) {
            this.mapSchemeToEndpoints.put(endpoints.getScheme(), endpoints);
        }
    }

    @Override
    public void handleRequest(Exchange exchange) {
        Request incomingRequest = exchange.getRequest();
        LOGGER.debug("ProxyCoapClientResource forwards {}", (Object)incomingRequest);
        try {
            InetSocketAddress exposedInterface = this.translator.getExposedInterface(incomingRequest);
            URI destination = this.translator.getDestinationURI(incomingRequest, exposedInterface);
            Request outgoingRequest = this.translator.getRequest(destination, incomingRequest);
            if (outgoingRequest.getDestinationContext() == null) {
                exchange.sendResponse(new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
                throw new NullPointerException("Destination is null");
            }
            CacheKey cacheKey = null;
            CacheResource cache = this.getCache();
            if (cache != null) {
                cacheKey = new CacheKey(outgoingRequest.getCode(), destination, outgoingRequest.getOptions().getAccept(), outgoingRequest.getPayload());
                Response response = cache.getResponse(cacheKey);
                StatsResource statsResource = this.getStatsResource();
                if (statsResource != null) {
                    statsResource.updateStatistics(destination, response != null);
                }
                if (response != null) {
                    LOGGER.info("Cache returned {}", (Object)response);
                    exchange.sendResponse(response);
                    return;
                }
            }
            LOGGER.debug("Sending proxied CoAP request to {}", (Object)outgoingRequest.getDestinationContext());
            if (this.accept) {
                exchange.sendAccept();
            }
            outgoingRequest.addMessageObserver((MessageObserver)new ProxySendResponseMessageObserver(this.translator, exchange, cacheKey, cache, this));
            ClientEndpoints endpoints = this.mapSchemeToEndpoints.get(outgoingRequest.getScheme());
            endpoints.sendRequest(outgoingRequest);
        }
        catch (TranslationException e) {
            LOGGER.debug("Proxy-uri option malformed: {}", (Object)e.getMessage());
            Response response = new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED);
            response.setPayload(e.getMessage());
            exchange.sendResponse(response);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to execute request: {}", (Object)e.getMessage(), (Object)e);
            exchange.sendResponse(new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
        }
    }

    @Override
    public CoapUriTranslator getUriTranslater() {
        return this.translator;
    }

    @Override
    public Set<String> getDestinationSchemes() {
        return Collections.unmodifiableSet(this.mapSchemeToEndpoints.keySet());
    }

    private static class ProxySendResponseMessageObserver
    extends MessageObserverAdapter {
        private final Coap2CoapTranslator translator;
        private final Exchange incomingExchange;
        private final CacheKey cacheKey;
        private final CacheResource cache;
        private final ProxyCoapResource baseResource;

        private ProxySendResponseMessageObserver(Coap2CoapTranslator translator, Exchange incomingExchange, CacheKey cacheKey, CacheResource cache, ProxyCoapResource baseResource) {
            this.translator = translator;
            this.incomingExchange = incomingExchange;
            this.cacheKey = cacheKey;
            this.cache = cache;
            this.baseResource = baseResource;
        }

        public void onResponse(Response incomingResponse) {
            int size = incomingResponse.getPayloadSize();
            if (!this.baseResource.checkMaxResourceBodySize(size)) {
                incomingResponse = new Response(CoAP.ResponseCode.BAD_GATEWAY);
                incomingResponse.setPayload("CoAP response of " + size + " bytes exceeds maximum support size of " + this.baseResource.getMaxResourceBodySize() + " bytes!");
                incomingResponse.getOptions().setContentFormat(0);
            }
            if (this.cache != null) {
                this.cache.cacheResponse(this.cacheKey, incomingResponse);
            }
            LOGGER.debug("ProxyCoapClientResource received {}", (Object)incomingResponse);
            this.incomingExchange.sendResponse(this.translator.getResponse(incomingResponse));
        }

        public void onReject() {
            this.fail(CoAP.ResponseCode.SERVICE_UNAVAILABLE);
            LOGGER.debug("Request rejected");
        }

        public void onTimeout() {
            this.fail(CoAP.ResponseCode.GATEWAY_TIMEOUT);
            LOGGER.debug("Request timed out.");
        }

        public void onCancel() {
            this.fail(CoAP.ResponseCode.SERVICE_UNAVAILABLE);
            LOGGER.debug("Request canceled");
        }

        public void onSendError(Throwable e) {
            this.fail(CoAP.ResponseCode.SERVICE_UNAVAILABLE);
            LOGGER.warn("Send error", e);
        }

        private void fail(CoAP.ResponseCode response) {
            this.incomingExchange.sendResponse(new Response(response));
        }
    }
}

