/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.RequestDate;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.ReflectionUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.proxy2.config.Proxy2Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final TimeValue KEEP_ALIVE = TimeValue.ofSeconds((long)5L);
    private static AtomicReference<Configuration> config = new AtomicReference();

    private HttpClientFactory() {
    }

    public static Configuration setNetworkConfig(Configuration config) {
        return HttpClientFactory.config.getAndSet(config);
    }

    public static Configuration getNetworkConfig() {
        Configuration config = HttpClientFactory.config.get();
        if (config == null) {
            HttpClientFactory.config.compareAndSet(null, Configuration.getStandard());
            config = HttpClientFactory.config.get();
        }
        return config;
    }

    public static CloseableHttpAsyncClient createClient() {
        return HttpClientFactory.createClient(HttpClientFactory.getNetworkConfig());
    }

    public static CloseableHttpAsyncClient createClient(Configuration config) {
        HttpVersionPolicy policy;
        int connectionIdleSecs = config.getTimeAsInt(Proxy2Config.HTTP_CONNECTION_IDLE_TIMEOUT, TimeUnit.SECONDS);
        switch ((Proxy2Config.HttpVersion)((Object)config.get(Proxy2Config.HTTP_VERSION_POLICY))) {
            case HTTP_1: {
                policy = HttpVersionPolicy.FORCE_HTTP_1;
                break;
            }
            case HTTP_2: {
                policy = HttpVersionPolicy.FORCE_HTTP_2;
                break;
            }
            case NEGOTIATE: {
                policy = HttpVersionPolicy.NEGOTIATE;
                break;
            }
            default: {
                policy = HttpVersionPolicy.NEGOTIATE;
            }
        }
        CloseableHttpAsyncClient client = HttpAsyncClientBuilder.create().disableCookieManagement().setDefaultRequestConfig(HttpClientFactory.createCustomRequestConfig(config)).setConnectionManager((AsyncClientConnectionManager)HttpClientFactory.createPoolingConnManager(config)).setVersionPolicy(policy).setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)connectionIdleSecs)).build()).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestDate()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
                TimeValue keepAlive = super.getKeepAliveDuration(response, context);
                if (keepAlive == null || keepAlive.getDuration() < 0L) {
                    keepAlive = KEEP_ALIVE;
                }
                return keepAlive;
            }
        }).build();
        client.start();
        return client;
    }

    private static RequestConfig createCustomRequestConfig(Configuration config) {
        long connecTimeoutMillis = config.get(Proxy2Config.HTTP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        return RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds((long)(connecTimeoutMillis * 4L))).setConnectTimeout(Timeout.ofMilliseconds((long)connecTimeoutMillis)).build();
    }

    private static PoolingAsyncClientConnectionManager createPoolingConnManager(Configuration config) {
        long connectionIdleSecs = config.get(Proxy2Config.HTTP_CONNECTION_IDLE_TIMEOUT, TimeUnit.MILLISECONDS);
        return PoolingAsyncClientConnectionManagerBuilder.create().setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setConnectionTimeToLive(TimeValue.ofSeconds((long)connectionIdleSecs)).setMaxConnTotal(250).setMaxConnPerRoute(50).setTlsStrategy(ClientTlsStrategyBuilder.create().useSystemProperties().setTlsDetailsFactory((Factory)new TlsDetailsFactory()).build()).build();
    }

    private static class TlsDetailsFactory
    implements Factory<SSLEngine, TlsDetails> {
        private final Method getApplicationProtocolMethod;

        private TlsDetailsFactory() {
            Method getApplicationProtocolMethod = null;
            try {
                getApplicationProtocolMethod = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (ReflectionUtils.determineJRELevel() > 7) {
                    LOGGER.info("SSLEngine.getApplicationProtocol() missing!", (Throwable)e);
                }
            }
            catch (SecurityException e) {
                LOGGER.warn("SSLEngine.getApplicationProtocol()", (Throwable)e);
            }
            this.getApplicationProtocolMethod = getApplicationProtocolMethod;
        }

        private String getApplicationProtocol(SSLEngine sslEngine) {
            String applicationProtocol = null;
            if (this.getApplicationProtocolMethod != null) {
                try {
                    applicationProtocol = (String)this.getApplicationProtocolMethod.invoke((Object)sslEngine, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("SSLEngine.getApplicationProtocol()", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("SSLEngine.getApplicationProtocol()", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.warn("SSLEngine.getApplicationProtocol()", (Throwable)e);
                }
            } else {
                applicationProtocol = (String)ReflectionUtils.callGetter((Object)sslEngine, (String)"ApplicationProtocol", String.class);
            }
            if (applicationProtocol != null) {
                LOGGER.info("SSLEngine: application protocol {}", (Object)applicationProtocol);
            }
            return applicationProtocol;
        }

        public TlsDetails create(SSLEngine sslEngine) {
            String applicationProtocol = this.getApplicationProtocol(sslEngine);
            return new TlsDetails(sslEngine.getSession(), applicationProtocol);
        }
    }
}

