/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.HeaderValueParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.proxy2.InvalidMethodException;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;
import org.eclipse.californium.proxy2.http.MappingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossProtocolTranslator {
    private static MappingProperties defaultMappingProperties;
    private final MappingProperties translationMapping;
    private final HeaderValueParser parser = new BasicHeaderValueParser();
    public static final int STATUS_TIMEOUT = 504;
    public static final int STATUS_NOT_FOUND = 502;
    public static final int STATUS_TRANSLATION_ERROR = 502;
    public static final int STATUS_URI_MALFORMED = 400;
    public static final int STATUS_WRONG_METHOD = 501;
    public static final int STATUS_INTERNAL_SERVER_ERROR = 500;
    private static final Logger LOGGER;

    private static synchronized MappingProperties getDefaultMappingProperties() {
        if (defaultMappingProperties == null) {
            defaultMappingProperties = new MappingProperties("Proxy2.properties");
        }
        return defaultMappingProperties;
    }

    public CrossProtocolTranslator(String mappingPropertiesFileName) {
        this.translationMapping = new MappingProperties(mappingPropertiesFileName);
    }

    public CrossProtocolTranslator() {
        this.translationMapping = CrossProtocolTranslator.getDefaultMappingProperties();
    }

    public CrossProtocolTranslator(MappingProperties properties) {
        this.translationMapping = properties;
    }

    public CoAP.ResponseCode getCoapResponseCode(CoAP.Code coapMethod, int httpCode) throws TranslationException {
        CoAP.ResponseCode responseCode = this.translationMapping.getCoapResponseCode(coapMethod, httpCode);
        if (responseCode == null) {
            LOGGER.debug("coap response code missing for {}", (Object)httpCode);
            throw new TranslationException("coap response-code missing for " + httpCode + "!");
        }
        return responseCode;
    }

    public CoAP.Code getCoapCode(String httpMethod) throws InvalidMethodException {
        return this.translationMapping.getCoapCode(httpMethod);
    }

    public int getCoapMediaType(String mimeType) {
        return this.getCoapMediaType(mimeType, 42);
    }

    public int getCoapMediaType(String mimeType, int defaultCoapContentType) {
        if (mimeType == null) {
            throw new NullPointerException("mime type must not be null!");
        }
        int coapContentType = -1;
        Integer coapType = this.translationMapping.getCoapMediaType(mimeType = mimeType.split(";")[0].trim());
        if (coapType == null) {
            String mimeBaseType = mimeType.split("/")[0].trim();
            coapType = this.translationMapping.getCoapMediaType(mimeBaseType);
        }
        if ((coapContentType = coapType != null ? coapType : MediaTypeRegistry.parse((String)mimeType)) == -1) {
            coapContentType = defaultCoapContentType;
        }
        return coapContentType;
    }

    public List<Option> getCoapOptions(Header[] headers, EtagTranslator etagTranslator) {
        if (headers == null) {
            throw new NullPointerException("http header must not be null!");
        }
        Option accept = null;
        float acceptQualifier = 0.0f;
        LinkedList<Option> optionList = new LinkedList<Option>();
        for (Header header : headers) {
            try {
                Option option;
                Option option2;
                byte[] etag;
                int optionNumber;
                String headerName = header.getName().toLowerCase();
                Integer coapOption = this.translationMapping.getCoapOption(headerName);
                if (coapOption == null || (optionNumber = coapOption.intValue()) == 12) continue;
                String headerValue = header.getValue().trim();
                if (optionNumber == 17) {
                    HeaderElement[] headerElements;
                    ParserCursor cursor = new ParserCursor(0, headerValue.length());
                    for (HeaderElement element : headerElements = this.parser.parseElements((CharSequence)headerValue, cursor)) {
                        float qualifier = 1.0f;
                        String mimeType = element.getName();
                        NameValuePair q = element.getParameterByName("q");
                        if (q != null) {
                            try {
                                qualifier = Float.parseFloat(q.getValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (accept != null && !(acceptQualifier < qualifier)) continue;
                        int coapContentType = -1;
                        String headerFragment = mimeType.trim();
                        if (headerFragment.contains("*")) {
                            int[] coapContentTypes = MediaTypeRegistry.parseWildcard((String)headerFragment);
                            if (coapContentTypes.length > 0) {
                                coapContentType = coapContentTypes[0];
                            }
                        } else {
                            coapContentType = this.getCoapMediaType(headerFragment, -1);
                        }
                        if (coapContentType == -1) continue;
                        accept = new Option(optionNumber, coapContentType);
                        acceptQualifier = qualifier;
                    }
                    continue;
                }
                if (optionNumber == 14) {
                    HeaderElement[] headerElements;
                    int maxAge = -1;
                    ParserCursor cursor = new ParserCursor(0, headerValue.length());
                    for (HeaderElement element : headerElements = this.parser.parseElements((CharSequence)headerValue, cursor)) {
                        if (element.getName().equalsIgnoreCase("no-cache")) {
                            maxAge = 0;
                            break;
                        }
                        if (!element.getName().equalsIgnoreCase("max-age")) continue;
                        String value = element.getValue();
                        try {
                            maxAge = Integer.parseInt(value);
                            break;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Cannot convert cache control '{}' in max-age option", (Object)value, (Object)e);
                        }
                    }
                    if (maxAge < 0) continue;
                    Option option3 = new Option(optionNumber, maxAge);
                    optionList.add(option3);
                    continue;
                }
                if (optionNumber == 4) {
                    etag = etagTranslator.getCoapEtag(headerValue);
                    option2 = new Option(optionNumber, etag);
                    optionList.add(option2);
                    continue;
                }
                if (optionNumber == 1) {
                    etag = etagTranslator.getCoapEtag(headerValue);
                    option2 = new Option(optionNumber, etag);
                    optionList.add(option2);
                    continue;
                }
                if (optionNumber == 5) {
                    if (headerValue.equals("*")) {
                        option = new Option(optionNumber, Bytes.EMPTY);
                        optionList.add(option);
                        continue;
                    }
                    LOGGER.debug("'if-none-match' with etag '{}' is not supported!", (Object)headerValue);
                    continue;
                }
                if (optionNumber == 8) {
                    try {
                        URI uri = new URI(headerValue);
                        OptionSet set = new OptionSet();
                        String value = uri.getPath();
                        if (value != null) {
                            set.setLocationPath(value);
                        }
                        if ((value = uri.getQuery()) != null) {
                            set.setLocationQuery(value);
                        }
                        optionList.addAll(set.asSortedList());
                    }
                    catch (URISyntaxException e) {
                        LOGGER.debug("'content-location' with '{}' is not supported!", (Object)headerValue, (Object)e);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("'content-location' with '{}' is not supported!", (Object)headerValue, (Object)e);
                    }
                    continue;
                }
                option = new Option(optionNumber);
                switch (OptionNumberRegistry.getFormatByNr((int)optionNumber)) {
                    case INTEGER: {
                        option.setIntegerValue(Integer.parseInt(headerValue));
                        break;
                    }
                    case OPAQUE: {
                        option.setValue(headerValue.getBytes(StandardCharsets.ISO_8859_1));
                        break;
                    }
                    case EMPTY: {
                        option.setValue(Bytes.EMPTY);
                        break;
                    }
                    default: {
                        option.setStringValue(headerValue);
                    }
                }
                optionList.add(option);
            }
            catch (RuntimeException e) {
                LOGGER.debug("Could not parse header line {}: {}", (Object)header, (Object)e.getMessage());
            }
        }
        if (accept != null) {
            optionList.add(accept);
        }
        return optionList;
    }

    public void setCoapPayload(ContentTypedEntity httpBody, Message coapMessage) throws TranslationException {
        byte[] payload;
        if (coapMessage == null) {
            throw new NullPointerException("coap message must not be null!");
        }
        if (httpBody != null && (payload = httpBody.getContent()) != null) {
            int end;
            String page;
            int start;
            ContentType contentType = httpBody.getContentType();
            String mimeType = contentType.getMimeType();
            int coapContentType = this.getCoapMediaType(mimeType);
            coapMessage.getOptions().setContentFormat(coapContentType);
            if (MediaTypeRegistry.isCharsetConvertible((int)coapContentType)) {
                try {
                    Charset httpCharset = contentType.getCharset();
                    if (httpCharset != null && !httpCharset.equals(StandardCharsets.UTF_8)) {
                        payload = this.convertCharset(payload, httpCharset, StandardCharsets.UTF_8);
                    }
                }
                catch (UnsupportedCharsetException e) {
                    LOGGER.debug("Cannot get the content of the http entity: " + e.getMessage());
                    throw new TranslationException("Cannot get the content of the http entity", e);
                }
            }
            if (payload.length > 256 && coapMessage instanceof Response && !((Response)coapMessage).isSuccess() && ContentType.TEXT_HTML.getMimeType().equals(mimeType) && (start = (page = new String(payload, StandardCharsets.UTF_8)).indexOf("<body>")) >= 0 && (end = page.indexOf("</body>", start)) >= 0) {
                page = page.substring(start + 6, end);
                payload = page.getBytes(StandardCharsets.UTF_8);
            }
            coapMessage.setPayload(payload);
        }
    }

    public int getHttpCode(CoAP.ResponseCode coapCode) throws TranslationException {
        if (coapCode == null) {
            throw new NullPointerException("coap response code must not be null!");
        }
        Integer httpCode = this.translationMapping.getHttpStatusCode(coapCode);
        if (httpCode == null) {
            LOGGER.debug("http code not defined for {}", (Object)coapCode);
            throw new TranslationException("no httpCode for " + coapCode);
        }
        return httpCode;
    }

    public String getHttpMethod(CoAP.Code coapCode) throws TranslationException {
        if (coapCode == null) {
            throw new NullPointerException("coap request code must not be null!");
        }
        String httpMethods = this.translationMapping.getHttpMethod(coapCode);
        if (httpMethods == null) {
            LOGGER.debug("http method not defined for {}", (Object)coapCode);
            throw new TranslationException("no httpCode for " + coapCode);
        }
        return httpMethods;
    }

    public ContentType getHttpContentType(int coapContentType) throws TranslationException {
        String coapContentTypeString = this.translationMapping.getHttpMimeType(coapContentType);
        if (coapContentTypeString != null && !coapContentTypeString.isEmpty()) {
            try {
                return ContentType.parseLenient((CharSequence)coapContentTypeString);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
        } else {
            MediaTypeRegistry.MediaTypeDefintion definition = MediaTypeRegistry.getDefinition((int)coapContentType);
            if (definition != null) {
                coapContentTypeString = definition.getMime();
                if (definition.isPrintable()) {
                    try {
                        return ContentType.create((String)coapContentTypeString, (String)"UTF-8");
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                    }
                } else {
                    return ContentType.create((String)coapContentTypeString);
                }
            }
        }
        throw new TranslationException("CoAP content type " + coapContentType + " not supported!");
    }

    public Header[] getHttpHeaders(List<Option> optionList, EtagTranslator etagTranslator) {
        if (optionList == null) {
            throw new NullPointerException("coap options must not be null!");
        }
        boolean hasLocation = false;
        LinkedList<BasicHeader> headers = new LinkedList<BasicHeader>();
        for (Option option : optionList) {
            String stringOptionValue;
            String headerName;
            int optionNumber;
            block23: {
                optionNumber = option.getNumber();
                if (optionNumber == 12) continue;
                if (optionNumber == 8 || optionNumber == 20) {
                    hasLocation = true;
                    continue;
                }
                headerName = this.translationMapping.getHttpHeader(optionNumber);
                if (headerName == null || headerName.isEmpty()) continue;
                OptionNumberRegistry.OptionFormat optionFormat = OptionNumberRegistry.getFormatByNr((int)optionNumber);
                stringOptionValue = null;
                if (optionNumber == 4) {
                    stringOptionValue = etagTranslator.getHttpEtag(option.getValue());
                } else if (optionNumber == 1) {
                    stringOptionValue = etagTranslator.getHttpEtag(option.getValue());
                } else if (optionNumber == 5) {
                    stringOptionValue = "*";
                } else {
                    if (optionNumber == 17) {
                        try {
                            stringOptionValue = this.getHttpContentType(option.getIntegerValue()).toString();
                            break block23;
                        }
                        catch (TranslationException e) {
                            continue;
                        }
                    }
                    if (optionFormat == OptionNumberRegistry.OptionFormat.STRING) {
                        stringOptionValue = option.getStringValue();
                    } else if (optionFormat == OptionNumberRegistry.OptionFormat.INTEGER) {
                        stringOptionValue = Integer.toString(option.getIntegerValue());
                    } else if (optionFormat == OptionNumberRegistry.OptionFormat.OPAQUE) {
                        stringOptionValue = new String(option.getValue());
                    } else {
                        if (optionFormat != OptionNumberRegistry.OptionFormat.EMPTY) continue;
                        stringOptionValue = "";
                    }
                }
            }
            if (optionNumber == 14) {
                stringOptionValue = "max-age=" + stringOptionValue;
            }
            BasicHeader header = new BasicHeader(headerName, (Object)stringOptionValue);
            headers.add(header);
        }
        if (hasLocation) {
            StringBuilder locationPath = new StringBuilder();
            StringBuilder locationQuery = new StringBuilder();
            for (Option option : optionList) {
                if (option.getNumber() == 8) {
                    locationPath.append("/").append(option.getStringValue());
                    continue;
                }
                if (option.getNumber() != 20) continue;
                locationQuery.append("&").append(option.getStringValue());
            }
            if (locationQuery.length() > 0) {
                locationQuery.replace(0, 1, "?");
                locationPath.append((CharSequence)locationQuery);
            }
            String headerName = this.translationMapping.getHttpHeader(8);
            BasicHeader header = new BasicHeader(headerName, (Object)locationPath.toString());
            headers.add(header);
        }
        return headers.toArray(new Header[0]);
    }

    public ContentTypedEntity getHttpEntity(Message coapMessage) throws TranslationException {
        if (coapMessage == null) {
            throw new NullPointerException("coap message must not be null!");
        }
        ContentTypedEntity httpEntity = null;
        byte[] payload = coapMessage.getPayload();
        if (payload.length > 0) {
            ContentType contentType = null;
            if (!coapMessage.getOptions().hasContentFormat()) {
                contentType = ContentType.APPLICATION_OCTET_STREAM;
            } else {
                byte[] newPayload;
                Charset charset;
                int coapContentType = coapMessage.getOptions().getContentFormat();
                contentType = this.getHttpContentType(coapContentType);
                if (MediaTypeRegistry.isCharsetConvertible((int)coapContentType) && (charset = contentType.getCharset()) != null && !StandardCharsets.ISO_8859_1.equals(charset) && (newPayload = this.convertCharset(payload, charset, StandardCharsets.ISO_8859_1)) != null) {
                    payload = newPayload;
                    contentType = contentType.withCharset(StandardCharsets.ISO_8859_1);
                }
            }
            httpEntity = new ContentTypedEntity(contentType, payload);
        }
        return httpEntity;
    }

    public Properties getHttpTranslationProperties() {
        return this.translationMapping;
    }

    public byte[] convertCharset(byte[] payload, Charset fromCharset, Charset toCharset) throws TranslationException {
        try {
            CharsetDecoder decoder = fromCharset.newDecoder();
            CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(payload));
            decoder.flush(charBuffer);
            CharsetEncoder encoder = toCharset.newEncoder();
            ByteBuffer byteBuffer = encoder.encode(charBuffer);
            encoder.flush(byteBuffer);
            payload = new byte[byteBuffer.remaining()];
            byteBuffer.get(payload);
        }
        catch (UnmappableCharacterException e) {
            LOGGER.debug("Charset translation: cannot mapped to an output char byte", (Throwable)e);
            return null;
        }
        catch (CharacterCodingException e) {
            LOGGER.warn("Problem in the decoding/encoding charset", (Throwable)e);
            throw new TranslationException("Problem in the decoding/encoding charset", e);
        }
        return payload;
    }

    static {
        LOGGER = LoggerFactory.getLogger(CrossProtocolTranslator.class);
    }

    public static class HttpServerEtagTranslator
    implements EtagTranslator {
        @Override
        public byte[] getCoapEtag(String value) {
            byte[] etag = value.getBytes(StandardCharsets.ISO_8859_1);
            OptionNumberRegistry.assertValueLength((int)4, (int)etag.length);
            return etag;
        }

        @Override
        public String getHttpEtag(byte[] value) {
            return new String(value, StandardCharsets.ISO_8859_1);
        }
    }

    public static class CoapServerEtagTranslator
    implements EtagTranslator {
        @Override
        public byte[] getCoapEtag(String value) {
            byte[] etag = StringUtil.hex2ByteArray((String)value);
            OptionNumberRegistry.assertValueLength((int)4, (int)etag.length);
            return etag;
        }

        @Override
        public String getHttpEtag(byte[] value) {
            return StringUtil.byteArray2Hex((byte[])value);
        }
    }

    public static interface EtagTranslator {
        public byte[] getCoapEtag(String var1);

        public String getHttpEtag(byte[] var1);
    }
}

