/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;

public class ContentTypedEntityConsumer
extends AbstractBinAsyncEntityConsumer<ContentTypedEntity> {
    private final ByteArrayBuffer buffer = new ByteArrayBuffer(1024);
    private ContentType contentType;

    protected void streamStart(ContentType contentType) throws HttpException, IOException {
        this.contentType = contentType;
    }

    protected int capacityIncrement() {
        return Integer.MAX_VALUE;
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
        if (src == null) {
            return;
        }
        if (src.hasArray()) {
            this.buffer.append(src.array(), src.arrayOffset() + src.position(), src.remaining());
        } else {
            while (src.hasRemaining()) {
                this.buffer.append((int)src.get());
            }
        }
    }

    protected ContentTypedEntity generateContent() throws IOException {
        return new ContentTypedEntity(this.contentType, this.buffer.toByteArray());
    }

    public void releaseResources() {
        this.buffer.clear();
    }
}

