/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;

public class ContentTypedEntity {
    private final byte[] payload;
    private final ContentType contentType;

    public ContentTypedEntity(ContentType contentType, byte[] payload) {
        if (contentType == null) {
            throw new NullPointerException("content type must not be null!");
        }
        this.contentType = contentType;
        this.payload = payload != null && payload.length > 0 ? payload : null;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.payload;
    }

    public AsyncEntityProducer createProducer() {
        return AsyncEntityProducers.create((byte[])this.payload, (ContentType)this.contentType);
    }

    public static AsyncEntityProducer createProducer(ContentTypedEntity entity) {
        return entity != null ? entity.createProducer() : null;
    }
}

