/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.config;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.EnumDefinition;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.TimeDefinition;

public final class Proxy2Config {
    public static final String MODULE = "PROXY2.";
    public static final int DEFAULT_HTTP_CONNECTION_IDLE_TIMEOUT_IN_SECONDS = 10;
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT_IN_SECONDS = 10;
    public static final int DEFAULT_HTTPS_HANDSHAKE_TIMEOUT_IN_SECONDS = 10;
    public static final IntegerDefinition HTTP_PORT = new IntegerDefinition("PROXY2.HTTP_PORT", "HTTP server port.", Integer.valueOf(80), Integer.valueOf(1));
    public static final TimeDefinition HTTP_SERVER_SOCKET_TIMEOUT = new TimeDefinition("PROXY2.HTTP_SERVER_SOCKET_TIMEOUT", "HTTP server socket timeout.", 10L, TimeUnit.SECONDS);
    public static final IntegerDefinition HTTP_SERVER_SOCKET_BUFFER_SIZE = new IntegerDefinition("PROXY2.HTTP_SERVER_SOCKET_BUFFER_SIZE", "HTTP server socker buffersize.", Integer.valueOf(8192), Integer.valueOf(2048));
    public static final TimeDefinition CACHE_RESPONSE_MAX_AGE = new TimeDefinition("PROXY2.CACHE_RESPONSE_MAX_AGE", "Maximum age to cache responses.", 1L, TimeUnit.HOURS);
    public static final IntegerDefinition CACHE_SIZE = new IntegerDefinition("PROXY2.CACHE_SIZE", "Size of response cache.", Integer.valueOf(1000), Integer.valueOf(10));
    public static final TimeDefinition HTTP_CONNECTION_IDLE_TIMEOUT = new TimeDefinition("PROXY2.HTTP_CONNECTION_IDLE_TIMEOUT", "HTTP connection idle timeout.", 10L, TimeUnit.SECONDS);
    public static final TimeDefinition HTTP_CONNECT_TIMEOUT = new TimeDefinition("PROXY2.HTTP_CONNECT_TIMEOUT", "HTTP connect timeout", 10L, TimeUnit.SECONDS);
    public static final EnumDefinition<HttpVersion> HTTP_VERSION_POLICY = new EnumDefinition("PROXY2.HTTP_VERSION_POLICY", "HTTP version policy.", (Enum)HttpVersion.NEGOTIATE, (Enum[])HttpVersion.values());
    public static final IntegerDefinition HTTP_WORKER_THREADS = new IntegerDefinition("PROXY2.HTTP_WORKER_THREADS", "HTTP worker threads", Integer.valueOf(1), Integer.valueOf(1));
    public static final TimeDefinition HTTPS_HANDSHAKE_TIMEOUT = new TimeDefinition("PROXY2.HTTPS_HANDSHAKE_TIMEOUT", "HTTPS handshake timeout", 10L, TimeUnit.SECONDS);
    public static final Configuration.ModuleDefinitionsProvider DEFINITIONS = new Configuration.ModuleDefinitionsProvider(){

        public String getModule() {
            return Proxy2Config.MODULE;
        }

        public void applyDefinitions(Configuration config) {
            config.set((BasicDefinition)HTTP_PORT, (Object)8080);
            config.set(HTTP_SERVER_SOCKET_TIMEOUT, 100000, TimeUnit.MILLISECONDS);
            config.set((BasicDefinition)HTTP_SERVER_SOCKET_BUFFER_SIZE, (Object)8192);
            config.set(CACHE_RESPONSE_MAX_AGE, 1, TimeUnit.HOURS);
            config.set((BasicDefinition)CACHE_SIZE, (Object)1000);
            config.set(HTTP_CONNECTION_IDLE_TIMEOUT, 10, TimeUnit.SECONDS);
            config.set((BasicDefinition)HTTP_WORKER_THREADS, (Object)1);
            config.set(HTTP_CONNECT_TIMEOUT, 10, TimeUnit.SECONDS);
            config.set(HTTP_VERSION_POLICY, (Object)HttpVersion.NEGOTIATE);
            config.set(HTTPS_HANDSHAKE_TIMEOUT, 10, TimeUnit.SECONDS);
        }
    };

    public static void register() {
        CoapConfig.register();
    }

    static {
        Configuration.addDefaultModule((Configuration.ModuleDefinitionsProvider)DEFINITIONS);
    }

    public static enum HttpVersion {
        HTTP_1,
        HTTP_2,
        NEGOTIATE;

    }
}

