/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import com.google.common.cache.CacheStats;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.proxy2.resources.CacheResource;

public class StatsResource
extends CoapResource {
    private final Table<String, String, StatHelper> statsTable = HashBasedTable.create();
    private static String CACHE_LOG_NAME = "_cache_log.log";

    public StatsResource(CacheResource cacheResource) {
        super("stats");
        this.getAttributes().setTitle("Keeps track of the requests served by the proxy.");
        this.add(new CacheStatResource("cache", cacheResource));
        this.add(new ProxyStatResource("proxy"));
    }

    public void updateStatistics(URI destination, boolean cachedResponse) {
        String resourceString;
        String addressString = destination.getHost();
        if (addressString != null && (resourceString = destination.getPath()) != null) {
            StatHelper statHelper = (StatHelper)this.statsTable.get((Object)addressString, (Object)resourceString);
            if (statHelper == null) {
                statHelper = new StatHelper();
                this.statsTable.put((Object)addressString, (Object)resourceString, (Object)statHelper);
            }
            statHelper.increment(cachedResponse);
        }
    }

    private String getStatString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Served %d addresses and %d resources\n", this.statsTable.rowKeySet().size(), this.statsTable.cellSet().size()));
        builder.append("\uff3f\n");
        for (String address : this.statsTable.rowKeySet()) {
            builder.append(String.format("|- %s\n", address));
            builder.append("|\t \uff3f\n");
            for (String resource : this.statsTable.row((Object)address).keySet()) {
                builder.append(String.format("|\t |- %s: \n", resource));
                StatHelper statHelper = (StatHelper)this.statsTable.get((Object)address, (Object)resource);
                builder.append(String.format("|\t |------ total requests: %d\n", statHelper.getTotalCount()));
                builder.append(String.format("|\t |------ total cached replies: %d\n", statHelper.getCachedCount()));
                builder.append("|\t |\n");
            }
            builder.append("|\t \uffe3\n");
            builder.append("|\n");
        }
        builder.append("\uffe3\n");
        return builder.length() == 0 ? "The proxy has not received any request, yet." : builder.toString();
    }

    private static class StatHelper {
        private int totalCount = 0;
        private int cachedCount = 0;

        private StatHelper() {
        }

        public int getCachedCount() {
            return this.cachedCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void increment(boolean cachedResponse) {
            ++this.totalCount;
            if (cachedResponse) {
                ++this.cachedCount;
            }
        }
    }

    private final class ProxyStatResource
    extends CoapResource {
        public ProxyStatResource(String resourceIdentifier) {
            super(resourceIdentifier);
        }

        public void handleDELETE(CoapExchange exchange) {
            StatsResource.this.statsTable.clear();
            exchange.respond(CoAP.ResponseCode.DELETED);
        }

        public void handleGET(CoapExchange exchange) {
            String payload = "Available commands:\n - GET: show statistics\n - POST write stats to file\n - DELETE: reset statistics\n\n";
            payload = payload + StatsResource.this.getStatString();
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(payload);
            response.getOptions().setContentFormat(0);
            exchange.respond(response);
        }
    }

    private static final class CacheStatResource
    extends CoapResource {
        private CacheStats relativeCacheStats;
        private final CacheResource cacheResource;
        private static final long DEFAULT_LOGGING_DELAY = 5L;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

        public CacheStatResource(String resourceIdentifier, CacheResource cacheResource) {
            super(resourceIdentifier);
            this.cacheResource = cacheResource;
            this.relativeCacheStats = cacheResource.getCacheStats();
        }

        public String getStats() {
            StringBuilder stringBuilder = new StringBuilder();
            CacheStats cacheStats = this.cacheResource.getCacheStats().minus(this.relativeCacheStats);
            stringBuilder.append(String.format("Total successful loaded values: %d %n", cacheStats.loadSuccessCount()));
            stringBuilder.append(String.format("Total requests: %d %n", cacheStats.requestCount()));
            stringBuilder.append(String.format("Hits ratio: %d/%d - %.3f %n", cacheStats.hitCount(), cacheStats.missCount(), cacheStats.hitRate()));
            stringBuilder.append(String.format("Average time spent loading new values (nanoseconds): %.3f %n", cacheStats.averageLoadPenalty()));
            stringBuilder.append(String.format("Number of cache evictions: %d %n", cacheStats.evictionCount()));
            return stringBuilder.toString();
        }

        public void handleDELETE(CoapExchange exchange) {
            this.relativeCacheStats = this.cacheResource.getCacheStats().minus(this.relativeCacheStats);
            exchange.respond(CoAP.ResponseCode.DELETED);
        }

        public void handleGET(CoapExchange exchange) {
            String payload = "Available commands:\n - GET: show statistics\n - POST write stats to file\n - DELETE: reset statistics\n\n";
            payload = payload + this.getStats();
            Response response = new Response(CoAP.ResponseCode.CONTENT);
            response.setPayload(payload);
            response.getOptions().setContentFormat(0);
            exchange.respond(response);
        }

        public void handlePOST(CoapExchange exchange) {
            String logName = ClockUtil.nanoRealtime() + CACHE_LOG_NAME;
            File cacheLog = new File(logName);
            try {
                cacheLog.createNewFile();
                final CharSink charSink = Files.asCharSink((File)cacheLog, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]);
                charSink.write((CharSequence)"hits%, avg. load, #evictions \n");
                this.executor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        CacheStats cacheStats = CacheStatResource.this.cacheResource.getCacheStats().minus(CacheStatResource.this.relativeCacheStats);
                        String csvStats = String.format("%.3f, %.3f, %d %n", cacheStats.hitRate(), cacheStats.averageLoadPenalty(), cacheStats.evictionCount());
                        try {
                            charSink.write((CharSequence)csvStats);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }, 0L, 5L, TimeUnit.SECONDS);
            }
            catch (IOException charSink) {
                // empty catch block
            }
            Response response = new Response(CoAP.ResponseCode.CREATED);
            response.setPayload("Creted log: " + logName);
            response.getOptions().setContentFormat(0);
            exchange.respond(response);
        }
    }
}

