/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.proxy2.Coap2CoapTranslator;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.InvalidFieldException;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.http.Coap2HttpTranslator;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;
import org.eclipse.californium.proxy2.http.ContentTypedEntityConsumer;
import org.eclipse.californium.proxy2.http.HttpClientFactory;
import org.eclipse.californium.proxy2.http.ProxyRequestProducer;
import org.eclipse.californium.proxy2.resources.CacheKey;
import org.eclipse.californium.proxy2.resources.CacheResource;
import org.eclipse.californium.proxy2.resources.ProxyCoapResource;
import org.eclipse.californium.proxy2.resources.StatsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHttpClientResource
extends ProxyCoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyHttpClientResource.class);
    private final Coap2HttpTranslator translator;
    private final Set<String> schemes = new HashSet<String>();
    private static final CloseableHttpAsyncClient asyncClient = HttpClientFactory.createClient();

    public ProxyHttpClientResource(String name, boolean visible, boolean accept, Coap2HttpTranslator translator, String ... schemes) {
        super(name, visible, accept);
        this.getAttributes().setTitle("Forward the requests to a HTTP client.");
        Coap2HttpTranslator coap2HttpTranslator = this.translator = translator != null ? translator : new Coap2HttpTranslator();
        if (schemes == null || schemes.length == 0) {
            this.schemes.add("http");
        } else {
            for (String scheme : schemes) {
                this.schemes.add(scheme);
            }
        }
    }

    @Override
    public void handleRequest(final Exchange exchange) {
        CacheKey cacheKey;
        URI destination;
        final Request incomingCoapRequest = exchange.getRequest();
        try {
            InetSocketAddress exposedInterface = this.translator.getExposedInterface(incomingCoapRequest);
            destination = this.translator.getDestinationURI(incomingCoapRequest, exposedInterface);
        }
        catch (TranslationException ex) {
            LOGGER.debug("URI error.", (Throwable)ex);
            Response response = new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED);
            response.setPayload(ex.getMessage());
            exchange.sendResponse(response);
            return;
        }
        final CacheResource cache = this.getCache();
        if (cache != null) {
            cacheKey = new CacheKey(incomingCoapRequest.getCode(), destination, incomingCoapRequest.getOptions().getAccept(), incomingCoapRequest.getPayload());
            Response response = cache.getResponse(cacheKey);
            StatsResource statsResource = this.getStatsResource();
            if (statsResource != null) {
                statsResource.updateStatistics(destination, response != null);
            }
            if (response != null) {
                LOGGER.info("Cache returned {}", (Object)response);
                exchange.sendResponse(response);
                return;
            }
        } else {
            cacheKey = null;
        }
        ProxyRequestProducer httpRequest = null;
        try {
            httpRequest = this.translator.getHttpRequest(destination, incomingCoapRequest);
            LOGGER.debug("Outgoing http request: {}", (Object)httpRequest.getRequestLine());
        }
        catch (InvalidFieldException e) {
            LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
            exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
            return;
        }
        catch (TranslationException e) {
            LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
            exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_TRANSLATION_ERROR));
            return;
        }
        if (this.accept) {
            exchange.sendAccept();
        }
        asyncClient.execute((AsyncRequestProducer)httpRequest, (AsyncResponseConsumer)new BasicResponseConsumer((AsyncEntityConsumer)new ContentTypedEntityConsumer()), (HttpContext)new BasicHttpContext(), (FutureCallback)new FutureCallback<Message<HttpResponse, ContentTypedEntity>>(){

            public void completed(Message<HttpResponse, ContentTypedEntity> result) {
                StatusLine status = new StatusLine((HttpResponse)result.getHead());
                try {
                    long timestamp = ClockUtil.nanoRealtime();
                    LOGGER.debug("Incoming http response: {}", (Object)status);
                    Response coapResponse = ProxyHttpClientResource.this.translator.getCoapResponse(result, incomingCoapRequest);
                    coapResponse.setNanoTimestamp(timestamp);
                    if (cache != null) {
                        cache.cacheResponse(cacheKey, coapResponse);
                    }
                    exchange.sendResponse(coapResponse);
                }
                catch (InvalidFieldException e) {
                    LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
                    exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
                }
                catch (TranslationException e) {
                    LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
                    exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_TRANSLATION_ERROR));
                }
                catch (Throwable e) {
                    LOGGER.debug("Error during the http/coap translation: {}", (Object)e.getMessage(), (Object)e);
                    exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
                }
                LOGGER.debug("Incoming http response: {} processed!", (Object)status);
            }

            public void failed(Exception ex) {
                LOGGER.debug("Failed to get the http response: {}", (Object)ex.getMessage(), (Object)ex);
                if (ex instanceof SocketTimeoutException) {
                    exchange.sendResponse(new Response(CoAP.ResponseCode.GATEWAY_TIMEOUT));
                } else {
                    exchange.sendResponse(new Response(CoAP.ResponseCode.BAD_GATEWAY));
                }
            }

            public void cancelled() {
                LOGGER.debug("Request canceled");
                exchange.sendResponse(new Response(CoAP.ResponseCode.SERVICE_UNAVAILABLE));
            }
        });
    }

    @Override
    public CoapUriTranslator getUriTranslater() {
        return this.translator;
    }

    @Override
    public Set<String> getDestinationSchemes() {
        return Collections.unmodifiableSet(this.schemes);
    }
}

