/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.proxy2.config.Proxy2Config;
import org.eclipse.californium.proxy2.http.Http2CoapTranslator;
import org.eclipse.californium.proxy2.http.server.HttpStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyHttpServer.class);
    private final HttpStack httpStack;
    private final MessageDeliverer proxyCoapDeliverer;
    private final MessageDeliverer localCoapDeliverer;

    private ProxyHttpServer(Configuration config, Executor executor, InetSocketAddress bind, Http2CoapTranslator translator, MessageDeliverer proxyCoapDeliverer, MessageDeliverer localCoapDeliverer) throws IOException {
        this.proxyCoapDeliverer = proxyCoapDeliverer;
        this.localCoapDeliverer = localCoapDeliverer;
        this.httpStack = new HttpStack(config, executor, bind, translator, new MessageDeliverer(){

            public void deliverRequest(Exchange exchange) {
                ProxyHttpServer.this.handleRequest(exchange);
            }

            public void deliverResponse(Exchange exchange, Response response) {
            }
        });
        if (proxyCoapDeliverer != null) {
            this.httpStack.registerProxyRequestHandler();
            this.httpStack.registerHttpProxyRequestHandler();
        }
        if (localCoapDeliverer != null) {
            this.httpStack.registerLocalRequestHandler();
        }
        this.httpStack.registerDefaultHandler();
    }

    public InetSocketAddress getInterface() {
        return this.httpStack.getInterface();
    }

    public void start() {
        this.httpStack.start();
    }

    public void stop() {
        this.httpStack.stop();
    }

    public void handleRequest(Exchange exchange) {
        Request request = exchange.getRequest();
        LOGGER.info("ProxyEndpoint handles request {}", (Object)request);
        if (request.getOptions().hasProxyUri()) {
            if (this.proxyCoapDeliverer != null) {
                this.proxyCoapDeliverer.deliverRequest(exchange);
            } else {
                exchange.sendResponse(new Response(CoAP.ResponseCode.PROXY_NOT_SUPPORTED));
            }
        } else if (this.localCoapDeliverer != null) {
            this.localCoapDeliverer.deliverRequest(exchange);
        } else {
            exchange.sendResponse(new Response(CoAP.ResponseCode.PROXY_NOT_SUPPORTED));
        }
    }

    public static Builder buider() {
        return new Builder();
    }

    public static class Builder {
        private Configuration config;
        private InetSocketAddress bindAddress;
        private Executor executor;
        private MessageDeliverer proxyCoapDeliverer;
        private MessageDeliverer localCoapDeliverer;
        private Http2CoapTranslator translator;

        public Builder setConfiguration(Configuration config) {
            this.config = config;
            return this;
        }

        public Builder setPort(int port) {
            if (this.bindAddress != null) {
                throw new IllegalStateException("bind address already defined!");
            }
            this.bindAddress = new InetSocketAddress(port);
            return this;
        }

        public Builder setInetSocketAddress(InetSocketAddress address) {
            if (this.bindAddress != null) {
                throw new IllegalStateException("bind address already defined!");
            }
            this.bindAddress = address;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setHttpTranslator(Http2CoapTranslator translator) {
            this.translator = translator;
            return this;
        }

        public Builder setProxyCoapDeliverer(MessageDeliverer deliverer) {
            this.proxyCoapDeliverer = deliverer;
            return this;
        }

        public Builder setLocalCoapDeliverer(MessageDeliverer deliverer) {
            this.localCoapDeliverer = deliverer;
            return this;
        }

        public ProxyHttpServer build() throws IOException {
            if (this.executor == null) {
                throw new IllegalStateException("Executor missing!");
            }
            if (this.proxyCoapDeliverer == null && this.localCoapDeliverer == null) {
                throw new IllegalStateException("At least one coap-deliver must be provided!");
            }
            if (this.config == null) {
                this.config = Configuration.getStandard();
            }
            if (this.bindAddress == null) {
                this.bindAddress = new InetSocketAddress((Integer)this.config.get((BasicDefinition)Proxy2Config.HTTP_PORT));
            }
            if (this.translator == null) {
                this.translator = new Http2CoapTranslator();
            }
            return new ProxyHttpServer(this.config, this.executor, this.bindAddress, this.translator, this.proxyCoapDeliverer, this.localCoapDeliverer);
        }
    }
}

