/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.proxy2.InvalidMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingProperties
extends Properties {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingProperties.class);
    private static final long serialVersionUID = 4126898261482584755L;
    private static final String HEADER = "Californium Cross-Proxy2 mapping properties file";
    protected static final String KEY_COAP_METHOD = "coap.request.code.";
    protected static final String KEY_COAP_CODE = "coap.response.code.";
    protected static final String KEY_COAP_OPTION = "coap.message.option.";
    protected static final String KEY_COAP_MEDIA = "coap.message.media.";
    protected static final String KEY_HTTP_CODE = "http.response.code.";
    protected static final String KEY_HTTP_METHOD = "http.request.method.";
    protected static final String KEY_HTTP_HEADER = "http.message.header.";
    protected static final String KEY_HTTP_CONTENT_TYPE = "http.message.content-type.";
    protected final AtomicBoolean initialized = new AtomicBoolean();
    protected final Map<String, Object> httpMethods = new ConcurrentHashMap<String, Object>();
    protected final Map<CoAP.Code, String> coapCodes = new ConcurrentHashMap<CoAP.Code, String>();
    protected final Map<Integer, CoAP.ResponseCode> httpStatusCodes = new ConcurrentHashMap<Integer, CoAP.ResponseCode>();
    protected final Map<CoAP.ResponseCode, Integer> coapResponseCodes = new ConcurrentHashMap<CoAP.ResponseCode, Integer>();
    protected final Map<String, Integer> httpMediaTypes = new ConcurrentHashMap<String, Integer>();
    protected final Map<Integer, String> coapMediaTypes = new ConcurrentHashMap<Integer, String>();
    protected final Map<String, Integer> httpHeaders = new ConcurrentHashMap<String, Integer>();
    protected final Map<Integer, String> coapOptions = new ConcurrentHashMap<Integer, String>();

    public MappingProperties() {
        this.init();
        this.initMaps();
    }

    public MappingProperties(String fileName) {
        this.init();
        this.initUserDefined(fileName);
        this.initMaps();
    }

    protected void clearMaps() {
        this.httpMethods.clear();
        this.coapCodes.clear();
        this.httpStatusCodes.clear();
        this.coapResponseCodes.clear();
        this.httpMediaTypes.clear();
        this.coapMediaTypes.clear();
        this.httpHeaders.clear();
        this.coapOptions.clear();
    }

    protected void initMaps() {
        for (String key : this.stringPropertyNames()) {
            this.initMaps(key);
        }
        this.initialized.set(true);
    }

    protected void initMaps(String key) {
        if (key.startsWith(KEY_COAP_CODE)) {
            this.initResponseCode(key);
        } else if (key.startsWith(KEY_HTTP_CODE)) {
            this.initHttpCode(key);
        } else if (key.startsWith(KEY_HTTP_METHOD)) {
            this.initHttpMethod(key);
        } else if (key.startsWith(KEY_COAP_METHOD)) {
            this.initCoapMethod(key);
        } else if (key.startsWith(KEY_COAP_MEDIA)) {
            this.initCoapMediaType(key);
        } else if (key.startsWith(KEY_HTTP_CONTENT_TYPE)) {
            this.initHttpMediaType(key);
        } else if (key.startsWith(KEY_COAP_OPTION)) {
            this.initCoapOption(key);
        } else if (key.startsWith(KEY_HTTP_HEADER)) {
            this.initHttpHeader(key);
        }
    }

    protected void initResponseCode(String key) {
        Integer httpCode = this.getInteger(key);
        CoAP.ResponseCode code = CoAP.ResponseCode.valueOfText((String)this.getTag(KEY_COAP_CODE, key));
        if (httpCode != null && code != null) {
            this.coapResponseCodes.put(code, httpCode);
        }
    }

    protected void initHttpCode(String key) {
        CoAP.ResponseCode code = CoAP.ResponseCode.valueOfText((String)this.getString(key));
        Integer httpCode = this.getIntegerTag(KEY_HTTP_CODE, key);
        if (httpCode != null && code != null) {
            this.httpStatusCodes.put(httpCode, code);
        }
    }

    protected void initHttpMethod(String key) {
        String tag = this.getTag(KEY_HTTP_METHOD, key);
        String coapCode = this.getString(key);
        CoAP.Code code = CoAP.Code.valueOfText((String)coapCode);
        if (code == null) {
            code = CoAP.ResponseCode.valueOfText((String)coapCode);
        }
        if (code != null) {
            this.httpMethods.put(tag.toLowerCase(), code);
        }
    }

    protected void initCoapMethod(String key) {
        String httpMethod = this.getString(key);
        String tag = this.getTag(KEY_COAP_METHOD, key);
        CoAP.Code code = CoAP.Code.valueOfText((String)tag);
        if (code != null && httpMethod != null) {
            this.coapCodes.put(code, httpMethod);
        }
    }

    protected void initCoapMediaType(String key) {
        String httpMediaType = this.getString(key);
        Integer coapMediaType = this.getIntegerTag(KEY_COAP_MEDIA, key);
        if (coapMediaType != null && httpMediaType != null) {
            this.coapMediaTypes.put(coapMediaType, httpMediaType);
        }
    }

    protected void initHttpMediaType(String key) {
        Integer coapMediaType = this.getInteger(key);
        if (coapMediaType != null) {
            this.httpMediaTypes.put(this.getTag(KEY_HTTP_CONTENT_TYPE, key).toLowerCase(), coapMediaType);
        }
    }

    protected void initCoapOption(String key) {
        String httpHeader = this.getString(key);
        Integer coapOption = this.getIntegerTag(KEY_COAP_OPTION, key);
        if (coapOption != null && httpHeader != null) {
            this.coapOptions.put(coapOption, httpHeader);
        }
    }

    protected void initHttpHeader(String key) {
        Integer coapOption = this.getInteger(key);
        if (coapOption != null) {
            this.httpHeaders.put(this.getTag(KEY_HTTP_HEADER, key), coapOption);
        }
    }

    protected String getTag(String prefix, String key) {
        if (key.startsWith(prefix)) {
            String tag = key.substring(prefix.length()).trim();
            if (tag.isEmpty()) {
                throw new IllegalArgumentException("key '" + key + "' has only prefix '" + prefix + "'!");
            }
            return tag;
        }
        throw new IllegalArgumentException("key '" + key + "' has not prefix '" + prefix + "'!");
    }

    protected Integer getIntegerTag(String prefix, String key) {
        return Integer.valueOf(this.getTag(prefix, key), 10);
    }

    public CoAP.Code getCoapCode(String httpMethod) throws InvalidMethodException {
        if (httpMethod == null) {
            throw new NullPointerException("http method must not be null!");
        }
        Object code = this.httpMethods.get(httpMethod.toLowerCase());
        if (code instanceof CoAP.Code) {
            return (CoAP.Code)code;
        }
        if (code instanceof CoAP.ResponseCode) {
            throw new InvalidMethodException((CoAP.ResponseCode)code);
        }
        throw new InvalidMethodException(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
    }

    public String getHttpMethod(CoAP.Code code) {
        return this.coapCodes.get(code);
    }

    public Integer getHttpStatusCode(CoAP.ResponseCode code) {
        return this.coapResponseCodes.get(code);
    }

    public CoAP.ResponseCode getCoapResponseCode(CoAP.Code coapMethod, int httpStatusCode) {
        if (coapMethod == null) {
            throw new NullPointerException("coap method must not be null!");
        }
        if (httpStatusCode == 204) {
            httpStatusCode += 10000 * coapMethod.value;
        }
        return this.httpStatusCodes.get(httpStatusCode);
    }

    public Integer getCoapMediaType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mime type must not be null!");
        }
        return this.httpMediaTypes.get(mimeType.toLowerCase());
    }

    public String getHttpMimeType(Integer coapMediaType) {
        return this.coapMediaTypes.get(coapMediaType);
    }

    public Integer getCoapOption(String httpHeader) {
        return this.httpHeaders.get(httpHeader);
    }

    public String getHttpHeader(Integer coapOption) {
        return this.coapOptions.get(coapOption);
    }

    protected Integer getInteger(String key) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error(String.format("Invalid integer property: %s=%s", key, value));
            }
        }
        return null;
    }

    protected String getString(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            LOGGER.error("Undefined string property: {}", (Object)key);
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            LOGGER.error("Empty string property: {}", (Object)key);
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String fileName) throws IOException {
        try (FileInputStream in = new FileInputStream(fileName);){
            this.load(in);
        }
        if (this.initialized.get()) {
            this.initMaps();
        }
    }

    protected void set(String key, int value) {
        this.setProperty(key, String.valueOf(value));
        if (this.initialized.get()) {
            this.initMaps(key);
        }
    }

    protected void set(String key, String value) {
        this.setProperty(key, value);
        if (this.initialized.get()) {
            this.initMaps(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(String fileName) throws IOException {
        try (FileOutputStream out = new FileOutputStream(fileName);){
            this.store(out, HEADER);
        }
    }

    protected void initUserDefined(String fileName) {
        try {
            this.load(fileName);
        }
        catch (IOException e) {
            try {
                this.store(fileName);
            }
            catch (IOException e1) {
                LOGGER.warn(String.format("Failed to create configuration file: %s", e1.getMessage()));
            }
        }
    }

    protected void init() {
        this.set("http.request.method.options", "5.01");
        this.set("http.request.method.trace", "5.01");
        this.set("http.request.method.connect", "5.01");
        this.set("http.request.method.head", "0.01");
        this.set("http.request.method.get", "0.01");
        this.set("http.request.method.post", "0.02");
        this.set("http.request.method.put", "0.03");
        this.set("http.request.method.delete", "0.04");
        this.set("http.response.code.100", "5.02");
        this.set("http.response.code.101", "5.02");
        this.set("http.response.code.102", "5.02");
        this.set("http.response.code.200", "2.05");
        this.set("http.response.code.201", "2.01");
        this.set("http.response.code.202", "2.05");
        this.set("http.response.code.203", "2.05");
        this.set("http.response.code.20204", "2.04");
        this.set("http.response.code.30204", "2.04");
        this.set("http.response.code.40204", "2.02");
        this.set("http.response.code.205", "2.05");
        this.set("http.response.code.206", "2.05");
        this.set("http.response.code.207", "2.05");
        this.set("http.response.code.300", "5.02");
        this.set("http.response.code.301", "5.02");
        this.set("http.response.code.302", "5.02");
        this.set("http.response.code.303", "5.02");
        this.set("http.response.code.304", "2.03");
        this.set("http.response.code.305", "5.02");
        this.set("http.response.code.307", "5.02");
        this.set("http.response.code.400", "4.00");
        this.set("http.response.code.401", "4.01");
        this.set("http.response.code.402", "4.00");
        this.set("http.response.code.403", "4.03");
        this.set("http.response.code.404", "4.04");
        this.set("http.response.code.405", "4.05");
        this.set("http.response.code.406", "4.06");
        this.set("http.response.code.407", "4.00");
        this.set("http.response.code.408", "4.00");
        this.set("http.response.code.409", "4.00");
        this.set("http.response.code.410", "4.00");
        this.set("http.response.code.411", "4.00");
        this.set("http.response.code.412", "4.12");
        this.set("http.response.code.413", "4.13");
        this.set("http.response.code.414", "4.00");
        this.set("http.response.code.415", "4.15");
        this.set("http.response.code.416", "4.00");
        this.set("http.response.code.417", "4.00");
        this.set("http.response.code.418", "4.00");
        this.set("http.response.code.419", "4.00");
        this.set("http.response.code.420", "4.00");
        this.set("http.response.code.422", "4.00");
        this.set("http.response.code.423", "4.00");
        this.set("http.response.code.424", "4.00");
        this.set("http.response.code.500", "5.00");
        this.set("http.response.code.501", "5.01");
        this.set("http.response.code.502", "5.02");
        this.set("http.response.code.503", "5.03");
        this.set("http.response.code.504", "5.04");
        this.set("http.response.code.505", "5.02");
        this.set("http.response.code.507", "5.00");
        this.set("coap.request.code.0.01", "GET");
        this.set("coap.request.code.0.02", "POST");
        this.set("coap.request.code.0.03", "PUT");
        this.set("coap.request.code.0.04", "DELETE");
        this.set("coap.response.code.2.01", 201);
        this.set("coap.response.code.2.02", 204);
        this.set("coap.response.code.2.03", 304);
        this.set("coap.response.code.2.04", 204);
        this.set("coap.response.code.2.05", 200);
        this.set("coap.response.code.4.00", 400);
        this.set("coap.response.code.4.01", 401);
        this.set("coap.response.code.4.02", 400);
        this.set("coap.response.code.4.03", 403);
        this.set("coap.response.code.4.04", 404);
        this.set("coap.response.code.4.05", 405);
        this.set("coap.response.code.4.06", 406);
        this.set("coap.response.code.4.09", 409);
        this.set("coap.response.code.4.12", 412);
        this.set("coap.response.code.4.13", 413);
        this.set("coap.response.code.4.15", 415);
        this.set("coap.response.code.4.29", 429);
        this.set("coap.response.code.5.00", 500);
        this.set("coap.response.code.5.01", 501);
        this.set("coap.response.code.5.02", 502);
        this.set("coap.response.code.5.03", 503);
        this.set("coap.response.code.5.04", 504);
        this.set("coap.response.code.5.05", 502);
        this.set("http.message.header.content-type", 12);
        this.set("http.message.header.content-location", 8);
        this.set("http.message.header.accept", 17);
        this.set("http.message.header.if-match", 1);
        this.set("http.message.header.if-none-match", 5);
        this.set("http.message.header.etag", 4);
        this.set("http.message.header.cache-control", 14);
        this.set("coap.message.option.12", "Content-Type");
        this.set("coap.message.option.14", "Cache-Control");
        this.set("coap.message.option.4", "Etag");
        this.set("coap.message.option.8", "Content-Location");
        this.set("coap.message.option.20", "Content-Location");
        this.set("coap.message.option.17", "Accept");
        this.set("coap.message.option.1", "If-Match");
        this.set("coap.message.option.5", "If-None-Match");
        this.set("http.message.content-type.text/plain", 0);
        this.set("http.message.content-type.application/link-format", 40);
        this.set("http.message.content-type.application/xml", 41);
        this.set("http.message.content-type.application/json", 50);
        this.set("coap.message.media.0", "text/plain; charset=UTF-8");
        this.set("coap.message.media.40", "application/link-format");
        this.set("coap.message.media.41", "application/xml");
        this.set("coap.message.media.50", "application/json; charset=UTF-8");
        if (this.initialized.get()) {
            this.initMaps();
        }
    }
}

