/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestDate;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.proxy2.config.Proxy2Config;

public class HttpClientFactory {
    private static final TimeValue KEEP_ALIVE = TimeValue.ofSeconds((long)5L);
    private static AtomicReference<Configuration> config = new AtomicReference();

    private HttpClientFactory() {
    }

    public static Configuration setNetworkConfig(Configuration config) {
        return HttpClientFactory.config.getAndSet(config);
    }

    public static Configuration getNetworkConfig() {
        Configuration config = HttpClientFactory.config.get();
        if (config == null) {
            HttpClientFactory.config.compareAndSet(null, Configuration.getStandard());
            config = HttpClientFactory.config.get();
        }
        return config;
    }

    public static CloseableHttpAsyncClient createClient() {
        return HttpClientFactory.createClient(HttpClientFactory.getNetworkConfig());
    }

    public static CloseableHttpAsyncClient createClient(Configuration config) {
        int connectionIdleSecs = config.getTimeAsInt(Proxy2Config.HTTP_CONNECTION_IDLE_TIMEOUT, TimeUnit.SECONDS);
        CloseableHttpAsyncClient client = HttpAsyncClientBuilder.create().disableCookieManagement().setDefaultRequestConfig(HttpClientFactory.createCustomRequestConfig(config)).setConnectionManager((AsyncClientConnectionManager)HttpClientFactory.createPoolingConnManager(config)).setVersionPolicy(HttpVersionPolicy.NEGOTIATE).setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)connectionIdleSecs)).build()).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestConnControl()).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestDate()).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestExpectContinue()).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestTargetHost()).addRequestInterceptorFirst((HttpRequestInterceptor)new RequestUserAgent()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
                TimeValue keepAlive = super.getKeepAliveDuration(response, context);
                if (keepAlive == null || keepAlive.getDuration() < 0L) {
                    keepAlive = KEEP_ALIVE;
                }
                return keepAlive;
            }
        }).build();
        client.start();
        return client;
    }

    private static RequestConfig createCustomRequestConfig(Configuration config) {
        long connecTimeoutMillis = config.get(Proxy2Config.HTTP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        return RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds((long)(connecTimeoutMillis * 4L))).setConnectTimeout(Timeout.ofMilliseconds((long)connecTimeoutMillis)).build();
    }

    private static PoolingAsyncClientConnectionManager createPoolingConnManager(Configuration config) {
        long connectionIdleSecs = config.get(Proxy2Config.HTTP_CONNECTION_IDLE_TIMEOUT, TimeUnit.MILLISECONDS);
        return PoolingAsyncClientConnectionManagerBuilder.create().setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setConnectionTimeToLive(TimeValue.ofSeconds((long)connectionIdleSecs)).setMaxConnTotal(250).setMaxConnPerRoute(50).build();
    }
}

