/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.net.URI;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;
import org.eclipse.californium.proxy2.http.CrossProtocolTranslator;
import org.eclipse.californium.proxy2.http.ProxyRequestProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coap2HttpTranslator
extends CoapUriTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Coap2HttpTranslator.class);
    protected final CrossProtocolTranslator httpTranslator;
    protected final CrossProtocolTranslator.EtagTranslator etagTranslator;

    public Coap2HttpTranslator(String mappingPropertiesFileName) {
        this(new CrossProtocolTranslator(mappingPropertiesFileName), new CrossProtocolTranslator.HttpServerEtagTranslator());
    }

    public Coap2HttpTranslator() {
        this(new CrossProtocolTranslator(), new CrossProtocolTranslator.HttpServerEtagTranslator());
    }

    public Coap2HttpTranslator(CrossProtocolTranslator httpTranslator, CrossProtocolTranslator.EtagTranslator etagTranslator) {
        if (httpTranslator == null) {
            throw new NullPointerException("http-translator must not be null!");
        }
        if (etagTranslator == null) {
            throw new NullPointerException("etag-translator must not be null!");
        }
        this.httpTranslator = httpTranslator;
        this.etagTranslator = etagTranslator;
    }

    public ProxyRequestProducer getHttpRequest(URI uri, Request coapRequest) throws TranslationException {
        Header[] headers;
        if (uri == null) {
            throw new NullPointerException("URI must not be null!");
        }
        if (coapRequest == null) {
            throw new NullPointerException("Coap-request must not be null!");
        }
        String coapMethod = this.httpTranslator.getHttpMethod(coapRequest.getCode());
        BasicHttpRequest httpRequest = new BasicHttpRequest(coapMethod, uri);
        ContentTypedEntity httpEntity = this.httpTranslator.getHttpEntity((org.eclipse.californium.core.coap.Message)coapRequest);
        for (Header header : headers = this.httpTranslator.getHttpHeaders(coapRequest.getOptions().asSortedList(), this.etagTranslator)) {
            httpRequest.addHeader(header);
        }
        LOGGER.debug("Incoming request translated correctly");
        return new ProxyRequestProducer((HttpRequest)httpRequest, ContentTypedEntity.createProducer(httpEntity));
    }

    public Response getCoapResponse(Message<HttpResponse, ContentTypedEntity> httpResponse, Request coapRequest) throws TranslationException {
        if (httpResponse == null) {
            throw new NullPointerException("Http-response must not be null!");
        }
        if (coapRequest == null) {
            throw new NullPointerException("Coap-request must not be null!");
        }
        int httpCode = ((HttpResponse)httpResponse.getHead()).getCode();
        CoAP.Code coapMethod = coapRequest.getCode();
        CoAP.ResponseCode coapCode = this.httpTranslator.getCoapResponseCode(coapMethod, httpCode);
        Response coapResponse = new Response(coapCode);
        List<Option> coapOptions = this.httpTranslator.getCoapOptions(((HttpResponse)httpResponse.getHead()).getHeaders(), this.etagTranslator);
        coapResponse.getOptions().addOptions(coapOptions);
        if (!coapResponse.getOptions().hasMaxAge()) {
            if (coapMethod == CoAP.Code.GET) {
                coapResponse.getOptions().setMaxAge(60L);
            } else {
                coapResponse.getOptions().setMaxAge(0L);
            }
        }
        ContentTypedEntity entity = (ContentTypedEntity)httpResponse.getBody();
        this.httpTranslator.setCoapPayload(entity, (org.eclipse.californium.core.coap.Message)coapResponse);
        LOGGER.debug("Incoming response translated correctly");
        return coapResponse;
    }
}

