/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.proxy2.ClientEndpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointPool
implements ClientEndpoints {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointPool.class);
    protected final int size;
    protected final Configuration config;
    protected final Queue<Endpoint> pool;
    protected final ScheduledExecutorService mainExecutor;
    protected final ScheduledExecutorService secondaryExecutor;
    protected String scheme;

    public EndpointPool(int size, int init, Configuration config, ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor) {
        this(size, config, mainExecutor, secondaryExecutor);
        this.scheme = this.init(init);
    }

    protected EndpointPool(int size, Configuration config, ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor) {
        this.size = size;
        this.pool = new ArrayBlockingQueue<Endpoint>(size);
        this.config = config;
        this.mainExecutor = mainExecutor;
        this.secondaryExecutor = secondaryExecutor;
    }

    protected String init(int init) {
        if (init > this.size) {
            init = this.size;
        }
        String scheme = null;
        try {
            Endpoint endpoint = this.createEndpoint();
            scheme = endpoint.getUri().getScheme();
            this.release(endpoint);
            for (int i = 1; i < init; ++i) {
                this.release(this.createEndpoint());
            }
        }
        catch (IOException ex) {
            LOGGER.warn("endpoint pool could not be filled!", (Throwable)ex);
        }
        return scheme;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void sendRequest(Request outgoingRequest) throws IOException {
        Endpoint endpoint = this.getEndpoint();
        outgoingRequest.addMessageObserver((MessageObserver)new PoolMessageObserver(endpoint));
        endpoint.sendRequest(outgoingRequest);
    }

    protected Endpoint getEndpoint() throws IOException {
        Endpoint endpoint = this.pool.poll();
        if (endpoint == null) {
            LOGGER.warn("Out of endpoints, creating more");
            endpoint = this.createEndpoint();
        }
        return endpoint;
    }

    protected Endpoint createEndpoint() throws IOException {
        CoapEndpoint endpoint = new CoapEndpoint.Builder().setConfiguration(this.config).build();
        endpoint.setExecutors(this.mainExecutor, this.secondaryExecutor);
        try {
            endpoint.start();
            return endpoint;
        }
        catch (IOException e) {
            endpoint.destroy();
            throw e;
        }
    }

    protected void release(Endpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        if (this.isFull() || !this.pool.offer(endpoint)) {
            endpoint.destroy();
        }
    }

    protected boolean isFull() {
        return this.pool.size() >= this.size;
    }

    @Override
    public void destroy() {
        Endpoint endpoint;
        while ((endpoint = this.pool.poll()) != null) {
            endpoint.destroy();
        }
    }

    private class PoolMessageObserver
    extends MessageObserverAdapter {
        private final Endpoint outgoingEndpoint;

        private PoolMessageObserver(Endpoint outgoingEndpoint) {
            this.outgoingEndpoint = outgoingEndpoint;
        }

        public void onResponse(Response incomingResponse) {
            EndpointPool.this.release(this.outgoingEndpoint);
        }

        public void onCancel() {
            EndpointPool.this.release(this.outgoingEndpoint);
        }

        protected void failed() {
            EndpointPool.this.release(this.outgoingEndpoint);
        }
    }
}

