/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.proxy2.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapUriTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapUriTranslator.class);
    public static final CoAP.ResponseCode STATUS_FIELD_MALFORMED = CoAP.ResponseCode.BAD_OPTION;
    public static final CoAP.ResponseCode STATUS_TIMEOUT = CoAP.ResponseCode.GATEWAY_TIMEOUT;
    public static final CoAP.ResponseCode STATUS_TRANSLATION_ERROR = CoAP.ResponseCode.BAD_GATEWAY;

    public String getDestinationScheme(Request incomingRequest) throws TranslationException {
        if (incomingRequest == null) {
            throw new NullPointerException("incomingRequest == null");
        }
        OptionSet options = incomingRequest.getOptions();
        if (options.hasProxyUri()) {
            try {
                return new URI(options.getProxyUri()).getScheme();
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Cannot translate the server uri", (Throwable)e);
                throw new TranslationException("Cannot translate the server uri", e);
            }
        }
        if (options.hasProxyScheme()) {
            return options.getProxyScheme();
        }
        return incomingRequest.getScheme();
    }

    public InetSocketAddress getExposedInterface(Request incomingRequest) {
        InetSocketAddress incoming = incomingRequest.getLocalAddress();
        if (incoming != null && incoming.getAddress().isAnyLocalAddress()) {
            return null;
        }
        return incoming;
    }

    public URI getDestinationURI(Request incomingRequest, InetSocketAddress exposed) throws TranslationException {
        if (incomingRequest == null) {
            throw new NullPointerException("incomingRequest == null");
        }
        try {
            Integer port;
            OptionSet options = incomingRequest.getOptions();
            if (options.hasProxyUri()) {
                return new URI(options.getProxyUri());
            }
            String scheme = options.hasProxyScheme() ? options.getProxyScheme() : incomingRequest.getScheme();
            String host = options.getUriHost();
            if (host == null) {
                if (exposed == null) {
                    throw new TranslationException("Destination host missing! Neither the Uri-Host nor the exposed interface is available!");
                }
                host = StringUtil.getUriHostname((InetAddress)exposed.getAddress());
            }
            if ((port = options.getUriPort()) == null) {
                if (exposed == null) {
                    throw new TranslationException("Destination port missing!");
                }
                port = exposed.getPort();
            }
            String path = "/" + options.getUriPathString();
            String query = options.getURIQueryCount() > 0 ? options.getUriQueryString() : null;
            return new URI(scheme, null, host, port, path, query, null);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Cannot translate the server uri", (Throwable)e);
            throw new TranslationException("Cannot translate the server uri", e);
        }
    }
}

