/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.proxy2.ClientEndpoints;
import org.eclipse.californium.proxy2.Coap2CoapTranslator;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.http.Coap2HttpTranslator;
import org.eclipse.californium.proxy2.resources.CacheResource;
import org.eclipse.californium.proxy2.resources.ProxyCoapClientResource;
import org.eclipse.californium.proxy2.resources.ProxyHttpClientResource;
import org.eclipse.californium.proxy2.resources.StatsResource;

public abstract class ProxyCoapResource
extends CoapResource {
    protected final boolean accept;
    private volatile CacheResource cache;
    private volatile StatsResource statsResource;

    public ProxyCoapResource(String name, boolean visible, boolean accept) {
        super(name, visible);
        this.accept = accept;
    }

    public CacheResource getCache() {
        return this.cache;
    }

    public void setCache(CacheResource cache) {
        this.cache = cache;
    }

    public StatsResource getStatsResource() {
        return this.statsResource;
    }

    public void setStatsResource(StatsResource statsResource) {
        this.statsResource = statsResource;
    }

    public abstract CoapUriTranslator getUriTranslater();

    public abstract Set<String> getDestinationSchemes();

    public abstract void handleRequest(Exchange var1);

    public static ProxyCoapResource createReverseProxy(String name, boolean visible, boolean accept, final boolean copyQuery, final URI destination, ClientEndpoints ... endpointsList) {
        String scheme = destination.getScheme();
        for (ClientEndpoints endpoints : endpointsList) {
            if (!endpoints.getScheme().equals(scheme)) continue;
            Coap2CoapTranslator translator = new Coap2CoapTranslator(){

                @Override
                public URI getDestinationURI(Request incomingRequest, InetSocketAddress exposed) throws TranslationException {
                    if (copyQuery && incomingRequest.getOptions().getURIQueryCount() > 0) {
                        String query = incomingRequest.getOptions().getUriQueryString();
                        try {
                            return new URI(destination.getScheme(), null, destination.getHost(), destination.getPort(), destination.getPath(), query, null);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    return destination;
                }
            };
            return new ProxyCoapClientResource(name, visible, accept, translator, endpoints);
        }
        if (scheme.equals("http") || scheme.equals("https")) {
            Coap2HttpTranslator translator = new Coap2HttpTranslator(){

                @Override
                public URI getDestinationURI(Request incomingRequest, InetSocketAddress exposed) throws TranslationException {
                    if (copyQuery && incomingRequest.getOptions().getURIQueryCount() > 0) {
                        String query = incomingRequest.getOptions().getUriQueryString();
                        try {
                            return new URI(destination.getScheme(), null, destination.getHost(), destination.getPort(), destination.getPath(), query, null);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    return destination;
                }
            };
            return new ProxyHttpClientResource(name, visible, accept, translator, scheme);
        }
        return null;
    }
}

