/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.DelivererException;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.resources.ProxyCoapResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyMessageDeliverer
extends ServerMessageDeliverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardProxyMessageDeliverer.class);
    private final CoapUriTranslator translator;
    private final Map<String, Resource> scheme2resource;
    private final Set<InetSocketAddress> exposedServices;
    private final Set<InetAddress> exposedHosts;
    private final Set<Integer> exposedPorts;
    private boolean exposedAnyAddress;
    private DatagramSocket localAddressResolverSocket;

    public ForwardProxyMessageDeliverer(Resource root, CoapUriTranslator translator) {
        super(root);
        this.translator = translator;
        this.scheme2resource = new HashMap<String, Resource>();
        this.exposedServices = new HashSet<InetSocketAddress>();
        this.exposedPorts = new HashSet<Integer>();
        this.exposedHosts = new HashSet<InetAddress>();
    }

    public ForwardProxyMessageDeliverer(ProxyCoapResource proxyCoapResource) {
        this(null, proxyCoapResource.getUriTranslater());
        this.addProxyCoapResources(proxyCoapResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForwardProxyMessageDeliverer addExposedServiceAddresses(InetSocketAddress ... exposed) {
        if (exposed == null) {
            throw new NullPointerException("exposed interfaces must not be null!");
        }
        if (exposed.length == 0) {
            throw new IllegalArgumentException("exposed interfaces must not be empty!");
        }
        boolean exposedAnyAddress = false;
        Collection all = NetworkInterfacesUtil.getNetworkInterfaces();
        for (InetSocketAddress inetAddress : exposed) {
            LOGGER.info("address {}", (Object)inetAddress);
            this.exposedPorts.add(inetAddress.getPort());
            InetAddress address = inetAddress.getAddress();
            if (address.isAnyLocalAddress()) {
                exposedAnyAddress = true;
                for (InetAddress eAddress : all) {
                    this.exposedServices.add(new InetSocketAddress(eAddress, inetAddress.getPort()));
                    this.exposedHosts.add(eAddress);
                }
                continue;
            }
            this.exposedServices.add(inetAddress);
            this.exposedHosts.add(address);
        }
        for (Integer port : this.exposedPorts) {
            LOGGER.info("Exposed port {}", (Object)port);
        }
        for (InetAddress address : this.exposedHosts) {
            LOGGER.info("Exposed host {}", (Object)address);
        }
        for (InetSocketAddress inetAddress : this.exposedServices) {
            LOGGER.info("Exposed service {}", (Object)inetAddress);
        }
        if (exposedAnyAddress) {
            ForwardProxyMessageDeliverer forwardProxyMessageDeliverer = this;
            synchronized (forwardProxyMessageDeliverer) {
                this.exposedAnyAddress = true;
            }
        }
        return this;
    }

    public ForwardProxyMessageDeliverer addProxyCoapResources(ProxyCoapResource ... proxies) {
        if (proxies == null) {
            throw new NullPointerException("proxies must not be null!");
        }
        if (proxies.length == 0) {
            throw new IllegalArgumentException("proxies must not be empty!");
        }
        for (ProxyCoapResource proxy : proxies) {
            Set<String> schemes = proxy.getDestinationSchemes();
            for (String scheme : schemes) {
                if (this.scheme2resource.put(scheme, (Resource)proxy) == null) continue;
                LOGGER.warn("ambig proxy resource for scheme {}!", (Object)scheme);
            }
        }
        return this;
    }

    public synchronized boolean startLocalAddressResolver() {
        try {
            if (this.exposedAnyAddress && this.localAddressResolverSocket == null) {
                this.localAddressResolverSocket = new DatagramSocket();
            }
        }
        catch (SocketException e) {
            LOGGER.warn("");
        }
        return this.localAddressResolverSocket != null;
    }

    public synchronized void stopLocalAddressResolver() {
        if (this.localAddressResolverSocket != null) {
            this.localAddressResolverSocket.close();
            this.localAddressResolverSocket = null;
        }
    }

    protected Resource findResource(Exchange exchange) throws DelivererException {
        boolean local;
        boolean hostOption;
        boolean proxyOption;
        OptionSet options;
        Request request;
        Resource resource;
        block20: {
            resource = null;
            request = exchange.getRequest();
            options = request.getOptions();
            proxyOption = options.hasProxyUri() || options.hasProxyScheme();
            hostOption = options.hasUriHost() || options.hasUriPort();
            local = true;
            if (hostOption && !this.exposedServices.isEmpty()) {
                Integer port = options.getUriPort();
                String host = options.getUriHost();
                if (host == null) {
                    if (this.exposedPorts.contains(port)) {
                        hostOption = false;
                    } else {
                        local = false;
                    }
                } else if (port == null) {
                    try {
                        InetAddress address = InetAddress.getByName(host);
                        if (this.exposedHosts.contains(address)) {
                            hostOption = false;
                            break block20;
                        }
                        local = false;
                    }
                    catch (UnknownHostException e) {
                        hostOption = false;
                    }
                } else {
                    InetSocketAddress destination = new InetSocketAddress(host, (int)port);
                    if (destination.isUnresolved() || this.exposedServices.contains(destination)) {
                        hostOption = false;
                    } else {
                        local = false;
                    }
                }
            }
        }
        if (proxyOption || hostOption) {
            try {
                String scheme = this.translator.getDestinationScheme(request);
                if (scheme != null) {
                    InetAddress localAddress;
                    InetSocketAddress localSocketAddress;
                    resource = this.scheme2resource.get(scheme = scheme.toLowerCase());
                    if (resource == null) {
                        throw new DelivererException(CoAP.ResponseCode.PROXY_NOT_SUPPORTED, scheme + "not supported!");
                    }
                    if (options.getUriHost() == null && ((localSocketAddress = request.getLocalAddress()) == null || localSocketAddress.getAddress().isAnyLocalAddress()) && (localAddress = this.resolveLocalAddress(request.getSourceContext().getPeerAddress())) != null) {
                        request.setLocalAddress(new InetSocketAddress(localAddress, localSocketAddress.getPort()));
                    }
                } else {
                    local = true;
                }
            }
            catch (TranslationException e) {
                LOGGER.debug("Bad proxy request", (Throwable)e);
            }
        }
        if (resource == null && local) {
            resource = super.findResource(exchange);
        }
        return resource;
    }

    private synchronized InetAddress resolveLocalAddress(InetSocketAddress destination) {
        try {
            if (this.localAddressResolverSocket != null) {
                this.localAddressResolverSocket.connect(destination);
                InetAddress localAddress = this.localAddressResolverSocket.getLocalAddress();
                this.localAddressResolverSocket.disconnect();
                if (!localAddress.isAnyLocalAddress()) {
                    return localAddress;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }
}

