/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Response;

public final class CacheKey {
    private final CoAP.Code method;
    private final URI uri;
    private final int mediaType;
    private final byte[] payload;
    private final int hashCode;
    private Response response;

    static CacheKey fromCacheKey(CacheKey cacheKey, int contentType) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey must not be null!");
        }
        return new CacheKey(cacheKey.getMethod(), cacheKey.getUri(), contentType, cacheKey.payload);
    }

    public CacheKey(CoAP.Code method, URI uri, int mediaType, byte[] payload) {
        if (method == null) {
            throw new NullPointerException("method must not be null!");
        }
        if (uri == null) {
            throw new NullPointerException("URI must not be null!");
        }
        this.method = method;
        this.uri = uri;
        this.mediaType = mediaType;
        this.payload = payload;
        int prime = 31;
        int result = 1;
        result = 31 * result + mediaType;
        result = 31 * result + method.hashCode();
        result = 31 * result + Arrays.hashCode(payload);
        this.hashCode = result = 31 * result + uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        if (this.mediaType != other.mediaType) {
            return false;
        }
        if (this.method != other.method) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return Arrays.equals(this.payload, other.payload);
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public CoAP.Code getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public Response getResponse() {
        return this.response;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.method + " " + this.uri + "#ct=" + MediaTypeRegistry.toString((int)this.mediaType);
    }

    void setResponse(Response response) {
        this.response = response;
    }
}

