/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http.server;

import java.io.IOException;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.proxy2.http.Http2CoapTranslator;
import org.eclipse.californium.proxy2.http.server.HttpStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyHttpServer.class);
    private MessageDeliverer proxyCoapDeliverer;
    private MessageDeliverer localCoapDeliverer;
    private Http2CoapTranslator translator;
    private boolean handlerRegistered;
    private HttpStack httpStack;

    public ProxyHttpServer(NetworkConfig config, int httpPort) throws IOException {
        this(new HttpStack(config, httpPort));
    }

    private ProxyHttpServer(HttpStack stack) {
        this.httpStack = stack;
        this.httpStack.setRequestDeliverer(new MessageDeliverer(){

            public void deliverRequest(Exchange exchange) {
                ProxyHttpServer.this.handleRequest(exchange);
            }

            public void deliverResponse(Exchange exchange, Response response) {
            }
        });
    }

    public void start() {
        if (!this.handlerRegistered) {
            if (this.proxyCoapDeliverer != null) {
                this.httpStack.registerProxyRequestHandler();
                this.httpStack.registerHttpProxyRequestHandler();
            }
            if (this.localCoapDeliverer != null) {
                this.httpStack.registerLocalRequestHandler();
            }
            this.httpStack.registerDefaultHandler();
            if (this.translator == null) {
                this.translator = new Http2CoapTranslator();
            }
            this.httpStack.setHttpTranslator(this.translator);
            this.handlerRegistered = true;
        }
        this.httpStack.start();
    }

    public void stop() {
        this.httpStack.stop();
    }

    public void handleRequest(Exchange exchange) {
        Request request = exchange.getRequest();
        LOGGER.info("ProxyEndpoint handles request {}", (Object)request);
        if (request.getOptions().hasProxyUri()) {
            if (this.proxyCoapDeliverer != null) {
                this.proxyCoapDeliverer.deliverRequest(exchange);
            } else {
                exchange.sendResponse(new Response(CoAP.ResponseCode.PROXY_NOT_SUPPORTED));
            }
        } else if (this.localCoapDeliverer != null) {
            this.localCoapDeliverer.deliverRequest(exchange);
        } else {
            exchange.sendResponse(new Response(CoAP.ResponseCode.PROXY_NOT_SUPPORTED));
        }
    }

    public void setHttpTranslator(Http2CoapTranslator translator) {
        this.translator = translator;
    }

    public void setProxyCoapDeliverer(MessageDeliverer deliverer) {
        this.proxyCoapDeliverer = deliverer;
    }

    public void setLocalCoapDeliverer(MessageDeliverer deliverer) {
        this.localCoapDeliverer = deliverer;
    }
}

