/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Locale;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.support.AsyncResponseBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.proxy2.InvalidFieldException;
import org.eclipse.californium.proxy2.InvalidMethodException;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;
import org.eclipse.californium.proxy2.http.Http2CoapTranslator;
import org.eclipse.californium.proxy2.http.ProxyResponseProducer;
import org.eclipse.californium.proxy2.http.server.ByteBufferAsyncServerRequestHandler;
import org.eclipse.californium.proxy2.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStack {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpStack.class);
    private static final String SERVER_NAME = "Californium Http Proxy";
    private static final String PROXY_RESOURCE_NAME = "proxy";
    public static final String LOCAL_RESOURCE_NAME = "local";
    private final HttpServer server;
    private Http2CoapTranslator translator;
    private MessageDeliverer requestDeliverer;

    public HttpStack(NetworkConfig config, int httpPort) throws IOException {
        this(config, new InetSocketAddress(httpPort));
    }

    public HttpStack(NetworkConfig config, InetSocketAddress httpInterface) throws IOException {
        this.server = new HttpServer(config, httpInterface);
    }

    void setHttpTranslator(Http2CoapTranslator translator) {
        this.translator = translator;
    }

    void registerDefaultHandler() {
        this.server.setSimpleResource("*", "Californium Http Proxy on %s.", null);
    }

    void registerLocalRequestHandler() {
        String name = "/local";
        this.server.register(name + "/*", new ProxyAsyncRequestHandler(name, false));
    }

    void registerProxyRequestHandler() {
        String name = "/proxy";
        ProxyAsyncRequestHandler handler = new ProxyAsyncRequestHandler(name, true);
        this.server.register(name + "/*", handler);
        this.server.register(name, handler);
    }

    void registerHttpProxyRequestHandler() {
        String name = "/proxy";
        this.server.registerProxy(new ProxyAsyncRequestHandler(name, true));
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    public void setRequestDeliverer(MessageDeliverer requestDeliverer) {
        this.requestDeliverer = requestDeliverer;
    }

    private void sendHttpResponse(HttpRequest request, Response coapResponse, AsyncServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) {
        LOGGER.debug("Incoming response: {}", (Object)coapResponse);
        try {
            ProxyResponseProducer httpResponse = this.translator.getHttpResponse(request, coapResponse);
            LOGGER.debug("Outgoing http response: {}", (Object)httpResponse.getStatusLine());
            responseTrigger.submitResponse((AsyncResponseProducer)httpResponse, context);
        }
        catch (TranslationException e) {
            LOGGER.warn("Failed to translate coap response to http response: {}", (Object)e.getMessage());
            HttpStack.sendSimpleHttpResponse(502, null, responseTrigger, context);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to translate coap response to http response: {}", (Object)e.getMessage(), (Object)e);
            HttpStack.sendSimpleHttpResponse(502, null, responseTrigger, context);
        }
    }

    private static void sendSimpleHttpResponse(int httpCode, String message, AsyncServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) {
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(httpCode, Locale.ENGLISH);
        StringBuilder payload = new StringBuilder();
        payload.append(httpCode).append(": ").append(reason);
        if (message != null) {
            payload.append("\r\n\r\n").append(message);
        }
        try {
            responseTrigger.submitResponse(AsyncResponseBuilder.create((int)httpCode).setEntity(payload.toString(), ContentType.TEXT_PLAIN).build(), context);
        }
        catch (HttpException e) {
            LOGGER.warn("Failed to send response: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to send response: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private class ProxyAsyncRequestHandler
    extends ByteBufferAsyncServerRequestHandler {
        private final String resourceName;
        private final boolean proxyingEnabled;

        public ProxyAsyncRequestHandler(String resourceName, boolean proxyingEnabled) {
            this.resourceName = resourceName;
            this.proxyingEnabled = proxyingEnabled;
        }

        public void handle(Message<HttpRequest, ContentTypedEntity> message, final AsyncServerRequestHandler.ResponseTrigger responseTrigger, final HttpContext context) throws HttpException, IOException {
            HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
            EndpointDetails connection = coreContext.getEndpointDetails();
            final HttpRequest request = (HttpRequest)message.getHead();
            InetSocketAddress endpoint = (InetSocketAddress)connection.getLocalAddress();
            InetSocketAddress source = (InetSocketAddress)connection.getRemoteAddress();
            LOGGER.debug("handler {}, proxy {}", (Object)this.resourceName, (Object)this.proxyingEnabled);
            LOGGER.debug("Incoming http request: on {} from {}{}   {}", new Object[]{endpoint, source, StringUtil.lineSeparator(), new RequestLine(request)});
            try {
                final Request coapRequest = HttpStack.this.translator.getCoapRequest(message, this.resourceName, this.proxyingEnabled);
                LOGGER.info("Received HTTP request and translate to {}", (Object)coapRequest);
                coapRequest.setSourceContext((EndpointContext)new AddressEndpointContext(source));
                coapRequest.setLocalAddress(endpoint);
                Exchange exchange = new Exchange(coapRequest, Exchange.Origin.REMOTE, null){

                    public void sendAccept() {
                    }

                    public void sendReject() {
                        HttpStack.sendSimpleHttpResponse(502, null, responseTrigger, context);
                    }

                    public void sendResponse(Response response) {
                        coapRequest.setResponse(response);
                        HttpStack.this.sendHttpResponse(request, response, responseTrigger, context);
                        LOGGER.debug("HTTP returned {}", (Object)response);
                    }
                };
                HttpStack.this.requestDeliverer.deliverRequest(exchange);
            }
            catch (InvalidMethodException e) {
                LOGGER.warn("Method not implemented", (Throwable)e);
                HttpStack.sendSimpleHttpResponse(501, e.getMessage(), responseTrigger, context);
            }
            catch (InvalidFieldException e) {
                LOGGER.warn("Request malformed", (Throwable)e);
                HttpStack.sendSimpleHttpResponse(400, e.getMessage(), responseTrigger, context);
            }
            catch (TranslationException e) {
                LOGGER.warn("Failed to translate the http request in a valid coap request", (Throwable)e);
                HttpStack.sendSimpleHttpResponse(502, e.getMessage(), responseTrigger, context);
            }
            catch (Throwable e) {
                LOGGER.error("Unexpected error", e);
                HttpStack.sendSimpleHttpResponse(500, e.getMessage(), responseTrigger, context);
            }
        }
    }
}

