/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncFilterChain;
import org.apache.hc.core5.http.nio.AsyncFilterHandler;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.AsyncResponseBuilder;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.hc.core5.http.protocol.ResponseServer;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;
import org.eclipse.californium.proxy2.http.server.ByteBufferAsyncServerRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private final InetSocketAddress httpInterface;
    private final AsyncServerBootstrap bootstrap;
    private final Set<String> virtualHosts = new HashSet<String>();
    private HttpAsyncServer server;
    private TerminalAsyncServerFilter proxyServerFilter;

    public HttpServer(NetworkConfig config, int httpPort) {
        this(config, new InetSocketAddress(httpPort));
    }

    public HttpServer(NetworkConfig config, InetSocketAddress httpInterface) {
        if (httpInterface == null) {
            throw new NullPointerException("http interface must not be null!");
        }
        this.httpInterface = httpInterface;
        HttpProcessor httpProcessor = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer()).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build();
        int threads = config.getInt("NETWORK_STAGE_SENDER_THREAD_COUNT");
        int socketTimeout = config.getInt("HTTP_SERVER_SOCKET_TIMEOUT");
        int socketBufferSize = config.getInt("HTTP_SERVER_SOCKET_BUFFER_SIZE");
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setRcvBufSize(socketBufferSize).setSoTimeout(socketTimeout, TimeUnit.MILLISECONDS).setTcpNoDelay(true).setSoLinger(0, TimeUnit.MILLISECONDS).setIoThreadCount(threads).build();
        this.bootstrap = AsyncServerBootstrap.bootstrap().setIOReactorConfig(ioReactorConfig).setHttpProcessor(httpProcessor).setLookupRegistry(UriPatternType.newMatcher((UriPatternType)UriPatternType.URI_PATTERN_IN_ORDER));
    }

    public <T> void registerProxy(final AsyncServerRequestHandler<T> requestHandler) {
        if (this.server != null) {
            throw new IllegalStateException("http server already started!");
        }
        Args.notNull(requestHandler, (String)"Request handler");
        this.proxyServerFilter = new TerminalAsyncServerFilter((HandlerFactory)new HandlerFactory<AsyncServerExchangeHandler>(){

            public AsyncServerExchangeHandler create(HttpRequest request, HttpContext context) throws HttpException {
                return new BasicServerExchangeHandler(requestHandler);
            }
        });
    }

    public <T> void register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        if (this.server != null) {
            throw new IllegalStateException("http server already started!");
        }
        Args.notNull(requestHandler, (String)"Request handler");
        this.bootstrap.register(uriPattern, requestHandler);
    }

    public <T> void registerVirtual(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        if (this.server != null) {
            throw new IllegalStateException("http server already started!");
        }
        Args.notNull(this.virtualHosts, (String)"hostname");
        Args.notNull(requestHandler, (String)"Request handler");
        this.virtualHosts.add(hostname);
        this.bootstrap.registerVirtual(hostname, uriPattern, requestHandler);
    }

    public InetSocketAddress getInterface() {
        return this.httpInterface;
    }

    public void start() {
        if (this.proxyServerFilter != null && this.server == null) {
            this.bootstrap.addFilterBefore(StandardFilter.MAIN_HANDLER.name(), "proxy", new AsyncFilterHandler(){

                public AsyncDataConsumer handle(HttpRequest request, EntityDetails entityDetails, HttpContext context, AsyncFilterChain.ResponseTrigger responseTrigger, AsyncFilterChain chain) throws HttpException, IOException {
                    try {
                        URI uri = request.getUri();
                        if (uri.getScheme() != null && !HttpServer.this.virtualHosts.contains(uri.getHost())) {
                            LOGGER.warn("proxy filter {}", (Object)uri);
                            return HttpServer.this.proxyServerFilter.handle(request, entityDetails, context, responseTrigger, chain);
                        }
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    return chain.proceed(request, entityDetails, context, responseTrigger);
                }
            });
        }
        this.server = this.bootstrap.create();
        LOGGER.info("HttpServer listening on {} started.", StringUtil.toLog((SocketAddress)this.httpInterface));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("HTTP server shutting down");
                HttpServer.this.stop();
            }
        });
        this.server.start();
        Future future = this.server.listen((SocketAddress)this.httpInterface);
        try {
            ListenerEndpoint listenerEndpoint = (ListenerEndpoint)future.get();
            LOGGER.info("Listening on {}", (Object)listenerEndpoint.getAddress());
        }
        catch (InterruptedException ex) {
            LOGGER.info("interrupted", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOGGER.error("unexpected error:", (Throwable)ex);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.close(CloseMode.GRACEFUL);
            System.out.println("shutdown ...");
            try {
                this.server.awaitShutdown(TimeValue.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.info("HttpServer on {} stopped.", StringUtil.toLog((SocketAddress)this.httpInterface));
    }

    public void setSimpleResource(String resource, String message, AtomicLong requestCounter) {
        String name = StringUtil.toDisplayString((InetSocketAddress)this.httpInterface);
        this.bootstrap.register(resource, (AsyncServerRequestHandler)new RequestCounterHandler(message, name, requestCounter));
    }

    private static class RequestCounterHandler
    extends ByteBufferAsyncServerRequestHandler {
        private final String message;
        private final String name;
        private final AtomicLong requestCounter;

        private RequestCounterHandler(String message, String name, AtomicLong requestCounter) {
            this.message = message;
            this.name = name;
            this.requestCounter = requestCounter == null ? new AtomicLong() : requestCounter;
        }

        public void handle(Message<HttpRequest, ContentTypedEntity> message, AsyncServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
            HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
            EndpointDetails endpoint = coreContext.getEndpointDetails();
            long counter = this.requestCounter.incrementAndGet();
            String payload = String.format(this.message, this.name, counter);
            int hc = payload.hashCode();
            responseTrigger.submitResponse(AsyncResponseBuilder.create((int)200).addHeader("Etag", Integer.toHexString(hc)).setEntity(payload, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)).build(), context);
            LOGGER.debug("{}, {} request handled!", (Object)endpoint, (Object)counter);
        }
    }
}

