/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.proxy2.InvalidFieldException;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.http.ContentTypedEntity;
import org.eclipse.californium.proxy2.http.CrossProtocolTranslator;
import org.eclipse.californium.proxy2.http.ProxyResponseProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2CoapTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2CoapTranslator.class);
    protected final CrossProtocolTranslator httpTranslator;
    protected final CrossProtocolTranslator.EtagTranslator etagTranslator;

    public Http2CoapTranslator(String mappingPropertiesFileName) {
        this(new CrossProtocolTranslator(mappingPropertiesFileName), new CrossProtocolTranslator.CoapServerEtagTranslator());
    }

    public Http2CoapTranslator() {
        this(new CrossProtocolTranslator(), new CrossProtocolTranslator.CoapServerEtagTranslator());
    }

    public Http2CoapTranslator(CrossProtocolTranslator httpTranslator, CrossProtocolTranslator.EtagTranslator etagTranslator) {
        if (httpTranslator == null) {
            throw new NullPointerException("http-translator must not be null!");
        }
        if (etagTranslator == null) {
            throw new NullPointerException("etag-translator must not be null!");
        }
        this.httpTranslator = httpTranslator;
        this.etagTranslator = etagTranslator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Request getCoapRequest(Message<HttpRequest, ContentTypedEntity> httpRequest, String httpResource, boolean proxyingEnabled) throws TranslationException {
        URI uri;
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest must not be null!");
        }
        if (httpResource == null) {
            throw new NullPointerException("httpResource must not be null!");
        }
        String httpMethod = ((HttpRequest)httpRequest.getHead()).getMethod();
        CoAP.Code code = this.httpTranslator.getCoapCode(httpMethod);
        Request coapRequest = new Request(code, CoAP.Type.CON);
        try {
            uri = ((HttpRequest)httpRequest.getHead()).getUri();
            LOGGER.debug("URI <= '{}'", (Object)uri);
        }
        catch (URISyntaxException ex) {
            throw new TranslationException("Malformed uri: " + ex.getMessage());
        }
        if (!httpResource.startsWith("/")) {
            httpResource = "/" + httpResource;
        }
        String path = uri.getPath();
        LOGGER.debug("URI path => '{}'", (Object)path);
        if (path.startsWith(httpResource + "/")) {
            int index;
            String target = path = path.substring(httpResource.length() + 1);
            if (uri.getQuery() != null) {
                target = path + "?" + uri.getQuery();
            }
            if ((index = target.indexOf(":/")) > 0 && target.charAt(index += 2) != '/') {
                target = target.substring(0, index) + "/" + target.substring(index);
            }
            try {
                uri = new URI(target);
                if (proxyingEnabled) {
                    if (uri.getScheme() == null) {
                        throw new InvalidFieldException("Malformed uri: destination scheme missing! Use http://<proxy-host>" + httpResource + "/coap://<destination-host>/<path>");
                    }
                    LOGGER.debug("URI destination => '{}'", (Object)target);
                    coapRequest.getOptions().setProxyUri(target);
                }
                if (uri.getScheme() != null) {
                    throw new InvalidFieldException("Malformed uri: local destination doesn't support scheme! Use http://<proxy-host>" + httpResource + "/<path>");
                }
                target = "coap://localhost/" + target;
                LOGGER.debug("URI local => '{}'", (Object)target);
                coapRequest.setURI(target);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Malformed destination uri", (Throwable)e);
                throw new InvalidFieldException("Malformed destination uri: " + target + "!");
            }
        } else {
            if (proxyingEnabled && path.equals(httpResource)) {
                String target = null;
                if (uri.getQuery() != null) {
                    List query = URLEncodedUtils.parse((CharSequence)uri.getQuery(), (Charset)StandardCharsets.UTF_8);
                    for (NameValuePair arg : query) {
                        if (!arg.getName().equalsIgnoreCase("target_uri")) continue;
                        target = arg.getValue();
                        break;
                    }
                }
                if (target == null) {
                    throw new InvalidFieldException("Malformed uri: target_uri is missing! Use http://<proxy-host>" + httpResource + "?target_uri=coap://<destination-host>/<path>");
                }
                try {
                    uri = new URI(target);
                    if (uri.getScheme() == null) {
                        throw new InvalidFieldException("Malformed uri: destination scheme missing! Use http://<proxy-host>" + httpResource + "?target_uri=coap://<destination-host>/<path>");
                    }
                    LOGGER.debug("URI destination => '{}'", target);
                    coapRequest.getOptions().setProxyUri(target);
                }
                catch (URISyntaxException e) {
                    LOGGER.warn("Malformed destination uri", (Throwable)e);
                    throw new InvalidFieldException("Malformed destination uri: " + target + "!");
                }
            }
            if (!proxyingEnabled || uri.getScheme() == null) throw new IllegalArgumentException("URI '" + uri + "' doesn't match handler '" + httpResource + "'!");
            int index = path.lastIndexOf(47);
            if (0 >= index) throw new TranslationException("Malformed proxy uri: target scheme missing! Use http://<destination-host>/<path>/<target-scheme>:");
            String scheme = path.substring(index + 1);
            if (!scheme.matches("\\w+:$")) throw new TranslationException("Malformed proxy uri: target scheme missing! Use http://<destination-host>/<path>/<target-scheme>:");
            scheme = scheme.substring(0, scheme.length() - 1);
            path = path.substring(0, index);
            try {
                URI destination = new URI(scheme, null, uri.getHost(), uri.getPort(), path, uri.getQuery(), null);
                coapRequest.getOptions().setProxyUri(destination.toASCIIString());
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Malformed proxy uri", (Throwable)e);
                throw new TranslationException("Malformed proxy uri: '" + uri + "' " + e.getMessage());
            }
        }
        List<Option> coapOptions = this.httpTranslator.getCoapOptions(((HttpRequest)httpRequest.getHead()).getHeaders(), this.etagTranslator);
        coapRequest.getOptions().addOptions(coapOptions);
        ContentTypedEntity entity = (ContentTypedEntity)httpRequest.getBody();
        this.httpTranslator.setCoapPayload(entity, (org.eclipse.californium.core.coap.Message)coapRequest);
        return coapRequest;
    }

    public ProxyResponseProducer getHttpResponse(HttpRequest httpRequest, Response coapResponse) throws TranslationException {
        if (httpRequest == null) {
            throw new NullPointerException("HTTP request must not be null!");
        }
        if (coapResponse == null) {
            throw new NullPointerException("CoAP response must not be null!");
        }
        CoAP.ResponseCode coapCode = coapResponse.getCode();
        int httpCode = this.httpTranslator.getHttpCode(coapResponse.getCode());
        BasicHttpResponse httpResponse = new BasicHttpResponse(httpCode);
        httpResponse.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(httpCode, Locale.ENGLISH);
        httpResponse.setReasonPhrase(reason);
        Header[] headers = this.httpTranslator.getHttpHeaders(coapResponse.getOptions().asSortedList(), this.etagTranslator);
        httpResponse.setHeaders(headers);
        if (!httpResponse.containsHeader("cache-control")) {
            httpResponse.setHeader("cache-control", (Object)"max-age=60");
        }
        ContentTypedEntity httpEntity = null;
        if (!Method.HEAD.name().equalsIgnoreCase(httpRequest.getMethod())) {
            if (coapResponse.getOptions().getContentFormat() == -1 && (CoAP.ResponseCode.isClientError((CoAP.ResponseCode)coapCode) || CoAP.ResponseCode.isServerError((CoAP.ResponseCode)coapCode))) {
                LOGGER.info("Set content-type to TEXT_PLAIN");
                coapResponse.getOptions().setContentFormat(0);
                if (coapResponse.getPayloadSize() == 0) {
                    coapResponse.setPayload(httpCode + ": " + reason);
                }
            }
            if ((httpEntity = this.httpTranslator.getHttpEntity((org.eclipse.californium.core.coap.Message)coapResponse)) != null) {
                ContentType contentType = httpEntity.getContentType();
                httpResponse.setHeader("content-type", (Object)contentType.toString());
            }
        }
        return new ProxyResponseProducer((HttpResponse)httpResponse, ContentTypedEntity.createProducer(httpEntity));
    }
}

