/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.net.URI;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coap2CoapTranslator
extends CoapUriTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Coap2CoapTranslator.class);

    public Request getRequest(URI destination, Request incomingRequest) throws TranslationException {
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        if (incomingRequest == null) {
            throw new NullPointerException("incomingRequest == null");
        }
        CoAP.Code code = incomingRequest.getCode();
        CoAP.Type type = incomingRequest.getType();
        Request outgoingRequest = new Request(code);
        outgoingRequest.setConfirmable(type == CoAP.Type.CON);
        byte[] payload = incomingRequest.getPayload();
        outgoingRequest.setPayload(payload);
        OptionSet options = new OptionSet(incomingRequest.getOptions());
        options.removeProxyScheme();
        options.removeProxyUri();
        options.removeBlock1();
        options.removeBlock2();
        options.removeUriHost();
        options.removeUriPort();
        options.clearUriPath();
        options.clearUriQuery();
        outgoingRequest.setOptions(options);
        outgoingRequest.setURI(destination);
        LOGGER.debug("Incoming request translated correctly");
        return outgoingRequest;
    }

    public Response getResponse(Response incomingResponse) {
        if (incomingResponse == null) {
            throw new IllegalArgumentException("incomingResponse == null");
        }
        CoAP.ResponseCode status = incomingResponse.getCode();
        Response outgoingResponse = new Response(status);
        byte[] payload = incomingResponse.getPayload();
        outgoingResponse.setPayload(payload);
        long timestamp = incomingResponse.getNanoTimestamp();
        outgoingResponse.setNanoTimestamp(timestamp);
        outgoingResponse.setOptions(incomingResponse.getOptions());
        LOGGER.debug("Incoming response translated correctly");
        return outgoingResponse;
    }
}

