/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.proxy2.Coap2CoapTranslator;
import org.eclipse.californium.proxy2.Coap2HttpTranslator;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.HttpClientFactory;
import org.eclipse.californium.proxy2.InvalidFieldException;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.resources.CacheKey;
import org.eclipse.californium.proxy2.resources.CacheResource;
import org.eclipse.californium.proxy2.resources.ProxyCoapResource;
import org.eclipse.californium.proxy2.resources.StatsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHttpClientResource
extends ProxyCoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyHttpClientResource.class);
    private final Coap2HttpTranslator translator;
    private final Set<String> schemes = new HashSet<String>();
    private static final CloseableHttpAsyncClient asyncClient = HttpClientFactory.createClient();

    public ProxyHttpClientResource(String name, boolean visible, boolean accept, Coap2HttpTranslator translator, String ... schemes) {
        super(name, visible, accept);
        this.getAttributes().setTitle("Forward the requests to a HTTP client.");
        Coap2HttpTranslator coap2HttpTranslator = this.translator = translator != null ? translator : new Coap2HttpTranslator();
        if (schemes == null || schemes.length == 0) {
            this.schemes.add("http");
        } else {
            for (String scheme : schemes) {
                this.schemes.add(scheme);
            }
        }
    }

    @Override
    public void handleRequest(final Exchange exchange) {
        CacheKey cacheKey;
        URI destination;
        final Request incomingCoapRequest = exchange.getRequest();
        try {
            InetSocketAddress exposedInterface = this.translator.getExposedInterface(incomingCoapRequest);
            destination = this.translator.getDestinationURI(incomingCoapRequest, exposedInterface);
        }
        catch (TranslationException ex) {
            LOGGER.debug("URI error.", (Throwable)ex);
            exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
            return;
        }
        final CacheResource cache = this.getCache();
        if (cache != null) {
            cacheKey = new CacheKey(incomingCoapRequest.getCode(), destination, incomingCoapRequest.getOptions().getAccept(), incomingCoapRequest.getPayload());
            Response response = cache.getResponse(cacheKey);
            StatsResource statsResource = this.getStatsResource();
            if (statsResource != null) {
                statsResource.updateStatistics(destination, response != null);
            }
            if (response != null) {
                LOGGER.info("Cache returned {}", (Object)response);
                exchange.sendResponse(response);
                return;
            }
        } else {
            cacheKey = null;
        }
        HttpHost httpHost = new HttpHost(destination.getHost(), destination.getPort(), destination.getScheme());
        HttpRequest httpRequest = null;
        try {
            httpRequest = this.translator.getHttpRequest(destination, incomingCoapRequest);
            LOGGER.debug("Outgoing http request: {}", (Object)httpRequest.getRequestLine());
        }
        catch (InvalidFieldException e) {
            LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
            exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
            return;
        }
        catch (TranslationException e) {
            LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
            exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_TRANSLATION_ERROR));
            return;
        }
        if (this.accept) {
            exchange.sendAccept();
        }
        asyncClient.execute(httpHost, httpRequest, (HttpContext)new BasicHttpContext(), (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                try {
                    long timestamp = ClockUtil.nanoRealtime();
                    LOGGER.debug("Incoming http response: {}", (Object)result.getStatusLine());
                    Response coapResponse = ProxyHttpClientResource.this.translator.getCoapResponse(result, incomingCoapRequest);
                    coapResponse.setNanoTimestamp(timestamp);
                    if (cache != null) {
                        cache.cacheResponse(cacheKey, coapResponse);
                    }
                    exchange.sendResponse(coapResponse);
                }
                catch (InvalidFieldException e) {
                    LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
                    exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
                }
                catch (TranslationException e) {
                    LOGGER.debug("Problems during the http/coap translation: {}", (Object)e.getMessage());
                    exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_TRANSLATION_ERROR));
                }
                catch (Throwable e) {
                    LOGGER.debug("Error during the http/coap translation: {}", (Object)e.getMessage(), (Object)e);
                    exchange.sendResponse(new Response(Coap2CoapTranslator.STATUS_FIELD_MALFORMED));
                }
                LOGGER.debug("Incoming http response: {} processed!", (Object)result.getStatusLine());
            }

            public void failed(Exception ex) {
                LOGGER.debug("Failed to get the http response: {}", (Object)ex.getMessage());
                if (ex instanceof SocketTimeoutException) {
                    exchange.sendResponse(new Response(CoAP.ResponseCode.GATEWAY_TIMEOUT));
                } else {
                    exchange.sendResponse(new Response(CoAP.ResponseCode.BAD_GATEWAY));
                }
            }

            public void cancelled() {
                LOGGER.debug("Request canceled");
                exchange.sendResponse(new Response(CoAP.ResponseCode.SERVICE_UNAVAILABLE));
            }
        });
    }

    @Override
    public CoapUriTranslator getUriTranslater() {
        return this.translator;
    }

    @Override
    public Set<String> getDestinationSchemes() {
        return Collections.unmodifiableSet(this.schemes);
    }
}

