/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.proxy2.InvalidMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingProperties
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(MappingProperties.class);
    private static final long serialVersionUID = 4126898261482584755L;
    private static final String HEADER = "Californium Cross-Proxy2 mapping properties file";
    private static final String KEY_COAP_METHOD = "coap.request.code.";
    private static final String KEY_COAP_CODE = "coap.response.code.";
    public static final String KEY_COAP_OPTION = "coap.message.option.";
    public static final String KEY_COAP_MEDIA = "coap.message.media.";
    private static final String KEY_HTTP_CODE = "http.response.code.";
    private static final String KEY_HTTP_METHOD = "http.request.method.";
    public static final String KEY_HTTP_HEADER = "http.message.header.";
    public static final String KEY_HTTP_CONTENT_TYPE = "http.message.content-type.";
    private final Map<CoAP.ResponseCode, Integer> httpCodes = new HashMap<CoAP.ResponseCode, Integer>();
    private final Map<Integer, CoAP.ResponseCode> coapCodes = new HashMap<Integer, CoAP.ResponseCode>();
    private final Map<String, Object> httpMethods = new HashMap<String, Object>();
    private final Map<CoAP.Code, String> coapMethods = new HashMap<CoAP.Code, String>();

    public MappingProperties(String fileName) {
        this.init();
        this.initUserDefined(fileName);
        for (String key : this.stringPropertyNames()) {
            if (key.startsWith(KEY_COAP_CODE)) {
                this.initResponseCode(key);
                continue;
            }
            if (key.startsWith(KEY_HTTP_CODE)) {
                this.initHttpCode(key);
                continue;
            }
            if (key.startsWith(KEY_HTTP_METHOD)) {
                this.initHttpMethod(key);
                continue;
            }
            if (!key.startsWith(KEY_COAP_METHOD)) continue;
            this.initCoapMethod(key);
        }
    }

    private void initResponseCode(String key) {
        int httpCode = this.getInt(key);
        CoAP.ResponseCode code = CoAP.ResponseCode.valueOfText((String)key.substring(KEY_COAP_CODE.length()));
        if (code != null) {
            this.httpCodes.put(code, httpCode);
        }
    }

    private void initHttpCode(String key) {
        String tag = this.getStr(key);
        CoAP.ResponseCode code = CoAP.ResponseCode.valueOfText((String)tag);
        Integer httpCode = Integer.valueOf(key.substring(KEY_HTTP_CODE.length()), 10);
        if (httpCode != null && code != null) {
            this.coapCodes.put(httpCode, code);
        }
    }

    private void initHttpMethod(String key) {
        String mapKey = key.substring(KEY_HTTP_METHOD.length());
        String tag = this.getStr(key);
        CoAP.Code code = CoAP.Code.valueOfText((String)tag);
        if (code == null) {
            code = CoAP.ResponseCode.valueOfText((String)tag);
        }
        if (code != null) {
            this.httpMethods.put(mapKey, code);
        }
    }

    private void initCoapMethod(String key) {
        String httpMethod = this.getStr(key);
        String tag = key.substring(KEY_COAP_METHOD.length());
        CoAP.Code code = CoAP.Code.valueOfText((String)tag);
        if (code != null && httpMethod != null) {
            this.coapMethods.put(code, httpMethod);
        }
    }

    public CoAP.Code getCoapCode(String httpMethod) throws InvalidMethodException {
        Object code = this.httpMethods.get(httpMethod);
        if (code instanceof CoAP.Code) {
            return (CoAP.Code)code;
        }
        if (code instanceof CoAP.ResponseCode) {
            throw new InvalidMethodException((CoAP.ResponseCode)code);
        }
        throw new InvalidMethodException(CoAP.ResponseCode.BAD_GATEWAY);
    }

    public String getHttpMethod(CoAP.Code code) {
        return this.coapMethods.get(code);
    }

    public Integer getHttpCode(CoAP.ResponseCode code) {
        return this.httpCodes.get(code);
    }

    public CoAP.ResponseCode getCoapResponseCode(Integer code) {
        return this.coapCodes.get(code);
    }

    public int getInt(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                LOG.error(String.format("Invalid integer property: %s=%s", key, value));
            }
        } else {
            LOG.error(String.format("Undefined integer property: %s", key));
        }
        return 0;
    }

    public String getStr(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            LOG.error(String.format("Undefined string property: %s", key));
        }
        return value;
    }

    public boolean getBool(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                LOG.error(String.format("Invalid boolean property: %s=%s", key, value));
            }
        } else {
            LOG.error(String.format("Undefined boolean property: %s", key));
        }
        return false;
    }

    public void load(String fileName) throws IOException {
        FileInputStream in = new FileInputStream(fileName);
        this.load(in);
    }

    public void set(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public void set(String key, String value) {
        this.setProperty(key, value);
    }

    public void set(String key, boolean value) {
        this.setProperty(key, String.valueOf(value));
    }

    public void store(String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        this.store(out, HEADER);
    }

    private void init() {
        this.set("http.request.method.options", "5.01");
        this.set("http.request.method.trace", "5.01");
        this.set("http.request.method.connect", "5.01");
        this.set("http.request.method.head", "0.01");
        this.set("http.request.method.get", "0.01");
        this.set("http.request.method.post", "0.02");
        this.set("http.request.method.put", "0.03");
        this.set("http.request.method.delete", "0.04");
        this.set("http.response.code.100", "5.02");
        this.set("http.response.code.101", "5.02");
        this.set("http.response.code.102", "5.02");
        this.set("http.response.code.200", "2.05");
        this.set("http.response.code.201", "2.01");
        this.set("http.response.code.202", "2.05");
        this.set("http.response.code.203", "2.05");
        this.set("http.response.code.20204", "2.04");
        this.set("http.response.code.30204", "2.04");
        this.set("http.response.code.40204", "2.02");
        this.set("http.response.code.205", "2.05");
        this.set("http.response.code.206", "2.05");
        this.set("http.response.code.207", "2.05");
        this.set("http.response.code.300", "5.02");
        this.set("http.response.code.301", "5.02");
        this.set("http.response.code.302", "5.02");
        this.set("http.response.code.303", "5.02");
        this.set("http.response.code.304", "2.03");
        this.set("http.response.code.305", "5.02");
        this.set("http.response.code.307", "5.02");
        this.set("http.response.code.400", "4.00");
        this.set("http.response.code.401", "4.01");
        this.set("http.response.code.402", "4.00");
        this.set("http.response.code.403", "4.03");
        this.set("http.response.code.404", "4.04");
        this.set("http.response.code.405", "4.05");
        this.set("http.response.code.406", "4.06");
        this.set("http.response.code.407", "4.00");
        this.set("http.response.code.408", "4.00");
        this.set("http.response.code.409", "4.00");
        this.set("http.response.code.410", "4.00");
        this.set("http.response.code.411", "4.00");
        this.set("http.response.code.412", "4.12");
        this.set("http.response.code.413", "4.13");
        this.set("http.response.code.414", "4.00");
        this.set("http.response.code.415", "4.15");
        this.set("http.response.code.416", "4.00");
        this.set("http.response.code.417", "4.00");
        this.set("http.response.code.418", "4.00");
        this.set("http.response.code.419", "4.00");
        this.set("http.response.code.420", "4.00");
        this.set("http.response.code.422", "4.00");
        this.set("http.response.code.423", "4.00");
        this.set("http.response.code.424", "4.00");
        this.set("http.response.code.500", "5.00");
        this.set("http.response.code.501", "5.01");
        this.set("http.response.code.502", "5.02");
        this.set("http.response.code.503", "5.03");
        this.set("http.response.code.504", "5.04");
        this.set("http.response.code.505", "5.02");
        this.set("http.response.code.507", "5.00");
        this.set("coap.request.code.0.01", "GET");
        this.set("coap.request.code.0.02", "POST");
        this.set("coap.request.code.0.03", "PUT");
        this.set("coap.request.code.0.04", "DELETE");
        this.set("coap.response.code.2.01", 201);
        this.set("coap.response.code.2.02", 204);
        this.set("coap.response.code.2.03", 304);
        this.set("coap.response.code.2.04", 204);
        this.set("coap.response.code.2.05", 200);
        this.set("coap.response.code.4.00", 400);
        this.set("coap.response.code.4.01", 401);
        this.set("coap.response.code.4.02", 400);
        this.set("coap.response.code.4.03", 403);
        this.set("coap.response.code.4.04", 404);
        this.set("coap.response.code.4.05", 405);
        this.set("coap.response.code.4.06", 406);
        this.set("coap.response.code.4.12", 412);
        this.set("coap.response.code.4.13", 413);
        this.set("coap.response.code.4.15", 415);
        this.set("coap.response.code.5.00", 500);
        this.set("coap.response.code.5.01", 501);
        this.set("coap.response.code.5.02", 502);
        this.set("coap.response.code.5.03", 503);
        this.set("coap.response.code.5.04", 504);
        this.set("coap.response.code.5.05", 502);
        this.set("http.message.header.content-type", 12);
        this.set("http.message.header.accept", 17);
        this.set("http.message.header.if-match", 1);
        this.set("http.message.header.if-none-match", 5);
        this.set("http.message.header.etag", 4);
        this.set("http.message.header.cache-control", 14);
        this.set("coap.message.option.12", "Content-Type");
        this.set("coap.message.option.14", "Cache-Control");
        this.set("coap.message.option.4", "Etag");
        this.set("coap.message.option.8", "Location");
        this.set("coap.message.option.20", "Location");
        this.set("coap.message.option.17", "Accept");
        this.set("coap.message.option.1", "If-Match");
        this.set("coap.message.option.5", "If-None-Match");
        this.set("http.message.content-type.text/plain", 0);
        this.set("http.message.content-type.application/link-format", 40);
        this.set("http.message.content-type.application/xml", 41);
        this.set("http.message.content-type.application/json", 50);
        this.set("coap.message.media.0", "text/plain; charset=utf-8");
        this.set("coap.message.media.40", "application/link-format");
        this.set("coap.message.media.41", "application/xml");
        this.set("coap.message.media.50", "application/json; charset=UTF-8");
    }

    private void initUserDefined(String fileName) {
        try {
            this.load(fileName);
        }
        catch (IOException e) {
            try {
                this.store(fileName);
            }
            catch (IOException e1) {
                LOG.warn(String.format("Failed to create configuration file: %s", e1.getMessage()));
            }
        }
    }
}

