/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.proxy2.InvalidMethodException;
import org.eclipse.californium.proxy2.MappingProperties;
import org.eclipse.californium.proxy2.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTranslator {
    private static final MappingProperties DEFAULT_HTTP_TRANSLATION_PROPERTIES = new MappingProperties("Proxy2.properties");
    private MappingProperties translationMapping;
    public static final int STATUS_TIMEOUT = 504;
    public static final int STATUS_NOT_FOUND = 502;
    public static final int STATUS_TRANSLATION_ERROR = 502;
    public static final int STATUS_URI_MALFORMED = 400;
    public static final int STATUS_WRONG_METHOD = 501;
    public static final int STATUS_INTERNAL_SERVER_ERROR = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTranslator.class);

    public HttpTranslator(String mappingPropertiesFileName) {
        this.translationMapping = new MappingProperties(mappingPropertiesFileName);
    }

    public HttpTranslator() {
        this.translationMapping = DEFAULT_HTTP_TRANSLATION_PROPERTIES;
    }

    public CoAP.ResponseCode getCoapResponseCode(int code) throws TranslationException {
        CoAP.ResponseCode responseCode = this.translationMapping.getCoapResponseCode(code);
        if (responseCode == null) {
            LOGGER.warn("coap response code missing for {}", (Object)code);
            throw new TranslationException("coap response-code missing!");
        }
        return responseCode;
    }

    public CoAP.Code getCoapCode(String httpMethod) throws InvalidMethodException {
        return this.translationMapping.getCoapCode(httpMethod);
    }

    public int getCoapMediaType(HttpMessage httpMessage) {
        Header contentTypeHeader;
        if (httpMessage == null) {
            throw new IllegalArgumentException("httpMessage == null");
        }
        HttpEntity httpEntity = null;
        if (httpMessage instanceof HttpResponse) {
            httpEntity = ((HttpResponse)httpMessage).getEntity();
        } else if (httpMessage instanceof HttpEntityEnclosingRequest) {
            httpEntity = ((HttpEntityEnclosingRequest)httpMessage).getEntity();
        }
        if (httpEntity == null) {
            throw new IllegalArgumentException("The http message does not contain any httpEntity.");
        }
        int coapContentType = -1;
        ContentType contentType = ContentType.get((HttpEntity)httpEntity);
        if (contentType == null && (contentTypeHeader = httpMessage.getFirstHeader("content-type")) != null) {
            String contentTypeString = contentTypeHeader.getValue();
            contentType = ContentType.parse((String)contentTypeString);
        }
        if (contentType != null) {
            String httpContentTypeString = contentType.getMimeType();
            httpContentTypeString = httpContentTypeString.split(";")[0];
            String coapContentTypeString = this.translationMapping.getProperty("http.message.content-type." + httpContentTypeString);
            coapContentType = coapContentTypeString != null ? Integer.parseInt(coapContentTypeString) : MediaTypeRegistry.parse((String)httpContentTypeString);
        }
        if (coapContentType == -1) {
            coapContentType = 42;
        }
        return coapContentType;
    }

    public List<Option> getCoapOptions(Header[] headers) {
        if (headers == null) {
            throw new IllegalArgumentException("httpMessage == null");
        }
        LinkedList<Option> optionList = new LinkedList<Option>();
        for (Header header : headers) {
            try {
                String optionCodeString;
                String headerName = header.getName().toLowerCase();
                if (headerName.startsWith("accept") || (optionCodeString = this.translationMapping.getProperty("http.message.header." + headerName)) == null || optionCodeString.isEmpty()) continue;
                int optionNumber = 0;
                try {
                    optionNumber = Integer.parseInt(optionCodeString.trim());
                }
                catch (Exception e) {
                    LOGGER.warn("Problems in the parsing", (Throwable)e);
                    continue;
                }
                if (optionNumber == 12) continue;
                String headerValue = header.getValue().trim();
                if (optionNumber == 17) {
                    headerValue = headerValue.trim().split(";")[0].trim();
                    for (String headerFragment : headerValue.split(",")) {
                        Integer[] coapContentTypes = new Integer[]{-1};
                        if (headerFragment.contains("*")) {
                            coapContentTypes = MediaTypeRegistry.parseWildcard((String)headerFragment);
                        } else {
                            coapContentTypes[0] = MediaTypeRegistry.parse((String)headerFragment);
                        }
                        Integer[] arr$ = coapContentTypes;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            int coapContentType = arr$[i$];
                            if (coapContentType == -1) continue;
                            Option option = new Option(optionNumber, coapContentType);
                            optionList.add(option);
                        }
                    }
                    continue;
                }
                if (optionNumber == 14) {
                    int maxAge = 0;
                    if (!headerValue.contains("no-cache") && (headerValue = headerValue.split(",")[0]) != null) {
                        int index = headerValue.indexOf(61);
                        try {
                            maxAge = Integer.parseInt(headerValue.substring(index + 1).trim());
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("Cannot convert cache control in max-age option", (Throwable)e);
                            continue;
                        }
                    }
                    Option option = new Option(optionNumber, maxAge);
                    optionList.add(option);
                    continue;
                }
                Option option = new Option(optionNumber);
                switch (OptionNumberRegistry.getFormatByNr((int)optionNumber)) {
                    case INTEGER: {
                        option.setIntegerValue(Integer.parseInt(headerValue));
                        break;
                    }
                    case OPAQUE: {
                        option.setValue(headerValue.getBytes(StandardCharsets.ISO_8859_1));
                        break;
                    }
                    default: {
                        option.setStringValue(headerValue);
                    }
                }
                optionList.add(option);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Could not parse header line {}", (Object)header);
            }
        }
        return optionList;
    }

    public byte[] getCoapPayload(HttpEntity httpEntity) throws TranslationException {
        if (httpEntity == null) {
            throw new IllegalArgumentException("httpEntity == null");
        }
        byte[] payload = null;
        try {
            payload = EntityUtils.toByteArray((HttpEntity)httpEntity);
            if (payload != null && payload.length > 0) {
                Charset coapCharset = StandardCharsets.UTF_8;
                ContentType httpContentType = ContentType.getOrDefault((HttpEntity)httpEntity);
                Charset httpCharset = httpContentType.getCharset();
                if (httpCharset != null && !httpCharset.equals(coapCharset)) {
                    payload = this.changeCharset(payload, httpCharset, coapCharset);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get the content of the http entity: " + e.getMessage());
            throw new TranslationException("Cannot get the content of the http entity", e);
        }
        finally {
            try {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (IOException iOException) {}
        }
        return payload;
    }

    public int getHttpCode(CoAP.ResponseCode coapCode) throws TranslationException {
        Integer httpCode = this.translationMapping.getHttpCode(coapCode);
        if (httpCode == null) {
            LOGGER.warn("httpCode not defined for {}", (Object)coapCode);
            throw new TranslationException("no httpCode for " + coapCode);
        }
        return httpCode;
    }

    public String getHttpMethod(CoAP.Code coapCode) throws TranslationException {
        return this.translationMapping.getHttpMethod(coapCode);
    }

    public HttpEntity getHttpEntity(Message coapMessage) throws TranslationException {
        if (coapMessage == null) {
            throw new IllegalArgumentException("coapMessage == null");
        }
        ByteArrayEntity httpEntity = null;
        byte[] payload = coapMessage.getPayload();
        if (payload != null && payload.length != 0) {
            ContentType contentType = null;
            if (!coapMessage.getOptions().hasContentFormat()) {
                contentType = ContentType.APPLICATION_OCTET_STREAM;
            } else {
                int coapContentType = coapMessage.getOptions().getContentFormat();
                String coapContentTypeString = this.translationMapping.getProperty("coap.message.media." + coapContentType);
                if (coapContentTypeString == null || coapContentTypeString.isEmpty()) {
                    coapContentTypeString = MediaTypeRegistry.toString((int)coapContentType);
                    if (MediaTypeRegistry.isPrintable((int)coapContentType)) {
                        coapContentTypeString = coapContentTypeString + "; charset=UTF-8";
                    }
                }
                try {
                    contentType = ContentType.parse((String)coapContentTypeString);
                }
                catch (UnsupportedCharsetException e) {
                    LOGGER.debug("Cannot convert string to ContentType", (Throwable)e);
                    contentType = ContentType.APPLICATION_OCTET_STREAM;
                }
            }
            Charset charset = contentType.getCharset();
            if (charset != null) {
                byte[] newPayload;
                Charset isoCharset = StandardCharsets.ISO_8859_1;
                if (!charset.equals(isoCharset) && !contentType.getMimeType().equals(ContentType.APPLICATION_JSON.getMimeType()) && (newPayload = this.changeCharset(payload, charset, isoCharset)) != null) {
                    payload = newPayload;
                    contentType = ContentType.create((String)contentType.getMimeType(), (Charset)isoCharset);
                }
                String payloadString = new String(payload, contentType.getCharset());
                httpEntity = new StringEntity(payloadString, contentType);
            } else {
                httpEntity = new ByteArrayEntity(payload);
            }
            ((AbstractHttpEntity)httpEntity).setContentType(contentType.toString());
        }
        return httpEntity;
    }

    public Header[] getHttpHeaders(List<Option> optionList) {
        if (optionList == null) {
            throw new IllegalArgumentException("coapMessage == null");
        }
        LinkedList<BasicHeader> headers = new LinkedList<BasicHeader>();
        for (Option option : optionList) {
            String headerName;
            int optionNumber = option.getNumber();
            if (optionNumber == 12 || optionNumber == 35 || (headerName = this.translationMapping.getProperty("coap.message.option." + optionNumber)) == null || headerName.isEmpty()) continue;
            String stringOptionValue = null;
            if (OptionNumberRegistry.getFormatByNr((int)optionNumber) == OptionNumberRegistry.optionFormats.STRING) {
                stringOptionValue = option.getStringValue();
            } else if (OptionNumberRegistry.getFormatByNr((int)optionNumber) == OptionNumberRegistry.optionFormats.INTEGER) {
                stringOptionValue = Integer.toString(option.getIntegerValue());
            } else {
                if (OptionNumberRegistry.getFormatByNr((int)optionNumber) != OptionNumberRegistry.optionFormats.OPAQUE) continue;
                stringOptionValue = new String(option.getValue());
            }
            if (optionNumber == 14) {
                stringOptionValue = "max-age=" + stringOptionValue;
            }
            BasicHeader header = new BasicHeader(headerName, stringOptionValue);
            headers.add(header);
        }
        return headers.toArray(new Header[0]);
    }

    public Properties getHttpTranslationProperties() {
        return this.translationMapping;
    }

    public byte[] changeCharset(byte[] payload, Charset fromCharset, Charset toCharset) throws TranslationException {
        try {
            CharsetDecoder decoder = fromCharset.newDecoder();
            CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(payload));
            decoder.flush(charBuffer);
            CharsetEncoder encoder = toCharset.newEncoder();
            ByteBuffer byteBuffer = encoder.encode(charBuffer);
            encoder.flush(byteBuffer);
            payload = byteBuffer.array();
        }
        catch (UnmappableCharacterException e) {
            LOGGER.debug("Charset translation: cannot mapped to an output char byte", (Throwable)e);
            return null;
        }
        catch (CharacterCodingException e) {
            LOGGER.warn("Problem in the decoding/encoding charset", (Throwable)e);
            throw new TranslationException("Problem in the decoding/encoding charset", e);
        }
        return payload;
    }
}

