/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.UriHttpAsyncRequestHandlerMapper;
import org.apache.http.protocol.HttpContext;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.proxy2.Http2CoapTranslator;
import org.eclipse.californium.proxy2.HttpServer;
import org.eclipse.californium.proxy2.InvalidFieldException;
import org.eclipse.californium.proxy2.InvalidMethodException;
import org.eclipse.californium.proxy2.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStack {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpStack.class);
    private static final String SERVER_NAME = "Californium Http Proxy";
    private static final String PROXY_RESOURCE_NAME = "proxy";
    public static final String LOCAL_RESOURCE_NAME = "local";
    private final HttpServer server;
    private Http2CoapTranslator translator;
    private MessageDeliverer requestDeliverer;

    public HttpStack(NetworkConfig config, int httpPort) throws IOException {
        this(config, new InetSocketAddress(httpPort));
    }

    public HttpStack(NetworkConfig config, InetSocketAddress httpInterface) throws IOException {
        this.server = new HttpServer(config, httpInterface);
        this.server.setSimpleResource("*", "Californium Http Proxy on %s.", null);
    }

    void setHttpTranslator(Http2CoapTranslator translator) {
        this.translator = translator;
    }

    void registerLocalRequestHandler() {
        UriHttpAsyncRequestHandlerMapper registry = this.server.getRequestHandlerMapper();
        registry.register("/local/*", (HttpAsyncRequestHandler)new ProxyAsyncRequestHandler(LOCAL_RESOURCE_NAME, false));
    }

    void registerProxyRequestHandler() {
        UriHttpAsyncRequestHandlerMapper registry = this.server.getRequestHandlerMapper();
        ProxyAsyncRequestHandler handler = new ProxyAsyncRequestHandler(PROXY_RESOURCE_NAME, true);
        registry.register("/proxy/*", (HttpAsyncRequestHandler)handler);
        registry.register("/proxy", (HttpAsyncRequestHandler)handler);
        registry.register("http*", (HttpAsyncRequestHandler)handler);
    }

    void registerHttpProxyRequestHandler() {
        UriHttpAsyncRequestHandlerMapper registry = this.server.getRequestHandlerMapper();
        registry.register("http*", (HttpAsyncRequestHandler)new ProxyAsyncRequestHandler(PROXY_RESOURCE_NAME, true));
    }

    public void start() throws IOException {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    public void setRequestDeliverer(MessageDeliverer requestDeliverer) {
        this.requestDeliverer = requestDeliverer;
    }

    private void sendHttpResponse(HttpAsyncExchange httpExchange, Response coapResponse) {
        LOGGER.debug("Incoming response: {}", (Object)coapResponse);
        HttpResponse httpResponse = httpExchange.getResponse();
        try {
            this.translator.getHttpResponse(httpExchange.getRequest(), coapResponse, httpResponse);
            LOGGER.debug("Outgoing http response: {}", (Object)httpResponse.getStatusLine());
            httpExchange.submitResponse();
        }
        catch (TranslationException e) {
            LOGGER.warn("Failed to translate coap response to http response: {}", (Object)e.getMessage());
            HttpStack.sendSimpleHttpResponse(httpExchange, 502, null);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to translate coap response to http response: {}", (Object)e.getMessage(), (Object)e);
            HttpStack.sendSimpleHttpResponse(httpExchange, 502, null);
        }
    }

    private static void sendSimpleHttpResponse(HttpAsyncExchange httpExchange, int httpCode, String message) {
        HttpResponse httpResponse = httpExchange.getResponse();
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(httpCode, Locale.ENGLISH);
        BasicStatusLine statusLine = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, httpCode, reason);
        httpResponse.setStatusLine((StatusLine)statusLine);
        try {
            StringBuilder payload = new StringBuilder();
            payload.append(httpCode).append(": ").append(reason);
            if (message != null) {
                payload.append("\r\n\r\n").append(message);
            }
            StringEntity entity = new StringEntity(payload.toString());
            httpResponse.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        httpExchange.submitResponse();
    }

    private class ProxyAsyncRequestHandler
    implements HttpAsyncRequestHandler<HttpRequest> {
        private final String resourceName;
        private final boolean proxyingEnabled;

        public ProxyAsyncRequestHandler(String resourceName, boolean proxyingEnabled) {
            this.resourceName = resourceName;
            this.proxyingEnabled = proxyingEnabled;
        }

        public void handle(HttpRequest httpRequest, final HttpAsyncExchange httpExchange, HttpContext httpContext) throws HttpException, IOException {
            HttpInetConnection connection = (HttpInetConnection)httpContext.getAttribute("http.connection");
            InetSocketAddress endpoint = new InetSocketAddress(connection.getLocalAddress(), connection.getLocalPort());
            InetSocketAddress source = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            LOGGER.debug("handler {}, proxy {}", (Object)this.resourceName, (Object)this.proxyingEnabled);
            LOGGER.debug("Incoming http request: on {} from {}{}   {}", new Object[]{endpoint, source, StringUtil.lineSeparator(), httpRequest.getRequestLine()});
            try {
                final Request coapRequest = HttpStack.this.translator.getCoapRequest(httpRequest, this.resourceName, this.proxyingEnabled);
                LOGGER.info("Received HTTP request and translate to {}", (Object)coapRequest);
                coapRequest.setSourceContext((EndpointContext)new AddressEndpointContext(source));
                coapRequest.setDestinationContext((EndpointContext)new AddressEndpointContext(endpoint));
                Exchange exchange = new Exchange(coapRequest, Exchange.Origin.REMOTE, null){

                    public void sendAccept() {
                    }

                    public void sendReject() {
                        HttpStack.sendSimpleHttpResponse(httpExchange, 502, null);
                    }

                    public void sendResponse(Response response) {
                        coapRequest.setResponse(response);
                        HttpStack.this.sendHttpResponse(httpExchange, response);
                        LOGGER.debug("HTTP returned {}", (Object)response);
                    }
                };
                HttpStack.this.requestDeliverer.deliverRequest(exchange);
            }
            catch (InvalidMethodException e) {
                LOGGER.warn("Method not implemented", (Throwable)e);
                HttpStack.sendSimpleHttpResponse(httpExchange, 501, e.getMessage());
            }
            catch (InvalidFieldException e) {
                LOGGER.warn("Request malformed", (Throwable)e);
                HttpStack.sendSimpleHttpResponse(httpExchange, 400, e.getMessage());
            }
            catch (TranslationException e) {
                LOGGER.warn("Failed to translate the http request in a valid coap request", (Throwable)e);
                HttpStack.sendSimpleHttpResponse(httpExchange, 502, e.getMessage());
            }
            catch (Throwable e) {
                LOGGER.error("Unexpected error", e);
                HttpStack.sendSimpleHttpResponse(httpExchange, 500, e.getMessage());
            }
        }

        public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            return new BasicAsyncRequestConsumer();
        }
    }
}

