/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.net.URI;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicRequestLine;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.HttpTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coap2HttpTranslator
extends CoapUriTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Coap2HttpTranslator.class);
    protected final HttpTranslator httpTranslator;

    public Coap2HttpTranslator(String mappingPropertiesFileName) {
        this.httpTranslator = new HttpTranslator(mappingPropertiesFileName);
    }

    public Coap2HttpTranslator() {
        this.httpTranslator = new HttpTranslator();
    }

    public HttpRequest getHttpRequest(URI uri, Request coapRequest) throws TranslationException {
        Header[] headers;
        BasicHttpRequest httpRequest;
        if (coapRequest == null) {
            throw new IllegalArgumentException("coapRequest == null");
        }
        String coapMethod = this.httpTranslator.getHttpMethod(coapRequest.getCode());
        BasicRequestLine requestLine = new BasicRequestLine(coapMethod, uri.toASCIIString(), (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpEntity httpEntity = this.httpTranslator.getHttpEntity((Message)coapRequest);
        if (httpEntity == null) {
            httpRequest = new BasicHttpRequest((RequestLine)requestLine);
        } else {
            httpRequest = new BasicHttpEntityEnclosingRequest((RequestLine)requestLine);
            ((HttpEntityEnclosingRequest)httpRequest).setEntity(httpEntity);
            ContentType contentType = ContentType.get((HttpEntity)httpEntity);
            httpRequest.setHeader("content-type", contentType.toString());
        }
        for (Header header : headers = this.httpTranslator.getHttpHeaders(coapRequest.getOptions().asSortedList())) {
            httpRequest.addHeader(header);
        }
        LOGGER.debug("Incoming request translated correctly");
        return httpRequest;
    }

    public Response getCoapResponse(HttpResponse httpResponse, Request coapRequest) throws TranslationException {
        byte[] payload;
        HttpEntity httpEntity;
        if (httpResponse == null) {
            throw new IllegalArgumentException("httpResponse == null");
        }
        if (coapRequest == null) {
            throw new IllegalArgumentException("coapRequest == null");
        }
        int httpCode = httpResponse.getStatusLine().getStatusCode();
        CoAP.Code coapMethod = coapRequest.getCode();
        if (httpCode == 204) {
            httpCode += 10000 * coapMethod.value;
        }
        CoAP.ResponseCode coapCode = this.httpTranslator.getCoapResponseCode(httpCode);
        Response coapResponse = new Response(coapCode);
        List<Option> coapOptions = this.httpTranslator.getCoapOptions(httpResponse.getAllHeaders());
        for (Option option : coapOptions) {
            coapResponse.getOptions().addOption(option);
        }
        if (!coapResponse.getOptions().hasMaxAge()) {
            if (coapMethod == CoAP.Code.GET) {
                coapResponse.getOptions().setMaxAge(60L);
            } else {
                coapResponse.getOptions().setMaxAge(0L);
            }
        }
        if ((httpEntity = httpResponse.getEntity()) != null && (payload = this.httpTranslator.getCoapPayload(httpEntity)) != null && payload.length > 0) {
            coapResponse.setPayload(payload);
            int coapContentType = this.httpTranslator.getCoapMediaType((HttpMessage)httpResponse);
            coapResponse.getOptions().setContentFormat(coapContentType);
        }
        LOGGER.debug("Incoming response translated correctly");
        return coapResponse;
    }
}

