/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ConcurrentModificationException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.proxy2.resources.CacheKey;
import org.eclipse.californium.proxy2.resources.CacheResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyCacheResource
extends CoapResource
implements CacheResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyCacheResource.class);
    private static final int CACHE_RESPONSE_MAX_AGE = NetworkConfig.getStandard().getInt("HTTP_CACHE_RESPONSE_MAX_AGE");
    private static final long CACHE_SIZE = NetworkConfig.getStandard().getInt("HTTP_CACHE_SIZE");
    private final LoadingCache<CacheKey, Response> responseCache;
    private final ConcurrentMap<URI, Set<CacheKey>> resourceCache = new ConcurrentHashMap<URI, Set<CacheKey>>();
    private final ReentrantLock lock = new ReentrantLock();
    private boolean enabled = false;

    public ProxyCacheResource() {
        this(false);
    }

    public ProxyCacheResource(boolean enabled) {
        super("cache");
        this.enabled = enabled;
        this.responseCache = CacheBuilder.newBuilder().maximumSize(CACHE_SIZE).recordStats().expireAfterWrite((long)CACHE_RESPONSE_MAX_AGE, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<CacheKey, Response>(){

            public void onRemoval(RemovalNotification<CacheKey, Response> notification) {
                ProxyCacheResource.this.removeFromResourceCache((CacheKey)notification.getKey());
            }
        }).build((CacheLoader)new CacheLoader<CacheKey, Response>(){

            public Response load(CacheKey request) throws NullPointerException {
                Response cachedResponse = request.getResponse();
                if (cachedResponse == null) {
                    throw new NullPointerException();
                }
                return cachedResponse;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheResponse(CacheKey cacheKey, Response response) {
        if (!this.enabled) {
            return;
        }
        CoAP.ResponseCode code = response.getCode();
        if (CoAP.ResponseCode.isSuccess((CoAP.ResponseCode)code)) {
            this.lock.lock();
            try {
                this.internalCacheResponse(cacheKey, response, true);
                int contentFormat = response.getOptions().getContentFormat();
                if (contentFormat != -1) {
                    int alternativeFormat = cacheKey.getMediaType() == contentFormat ? -1 : contentFormat;
                    this.internalCacheResponse(CacheKey.fromCacheKey(cacheKey, alternativeFormat), response, false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void internalCacheResponse(CacheKey cacheKey, Response response, boolean all) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new ConcurrentModificationException("cache has pending access!");
        }
        CoAP.ResponseCode code = response.getCode();
        if (code == CoAP.ResponseCode.CREATED || code == CoAP.ResponseCode.DELETED || code == CoAP.ResponseCode.CHANGED) {
            if (all) {
                URI uri = cacheKey.getUri();
                if (response.getOptions().getLocationPathCount() > 0) {
                    String locationPath = response.getOptions().getLocationPathString();
                    uri = this.getResourceUri(uri, locationPath);
                } else {
                    uri = this.getResourceUri(uri);
                }
                this.invalidate(uri);
            }
        } else if (code == CoAP.ResponseCode.VALID) {
            Long maxAgeOption = response.getOptions().getMaxAge();
            if (maxAgeOption != null) {
                Response cachedResponse = (Response)this.responseCache.getIfPresent((Object)cacheKey);
                if (cachedResponse != null) {
                    long newCurrentTime = response.getNanoTimestamp();
                    long newMaxAge = maxAgeOption;
                    cachedResponse.getOptions().setMaxAge(newMaxAge);
                    cachedResponse.setNanoTimestamp(newCurrentTime);
                    LOGGER.debug("Updated cached response");
                }
            } else {
                LOGGER.warn("No max-age option set in response: {}", (Object)response);
            }
        } else if (code == CoAP.ResponseCode.CONTENT) {
            long maxAgeOption = response.getOptions().getMaxAge();
            if (maxAgeOption > 0L) {
                try {
                    Set previousKeys;
                    URI resource = this.getResourceUri(cacheKey.getUri());
                    Set<CacheKey> keys = (CopyOnWriteArraySet<CacheKey>)this.resourceCache.get(resource);
                    if (keys == null && (previousKeys = (Set)this.resourceCache.putIfAbsent(resource, keys = new CopyOnWriteArraySet<CacheKey>())) != null) {
                        keys = previousKeys;
                    }
                    if (keys.add(cacheKey)) {
                        LOGGER.debug("Add new response to resource {}, {} responses", (Object)resource, (Object)keys.size());
                    } else {
                        LOGGER.debug("Refresh response for resource {}, {} responses", (Object)resource, (Object)keys.size());
                    }
                    cacheKey.setResponse(response);
                    Response responseInserted = (Response)this.responseCache.get((Object)cacheKey);
                    if (responseInserted != null) {
                        LOGGER.debug("Cached response {}#hc={}", (Object)cacheKey, (Object)cacheKey.hashCode());
                    } else {
                        LOGGER.warn("Failed to insert the response in the cache");
                    }
                    cacheKey.setResponse(null);
                }
                catch (UncheckedExecutionException e) {
                    LOGGER.warn("Exception while inserting the response in the cache", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOGGER.warn("Exception while inserting the response in the cache", (Throwable)e);
                }
            } else {
                this.invalidate(cacheKey);
            }
        } else {
            LOGGER.error("Code not recognized: {}", (Object)code);
        }
    }

    @Override
    public CacheStats getCacheStats() {
        return this.responseCache.stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getResponse(CacheKey cacheKey) {
        if (!this.enabled) {
            return null;
        }
        Response response = (Response)this.responseCache.getIfPresent((Object)cacheKey);
        LOGGER.debug("Cache read {}#hc={}", (Object)cacheKey, (Object)cacheKey.hashCode());
        if (response != null) {
            LOGGER.debug("Cache hit");
            long currentTime = ClockUtil.nanoRealtime();
            long secondsLeft = this.getRemainingLifetime(response, currentTime);
            if (secondsLeft <= 0L) {
                LOGGER.debug("Expired response");
                this.lock.lock();
                try {
                    Response validatedResponse = this.validate(cacheKey);
                    if (validatedResponse != null) {
                        LOGGER.debug("Validation successful");
                        response = validatedResponse;
                        currentTime = ClockUtil.nanoRealtime();
                        secondsLeft = this.getRemainingLifetime(response, currentTime);
                    } else {
                        this.invalidate(response, cacheKey);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (secondsLeft > 0L) {
                Response proxyResponse = new Response(response.getCode());
                proxyResponse.setOptions(new OptionSet(response.getOptions()));
                proxyResponse.setPayload(response.getPayload());
                proxyResponse.getOptions().setMaxAge(secondsLeft);
                return proxyResponse;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateRequest(CacheKey cacheKey) {
        URI resource = this.getResourceUri(cacheKey.getUri());
        this.lock.lock();
        try {
            this.invalidate(resource);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDELETE(CoapExchange exchange) {
        this.lock.lock();
        try {
            this.responseCache.invalidateAll();
            this.resourceCache.clear();
        }
        finally {
            this.lock.unlock();
        }
        exchange.respond(CoAP.ResponseCode.DELETED);
    }

    public void handleGET(CoapExchange exchange) {
        StringBuilder builder = new StringBuilder();
        builder.append("Available commands:\n - GET: show cached values\n - DELETE: empty the cache\n - POST: enable/disable caching\n");
        long currentTime = ClockUtil.nanoRealtime();
        builder.append("\nCached values:\n");
        for (CacheKey cachedRequest : this.responseCache.asMap().keySet()) {
            Response response = (Response)this.responseCache.asMap().get(cachedRequest);
            builder.append(cachedRequest.getUri()).append(" (").append(MediaTypeRegistry.toString((int)cachedRequest.getMediaType())).append(") > ").append(this.getRemainingLifetime(response, currentTime)).append(" seconds").append(")\n");
        }
        exchange.respond(CoAP.ResponseCode.CONTENT, builder.toString());
    }

    public void handlePOST(CoapExchange exchange) {
        this.enabled = !this.enabled;
        String content = this.enabled ? "Enabled" : "Disabled";
        exchange.respond(CoAP.ResponseCode.CHANGED, content);
    }

    private long getRemainingLifetime(Response response, long currentTime) {
        long nanoSecondsInCache = currentTime - response.getNanoTimestamp();
        long maxAgeInNanoSeconds = TimeUnit.SECONDS.toNanos(response.getOptions().getMaxAge());
        return TimeUnit.NANOSECONDS.toSeconds(maxAgeInNanoSeconds - nanoSecondsInCache + 500000000L);
    }

    private void invalidate(Response response, CacheKey cacheKey) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new ConcurrentModificationException("cache has pending access!");
        }
        this.invalidate(cacheKey);
        int contentType = response.getOptions().getContentFormat();
        if (contentType != -1) {
            if (cacheKey.getMediaType() == -1) {
                this.invalidate(CacheKey.fromCacheKey(cacheKey, contentType));
            } else {
                CacheKey cacheKeyWithoutContentType = CacheKey.fromCacheKey(cacheKey, -1);
                if (response == this.responseCache.getIfPresent((Object)cacheKeyWithoutContentType)) {
                    this.invalidate(cacheKeyWithoutContentType);
                }
            }
        }
    }

    private void removeFromResourceCache(CacheKey cacheKey) {
        URI resource = this.getResourceUri(cacheKey.getUri());
        Set set = (Set)this.resourceCache.remove(resource);
        if (set != null) {
            set.remove(cacheKey);
        }
    }

    private void invalidate(URI uri) {
        Set set = (Set)this.resourceCache.remove(uri);
        if (set != null) {
            LOGGER.debug("Invalidate resource {}, {} responses", (Object)uri, (Object)set.size());
            for (CacheKey cacheKey : set) {
                this.invalidate(cacheKey);
            }
        }
    }

    private URI getResourceUri(URI uri) {
        if (uri.getQuery() != null || uri.getFragment() != null) {
            try {
                uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("URI malformed {}", (Object)uri, (Object)e);
            }
        }
        return uri;
    }

    private URI getResourceUri(URI uri, String locationPath) {
        try {
            uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), locationPath, null, null);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("URI malformed {}", (Object)uri, (Object)e);
        }
        return uri;
    }

    private void invalidate(CacheKey cacheKey) {
        this.responseCache.invalidate((Object)cacheKey);
    }

    private Response validate(CacheKey cachedRequest) {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

