/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2.resources;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.proxy2.CoapUriTranslator;
import org.eclipse.californium.proxy2.TranslationException;
import org.eclipse.californium.proxy2.resources.ProxyCoapResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyMessageDeliverer
extends ServerMessageDeliverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardProxyMessageDeliverer.class);
    private final CoapUriTranslator translator;
    private final Map<String, Resource> scheme2resource;
    private final Set<InetSocketAddress> exposedServices;
    private final Set<InetAddress> exposedHosts;
    private final Set<Integer> exposedPorts;

    public ForwardProxyMessageDeliverer(Resource root, CoapUriTranslator translator) {
        super(root);
        this.translator = translator;
        this.scheme2resource = new HashMap<String, Resource>();
        this.exposedServices = new HashSet<InetSocketAddress>();
        this.exposedPorts = new HashSet<Integer>();
        this.exposedHosts = new HashSet<InetAddress>();
    }

    public ForwardProxyMessageDeliverer(ProxyCoapResource proxyCoapResource) {
        this(null, proxyCoapResource.getUriTranslater());
        this.addProxyCoapResources(proxyCoapResource);
    }

    public ForwardProxyMessageDeliverer addExposedServiceAddresses(InetSocketAddress ... exposed) {
        if (exposed == null) {
            throw new NullPointerException("exposed interfaces must not be null!");
        }
        if (exposed.length == 0) {
            throw new IllegalArgumentException("exposed interfaces must not be empty!");
        }
        Collection all = NetworkInterfacesUtil.getNetworkInterfaces();
        for (InetSocketAddress inetAddress : exposed) {
            LOGGER.info("address {}", (Object)inetAddress);
            this.exposedPorts.add(inetAddress.getPort());
            InetAddress address = inetAddress.getAddress();
            if (address.isAnyLocalAddress()) {
                for (InetAddress eAddress : all) {
                    this.exposedServices.add(new InetSocketAddress(eAddress, inetAddress.getPort()));
                    this.exposedHosts.add(eAddress);
                }
                continue;
            }
            this.exposedServices.add(inetAddress);
            this.exposedHosts.add(address);
        }
        for (Integer port : this.exposedPorts) {
            LOGGER.info("Exposed port {}", (Object)port);
        }
        for (InetAddress address : this.exposedHosts) {
            LOGGER.info("Exposed host {}", (Object)address);
        }
        for (InetSocketAddress inetAddress : this.exposedServices) {
            LOGGER.info("Exposed service {}", (Object)inetAddress);
        }
        return this;
    }

    public ForwardProxyMessageDeliverer addProxyCoapResources(ProxyCoapResource ... proxies) {
        if (proxies == null) {
            throw new NullPointerException("proxies must not be null!");
        }
        if (proxies.length == 0) {
            throw new IllegalArgumentException("proxies must not be empty!");
        }
        for (ProxyCoapResource proxy : proxies) {
            Set<String> schemes = proxy.getDestinationSchemes();
            for (String scheme : schemes) {
                if (this.scheme2resource.put(scheme, (Resource)proxy) == null) continue;
                LOGGER.warn("ambig proxy resource for scheme {}!", (Object)scheme);
            }
        }
        return this;
    }

    protected Resource findResource(Exchange exchange) {
        boolean local;
        boolean hostOption;
        boolean proxyOption;
        Request request;
        Resource resource;
        block19: {
            resource = null;
            request = exchange.getRequest();
            OptionSet options = request.getOptions();
            proxyOption = options.hasProxyUri() || options.hasProxyScheme();
            hostOption = options.hasUriHost() || options.hasUriPort();
            local = true;
            if (hostOption && !this.exposedServices.isEmpty()) {
                Integer port = options.getUriPort();
                String host = options.getUriHost();
                if (host == null) {
                    if (this.exposedPorts.contains(port)) {
                        hostOption = false;
                    } else {
                        local = false;
                    }
                } else if (port == null) {
                    try {
                        InetAddress address = InetAddress.getByName(host);
                        if (this.exposedHosts.contains(address)) {
                            hostOption = false;
                            break block19;
                        }
                        local = false;
                    }
                    catch (UnknownHostException e) {
                        hostOption = false;
                    }
                } else {
                    InetSocketAddress destination = new InetSocketAddress(host, (int)port);
                    if (destination.isUnresolved() || this.exposedServices.contains(destination)) {
                        hostOption = false;
                    } else {
                        local = false;
                    }
                }
            }
        }
        if (proxyOption || hostOption) {
            try {
                String scheme = this.translator.getDestinationScheme(request);
                if (scheme != null) {
                    resource = this.scheme2resource.get(scheme = scheme.toLowerCase());
                    if (resource != null && request.getDestinationContext() == null) {
                        this.preserveReceivingInterface(exchange);
                    }
                } else {
                    local = true;
                }
            }
            catch (TranslationException e) {
                LOGGER.debug("Bad proxy request", (Throwable)e);
            }
        }
        if (resource == null && local) {
            resource = super.findResource(exchange);
        }
        return resource;
    }

    private void preserveReceivingInterface(Exchange exchange) {
        if (exchange.getEndpoint() != null) {
            exchange.getRequest().setDestinationContext((EndpointContext)new AddressEndpointContext(exchange.getEndpoint().getAddress()));
        }
    }
}

